
CREATE TABLE IF NOT EXISTS `channel_account`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `name` varchar(20)  NOT NULL COMMENT '名称 ',
  `account` varchar(255)  NOT NULL COMMENT '账号（针对微信公众号即为appId）',
  `type` int(4) NOT NULL DEFAULT 0 COMMENT '类型[0微信订阅号 1微信服务号 2抖音 3快手 4淘宝 5支付宝 6facebook] ',
  `config` varchar(1024)  NOT NULL COMMENT '配置信息',
  `head_img` varchar(255)  NOT NULL COMMENT '头像链接',
  `extension` varchar(1024)  NOT NULL DEFAULT '' COMMENT '扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(4) NOT NULL DEFAULT '1000-01-01 00:00:00.0000' COMMENT '创建时间',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '微信公众号信息' ROW_FORMAT = Dynamic;