/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.flow.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.enhance.flow.INodeLinkEo;
import com.dtyunxi.cube.enhance.flow.NodeConvertMap;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.starter.bundle.dto.response.BundleFlowDto;
import com.dtyunxi.cube.starter.bundle.materiel.consumer.das.AbstractBaseDas;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.flow.api.constants.Common;
import com.dtyunxi.yundt.cube.center.flow.api.constants.FlowNodeType;
import com.dtyunxi.yundt.cube.center.flow.api.constants.FlowPreNodeCode;
import com.dtyunxi.yundt.cube.center.flow.api.constants.FlowPreResultStatus;
import com.dtyunxi.yundt.cube.center.flow.api.constants.FlowSolutionType;
import com.dtyunxi.yundt.cube.center.flow.api.constants.FlowStatusType;
import com.dtyunxi.yundt.cube.center.flow.api.constants.RedisKeyConstants;
import com.dtyunxi.yundt.cube.center.flow.api.dto.base.FlwSolutionMapDto;
import com.dtyunxi.yundt.cube.center.flow.api.dto.export.FlowSolutionDto;
import com.dtyunxi.yundt.cube.center.flow.api.dto.request.FlwDocQueryReqDto;
import com.dtyunxi.yundt.cube.center.flow.api.dto.request.FlwNodeConvertMapReqDto;
import com.dtyunxi.yundt.cube.center.flow.api.dto.request.FlwSolutionCreateReqDto;
import com.dtyunxi.yundt.cube.center.flow.api.dto.request.FlwSolutionModifyReqDto;
import com.dtyunxi.yundt.cube.center.flow.api.dto.request.FlwSolutionQueryReqDto;
import com.dtyunxi.yundt.cube.center.flow.api.dto.request.FlwStatusCreateReqDto;
import com.dtyunxi.yundt.cube.center.flow.api.dto.request.FlwStatusDto;
import com.dtyunxi.yundt.cube.center.flow.api.dto.request.FlwStatusModifyDto;
import com.dtyunxi.yundt.cube.center.flow.api.dto.response.ActionNodeResultDto;
import com.dtyunxi.yundt.cube.center.flow.api.dto.response.FlwActionNodeRespDto;
import com.dtyunxi.yundt.cube.center.flow.api.dto.response.FlwActionStatusRespDto;
import com.dtyunxi.yundt.cube.center.flow.api.dto.response.FlwActiveDefResp;
import com.dtyunxi.yundt.cube.center.flow.api.dto.response.FlwDocRespDto;
import com.dtyunxi.yundt.cube.center.flow.api.dto.response.FlwNodeLinkCoreInfoDto;
import com.dtyunxi.yundt.cube.center.flow.api.dto.response.FlwNodeLinkDto;
import com.dtyunxi.yundt.cube.center.flow.api.dto.response.FlwNodeLinkItem;
import com.dtyunxi.yundt.cube.center.flow.api.dto.response.FlwNodeParamDto;
import com.dtyunxi.yundt.cube.center.flow.api.dto.response.FlwSolutionConvertNodeMapDto;
import com.dtyunxi.yundt.cube.center.flow.api.dto.response.FlwSolutionDetailDto;
import com.dtyunxi.yundt.cube.center.flow.api.dto.response.FlwSolutionRespDto;
import com.dtyunxi.yundt.cube.center.flow.api.dto.response.FlwStatusDetailDto;
import com.dtyunxi.yundt.cube.center.flow.api.dto.response.FlwStatusFieldRespDto;
import com.dtyunxi.yundt.cube.center.flow.api.dto.response.FlwStatusRespDto;
import com.dtyunxi.yundt.cube.center.flow.biz.service.IFlowService;
import com.dtyunxi.yundt.cube.center.flow.biz.service.IFlwNodeConvertMapService;
import com.dtyunxi.yundt.cube.center.flow.biz.util.SqlFilterBuilder;
import com.dtyunxi.yundt.cube.center.flow.dao.das.FlwColorPoolDas;
import com.dtyunxi.yundt.cube.center.flow.dao.das.FlwConvertNodeDas;
import com.dtyunxi.yundt.cube.center.flow.dao.das.FlwDocDas;
import com.dtyunxi.yundt.cube.center.flow.dao.das.FlwNodeDas;
import com.dtyunxi.yundt.cube.center.flow.dao.das.FlwNodeLinkDas;
import com.dtyunxi.yundt.cube.center.flow.dao.das.FlwNodeResultCallDas;
import com.dtyunxi.yundt.cube.center.flow.dao.das.FlwNodeResultDas;
import com.dtyunxi.yundt.cube.center.flow.dao.das.FlwSolutionDas;
import com.dtyunxi.yundt.cube.center.flow.dao.das.FlwStatusDas;
import com.dtyunxi.yundt.cube.center.flow.dao.eo.FlwColorPoolEo;
import com.dtyunxi.yundt.cube.center.flow.dao.eo.FlwConvertNodeEo;
import com.dtyunxi.yundt.cube.center.flow.dao.eo.FlwDocEo;
import com.dtyunxi.yundt.cube.center.flow.dao.eo.FlwNodeEo;
import com.dtyunxi.yundt.cube.center.flow.dao.eo.FlwNodeLinkEo;
import com.dtyunxi.yundt.cube.center.flow.dao.eo.FlwNodeResultCallEo;
import com.dtyunxi.yundt.cube.center.flow.dao.eo.FlwNodeResultEo;
import com.dtyunxi.yundt.cube.center.flow.dao.eo.FlwSolutionEo;
import com.dtyunxi.yundt.cube.center.flow.dao.eo.FlwStatusEo;
import com.dtyunxi.yundt.cube.center.flow.dao.eo.StdFlwColorPoolEo;
import com.dtyunxi.yundt.cube.center.flow.dao.eo.StdFlwDocEo;
import com.dtyunxi.yundt.cube.center.flow.dao.eo.StdFlwNodeEo;
import com.dtyunxi.yundt.cube.center.flow.dao.eo.StdFlwNodeResultCallEo;
import com.dtyunxi.yundt.cube.center.flow.dao.eo.StdFlwNodeResultEo;
import com.dtyunxi.yundt.cube.center.func.api.constants.Constants;
import com.dtyunxi.yundt.cube.center.func.biz.util.IDataUpdater;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class FlowServiceImpl
implements IFlowService,
EnvironmentAware {
    protected static Logger LOGGER = LoggerFactory.getLogger(FlowServiceImpl.class);
    @Resource
    private FlwNodeLinkDas flwNodeLinkDas;
    @Resource
    private FlwSolutionDas flwSolutionDas;
    @Resource
    private FlwStatusDas flwStatusDas;
    @Resource
    private FlwNodeDas flwNodeDas;
    @Resource
    private FlwNodeResultDas flwNodeResultDas;
    @Resource
    private FlwNodeResultCallDas flwNodeResultCallDas;
    @Resource
    private FlwDocDas flwDocDas;
    @Resource
    private FlwColorPoolDas flwColorPoolDas;
    @Resource
    private FlwConvertNodeDas flwConvertNodeDas;
    @Autowired
    private IFlwNodeConvertMapService flwNodeConvertMapService;
    @Autowired
    private ICommonsMqService commonsMqService;
    private static final String NODE_NONE = "NONE";
    private static final String VERSION_PRE = "V";
    private static final String STATUS_SIGN = "#";
    private Environment environment;

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @Override
    public List<FlowSolutionDto> listEnabledFLowSolution(String type) {
        FlwSolutionEo selectParam = new FlwSolutionEo();
        selectParam.setType(type);
        selectParam.setStatus(Constants.ENABLE);
        selectParam.setCurShow(Constants.ENABLE);
        List list = this.flwSolutionDas.select((BaseEo)selectParam);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.EMPTY_LIST;
        }
        return Lists.newArrayList(list.parallelStream().map(item -> {
            FlowSolutionDto flowSolutionDto = new FlowSolutionDto();
            BeanUtils.copyProperties((Object)item, (Object)flowSolutionDto);
            return flowSolutionDto;
        }).collect(Collectors.groupingBy(FlowSolutionDto::getCode, Collectors.collectingAndThen(Collectors.reducing((v1, v2) -> v1.getVersion().compareTo(v2.getVersion()) > 0 ? v1 : v2), Optional::get))).values());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long createFlwSolution(FlwSolutionCreateReqDto flwSolutionCreateReqDto) {
        FlwSolutionEo lastVersionEo;
        FlwSolutionEo flwSolutionEo = new FlwSolutionEo();
        DtoHelper.dto2Eo((BaseVo)flwSolutionCreateReqDto, (BaseEo)flwSolutionEo, (String[])new String[]{"id"});
        String versionPrefix = VERSION_PRE;
        if (flwSolutionCreateReqDto.getUpgradeId() != null && (lastVersionEo = (FlwSolutionEo)this.flwSolutionDas.selectByPrimaryKey(flwSolutionCreateReqDto.getUpgradeId())) != null) {
            String version = lastVersionEo.getVersion();
            version = version.replaceFirst(VERSION_PRE, "");
            Integer versionNum = Integer.parseInt(version);
            versionNum = versionNum + 1;
            FlwSolutionEo queryNameEo = new FlwSolutionEo();
            queryNameEo.setName(flwSolutionCreateReqDto.getName());
            queryNameEo.setVersion(VERSION_PRE + versionNum);
            List resultEos = this.flwSolutionDas.select((BaseEo)queryNameEo, Integer.valueOf(1), Integer.valueOf(1));
            if (CollectionUtils.isNotEmpty((Collection)resultEos)) {
                throw new BizException("\u6d41\u7a0b\u65b9\u6848\u540d\u79f0\u91cd\u590d\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u7248\u672c\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u6d41\u7a0b\u65b9\u6848\u540d\u79f0");
            }
            flwSolutionEo.setCode(lastVersionEo.getCode());
            flwSolutionEo.setVersion(VERSION_PRE + versionNum);
        } else {
            flwSolutionEo.setCode(this.getSolutionCode());
            FlwSolutionEo queryNameEo = new FlwSolutionEo();
            queryNameEo.setName(flwSolutionCreateReqDto.getName());
            queryNameEo.setVersion("V1");
            List resultEos = this.flwSolutionDas.select((BaseEo)queryNameEo, Integer.valueOf(1), Integer.valueOf(1));
            if (CollectionUtils.isNotEmpty((Collection)resultEos)) {
                throw new BizException("\u6d41\u7a0b\u65b9\u6848\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u91cd\u8f93");
            }
            flwSolutionEo.setVersion("V1");
        }
        flwSolutionEo.setName(flwSolutionCreateReqDto.getName());
        if (StringUtils.isEmpty((CharSequence)flwSolutionEo.getType())) {
            flwSolutionEo.setType(FlowSolutionType.TRADE.getValue());
        }
        this.disableCurShowFlag(flwSolutionEo);
        flwSolutionEo.setCurShow(Constants.ENABLE);
        if (flwSolutionEo.getExtension() == null) {
            flwSolutionEo.setExtension("");
        }
        this.flwSolutionDas.insert((BaseEo)flwSolutionEo);
        Long flwSolutionId = flwSolutionEo.getId();
        List flwNodeLinkDtos = flwSolutionCreateReqDto.getFlwNodeLinkDtos();
        if (CollectionUtils.isNotEmpty((Collection)flwNodeLinkDtos)) {
            this.processNodeLink(flwSolutionId, flwNodeLinkDtos, flwSolutionCreateReqDto.getConvertNodeMaps());
        }
        this.publish();
        return flwSolutionId;
    }

    private void disableCurShowFlag(FlwSolutionEo flwSolutionEo) {
        FlwSolutionEo updateEo = new FlwSolutionEo();
        updateEo.setCurShow(Constants.DISABLE);
        updateEo.setSqlFilters(SqlFilterBuilder.newInstance().buildEqualsSqlFilter("code", flwSolutionEo.getCode()).get());
        this.flwSolutionDas.updateSelectiveSqlFilter((BaseEo)updateEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyFlwSolution(FlwSolutionModifyReqDto flwSolutionModifyReqDto) {
        FlwSolutionEo eo = (FlwSolutionEo)this.flwSolutionDas.selectByPrimaryKey(flwSolutionModifyReqDto.getId());
        FlwSolutionEo queryNameEo = new FlwSolutionEo();
        queryNameEo.setName(flwSolutionModifyReqDto.getName());
        queryNameEo.setVersion(eo.getVersion());
        List resultEos = this.flwSolutionDas.select((BaseEo)queryNameEo, Integer.valueOf(1), Integer.valueOf(1));
        if (CollectionUtils.isNotEmpty((Collection)resultEos) && !((FlwSolutionEo)resultEos.get(0)).getId().equals(flwSolutionModifyReqDto.getId())) {
            throw new BizException("\u6d41\u7a0b\u65b9\u6848\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u91cd\u8f93");
        }
        FlwSolutionEo flwSolutionEo = new FlwSolutionEo();
        DtoHelper.dto2Eo((BaseVo)flwSolutionModifyReqDto, (BaseEo)flwSolutionEo, (String[])new String[]{"type"});
        if (StringUtils.isEmpty((CharSequence)flwSolutionEo.getType())) {
            flwSolutionEo.setType(FlowSolutionType.TRADE.getValue());
        }
        this.flwSolutionDas.updateSelective((BaseEo)flwSolutionEo);
        this.flwNodeLinkDas.logicDelete(flwSolutionModifyReqDto.getId());
        List flwNodeLinkDtos = flwSolutionModifyReqDto.getFlwNodeLinkDtos();
        if (CollectionUtils.isNotEmpty((Collection)flwNodeLinkDtos)) {
            this.processNodeLink(flwSolutionModifyReqDto.getId(), flwNodeLinkDtos, flwSolutionModifyReqDto.getConvertNodeMaps());
        }
        this.publish();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateFlwSolutionStatus(Long id, Integer status) {
        FlwSolutionEo flwSolutionEo = new FlwSolutionEo();
        flwSolutionEo.setId(id);
        flwSolutionEo.setStatus(status);
        this.flwSolutionDas.updateSelective((BaseEo)flwSolutionEo);
        this.publish();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeFlwSolution(Long id) {
        this.flwSolutionDas.logicDeleteById(id);
        this.flwNodeLinkDas.logicDelete(id);
        this.publish();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createBatchFlwStatus(FlwStatusCreateReqDto flwStatusCreateReqDto) {
        String docType = flwStatusCreateReqDto.getDocType();
        List flwStatusDtos = flwStatusCreateReqDto.getFlwStatusDtos();
        ArrayList<FlwStatusEo> flwStatusEos = new ArrayList<FlwStatusEo>();
        for (FlwStatusDto dto : flwStatusDtos) {
            FlwStatusEo flwStatusEo = new FlwStatusEo();
            flwStatusEo.setStatusName(dto.getName());
            flwStatusEo.setStatus(Integer.valueOf(FlowStatusType.ANABLE.getCode()));
            flwStatusEo.setReadOnly(Common.DISABLE);
            flwStatusEo.setDocType(docType);
            flwStatusEo.setRemark(dto.getRemark());
            flwStatusEo.setPreSet(Common.NO);
            flwStatusEos.add(flwStatusEo);
        }
        this.flwStatusDas.insertBatch(flwStatusEos);
        this.publish();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyFlwStatus(FlwStatusModifyDto flwStatusModifyDto) {
        Assert.isTrue((null != flwStatusModifyDto.getId() ? 1 : 0) != 0, (String)"ID\u4e0d\u80fd\u4e3a\u7a7a");
        FlwStatusEo resultEo = (FlwStatusEo)this.flwStatusDas.selectByPrimaryKey(flwStatusModifyDto.getId());
        Assert.isTrue((null != resultEo ? 1 : 0) != 0, (String)"\u6570\u636e\u4e0d\u5b58\u5728");
        Assert.isTrue((StringUtils.isNotBlank((CharSequence)flwStatusModifyDto.getName()) && Common.DISABLE.equals(resultEo.getReadOnly()) ? 1 : 0) != 0, (String)"\u56fa\u5b9a\u7684\u72b6\u6001\u8282\u70b9\u540d\u79f0\u4e0d\u80fd\u4fee\u6539");
        FlwStatusEo flwStatusEo = new FlwStatusEo();
        DtoHelper.dto2Eo((BaseVo)flwStatusModifyDto, (BaseEo)flwStatusEo);
        flwStatusEo.setStatusName(flwStatusModifyDto.getName());
        this.flwStatusDas.updateSelective((BaseEo)flwStatusEo);
        this.publish();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeFlwStatus(Long id) {
        this.flwStatusDas.logicDeleteById(id);
        this.publish();
    }

    @Override
    public FlwSolutionDetailDto queryFlwSolutionById(Long id) {
        FlwSolutionEo flwSolutionEo = (FlwSolutionEo)this.flwSolutionDas.selectByPrimaryKey(id);
        FlwSolutionDetailDto flwSolutionDetailDto = new FlwSolutionDetailDto();
        DtoHelper.eo2Dto((BaseEo)flwSolutionEo, (BaseVo)flwSolutionDetailDto, (String[])new String[]{"type"});
        List flwNodeLinkEos = this.flwNodeLinkDas.select(id);
        ArrayList<FlwNodeLinkDto> flwNodeLinkDtos = new ArrayList<FlwNodeLinkDto>();
        if (CollectionUtils.isNotEmpty((Collection)flwNodeLinkEos)) {
            List flwNodeEos;
            Map<Object, Object> statusId2Detail = new HashMap();
            HashMap actionCode2Detail = new HashMap();
            HashSet<Long> flwStatusIdSet = new HashSet<Long>();
            HashSet<String> flwActionNodeCodeSet = new HashSet<String>();
            for (FlwNodeLinkEo eo : flwNodeLinkEos) {
                if (eo.getPrevType().equals(FlowNodeType.STATUS_NODE.getCode())) {
                    flwStatusIdSet.add(Long.valueOf(eo.getPrevCode()));
                } else if (eo.getPrevType().equals(FlowNodeType.ACTION_NODE.getCode())) {
                    flwActionNodeCodeSet.add(eo.getPrevCode());
                }
                if (eo.getNextType().equals(FlowNodeType.STATUS_NODE.getCode())) {
                    flwStatusIdSet.add(Long.valueOf(eo.getNextCode()));
                    continue;
                }
                if (!eo.getNextType().equals(FlowNodeType.ACTION_NODE.getCode())) continue;
                flwActionNodeCodeSet.add(eo.getNextCode());
            }
            List flwStatusEos = this.flwStatusDas.select(flwStatusIdSet);
            if (CollectionUtils.isNotEmpty((Collection)flwStatusEos)) {
                statusId2Detail = flwStatusEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (k1, k2) -> k1));
            }
            if (CollectionUtils.isNotEmpty((Collection)(flwNodeEos = this.flwNodeDas.select(flwActionNodeCodeSet)))) {
                flwSolutionDetailDto.setFlwNodeParams(flwNodeEos.stream().map(flwNodeEo -> {
                    FlwNodeParamDto flwNodeParamDto = new FlwNodeParamDto();
                    flwNodeParamDto.setNodeCode(flwNodeEo.getCode());
                    flwNodeParamDto.setInputCode(flwNodeEo.getInputCode());
                    flwNodeParamDto.setOutputCode(flwNodeEo.getOutputCode());
                    actionCode2Detail.put(flwNodeEo.getCode(), flwNodeEo);
                    return flwNodeParamDto;
                }).collect(Collectors.toList()));
            }
            for (FlwNodeLinkEo linkEo : flwNodeLinkEos) {
                FlwNodeEo actionNode;
                FlwStatusEo statusEo;
                FlwNodeLinkDto flwNodeLinkDto = new FlwNodeLinkDto();
                DtoHelper.eo2Dto((BaseEo)linkEo, (BaseVo)flwNodeLinkDto);
                if (linkEo.getPrevType().equals(FlowNodeType.STATUS_NODE.getCode()) && statusId2Detail.size() > 0 && null != statusId2Detail.get(Long.valueOf(linkEo.getPrevCode()))) {
                    statusEo = (FlwStatusEo)statusId2Detail.get(Long.valueOf(linkEo.getPrevCode()));
                    flwNodeLinkDto.setPrevName(statusEo.getStatusName());
                    flwNodeLinkDto.setPrevField(statusEo.getStatusField());
                    flwNodeLinkDto.setPrevCode(statusEo.getStatusCode());
                    flwNodeLinkDto.setPrevColor(statusEo.getColor());
                } else if (linkEo.getPrevType().equals(FlowNodeType.ACTION_NODE.getCode()) && actionCode2Detail.size() > 0 && null != actionCode2Detail.get(linkEo.getPrevCode())) {
                    actionNode = (FlwNodeEo)actionCode2Detail.get(linkEo.getPrevCode());
                    flwNodeLinkDto.setPrevName(actionNode.getName());
                    flwNodeLinkDto.setPrevColor(actionNode.getColor());
                    flwNodeLinkDto.setPrevResultCalls(this.getCalleeActionNode(actionNode.getCode(), linkEo.getPrevResult()));
                } else if (linkEo.getPrevType().equals(FlowNodeType.PRE_NODE.getCode())) {
                    flwNodeLinkDto.setPrevName(linkEo.getPrevCode());
                }
                if (linkEo.getNextType().equals(FlowNodeType.STATUS_NODE.getCode()) && statusId2Detail.size() > 0 && null != statusId2Detail.get(Long.valueOf(linkEo.getNextCode()))) {
                    statusEo = (FlwStatusEo)statusId2Detail.get(Long.valueOf(linkEo.getNextCode()));
                    flwNodeLinkDto.setNextName(statusEo.getStatusName());
                    flwNodeLinkDto.setNextField(statusEo.getStatusField());
                    flwNodeLinkDto.setNextCode(statusEo.getStatusCode());
                    flwNodeLinkDto.setNextColor(statusEo.getColor());
                } else if (linkEo.getNextType().equals(FlowNodeType.ACTION_NODE.getCode()) && actionCode2Detail.size() > 0 && null != actionCode2Detail.get(linkEo.getNextCode())) {
                    actionNode = (FlwNodeEo)actionCode2Detail.get(linkEo.getNextCode());
                    flwNodeLinkDto.setNextName(actionNode.getName());
                    flwNodeLinkDto.setNextColor(actionNode.getColor());
                } else if (linkEo.getNextType().equals(FlowNodeType.PRE_NODE.getCode())) {
                    flwNodeLinkDto.setNextName(linkEo.getNextCode());
                }
                flwNodeLinkDtos.add(flwNodeLinkDto);
            }
        }
        flwSolutionDetailDto.setFlwNodeLinkDtos(flwNodeLinkDtos);
        flwSolutionDetailDto.setConvertNodeMaps(this.flwNodeConvertMapService.findNodeConvertMap(flwSolutionDetailDto.getId()));
        return flwSolutionDetailDto;
    }

    @Override
    public FlwNodeLinkCoreInfoDto queryFlwSolutionCoreInfo4ExecById(Long defId) {
        FlwNodeLinkCoreInfoDto flwNodeLinkCoreInfoDto = new FlwNodeLinkCoreInfoDto();
        flwNodeLinkCoreInfoDto.setDefId(defId);
        List flwNodeLinkEos = this.flwNodeLinkDas.select(defId);
        if (CollectionUtils.isEmpty((Collection)flwNodeLinkEos)) {
            return flwNodeLinkCoreInfoDto;
        }
        LinkedList<SqlFilter> sqlFilters = new LinkedList<SqlFilter>();
        SqlFilter sqlFilter = new SqlFilter();
        sqlFilter.setProperty("id");
        sqlFilter.setOperator(SqlFilter.Operator.in);
        sqlFilters.add(sqlFilter);
        LinkedList<Long> statusIds = new LinkedList<Long>();
        for (FlwNodeLinkEo flwNodeLinkEo2 : flwNodeLinkEos) {
            if (FlowNodeType.STATUS_NODE.getCode() != flwNodeLinkEo2.getPrevType().intValue()) continue;
            Long statusId = Long.parseLong(flwNodeLinkEo2.getPrevCode());
            statusIds.add(statusId);
        }
        FlwStatusEo flwStatusSelectParam = new FlwStatusEo();
        flwStatusSelectParam.setSqlFilters(sqlFilters);
        List flwStatusEos = this.flwStatusDas.select((BaseEo)flwStatusSelectParam);
        HashMap statusId2NameMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)flwStatusEos)) {
            flwStatusEos.forEach(flwStatusEo -> statusId2NameMap.put(String.valueOf(flwStatusEo.getId()), flwStatusEo.getStatusName()));
        }
        ArrayList nodeLinks = new ArrayList();
        flwNodeLinkEos.forEach(flwNodeLinkEo -> {
            if (FlowPreNodeCode.START.getCode().equals(flwNodeLinkEo.getPrevCode())) {
                String startNodeCode = flwNodeLinkEo.getNextCode();
                if (startNodeCode != null) {
                    nodeLinks.add(new FlwNodeLinkEo(defId).start(startNodeCode));
                } else {
                    LOGGER.warn("\u6d41\u7a0b[{}]\u4e0d\u5b58\u5728\u5f00\u59cb\u8282\u70b9", (Object)defId);
                }
            } else if (FlowNodeType.STATUS_NODE.getCode() == flwNodeLinkEo.getPrevType().intValue() && FlowNodeType.ACTION_NODE.getCode() == flwNodeLinkEo.getNextType().intValue()) {
                nodeLinks.add(new FlwNodeLinkEo(defId).status2proc((String)statusId2NameMap.get(flwNodeLinkEo.getPrevCode()), flwNodeLinkEo.getNextCode()));
            } else if (FlowNodeType.ACTION_NODE.getCode() == flwNodeLinkEo.getPrevType().intValue() && FlowNodeType.STATUS_NODE.getCode() == flwNodeLinkEo.getNextType().intValue()) {
                nodeLinks.add(new FlwNodeLinkEo(defId).proc2status(flwNodeLinkEo.getPrevCode(), flwNodeLinkEo.getPrevResult(), (String)statusId2NameMap.get(flwNodeLinkEo.getNextCode())));
            } else if (FlowNodeType.PRE_NODE.getCode() == flwNodeLinkEo.getPrevType().intValue() || FlowNodeType.PRE_NODE.getCode() == flwNodeLinkEo.getNextType().intValue()) {
                nodeLinks.add(new FlwNodeLinkEo(defId).proc2status(flwNodeLinkEo.getPrevCode(), flwNodeLinkEo.getPrevResult(), flwNodeLinkEo.getNextCode()));
            }
        });
        flwNodeLinkCoreInfoDto.setNodeLinks(nodeLinks);
        return flwNodeLinkCoreInfoDto;
    }

    @Override
    public FlwActiveDefResp queryActiveFlwSolution(String group) {
        FlwSolutionEo flwSolutionEo = new FlwSolutionEo();
        flwSolutionEo.setStatus(Constants.ENABLE);
        List solutions = this.flwSolutionDas.select((BaseEo)flwSolutionEo, Integer.valueOf(0), Integer.valueOf(1024));
        HashSet<Long> flwDefIdSet = new HashSet<Long>();
        ArrayList<FlwNodeLinkItem> results = new ArrayList<FlwNodeLinkItem>(128);
        if (solutions == null) {
            return new FlwActiveDefResp();
        }
        ArrayList<FlwSolutionMapDto> solutionMaplist = new ArrayList<FlwSolutionMapDto>(solutions.size());
        HashMap code2VersionMap = Maps.newHashMap();
        for (FlwSolutionEo solution : solutions) {
            List flwNodeLinkEos = this.flwNodeLinkDas.select(solution.getId());
            if (flwNodeLinkEos == null) continue;
            for (FlwNodeLinkEo eo : flwNodeLinkEos) {
                FlwNodeLinkItem item = new FlwNodeLinkItem();
                item.copy((INodeLinkEo)eo);
                item.setDocType(eo.getDocType());
                results.add(item);
            }
            flwDefIdSet.add(solution.getId());
            FlwSolutionMapDto flwSolutionMapDto = (FlwSolutionMapDto)code2VersionMap.get(solution.getCode());
            if (flwSolutionMapDto == null) {
                flwSolutionMapDto = new FlwSolutionMapDto();
                flwSolutionMapDto.setCode(solution.getCode());
                flwSolutionMapDto.setVersions((List)Lists.newArrayList());
                code2VersionMap.put(solution.getCode(), flwSolutionMapDto);
            }
            flwSolutionMapDto.getVersions().add(new FlwSolutionMapDto.FlwSolutionVersionDto(solution.getId(), solution.getVersion()));
            solutionMaplist.add(flwSolutionMapDto);
        }
        FlwActiveDefResp resp = new FlwActiveDefResp();
        resp.setNodeLinks(results);
        resp.setSolutionMaplist(solutionMaplist);
        Map<Long, List<NodeConvertMap>> nodeConvertMapMap = this.flwNodeConvertMapService.batchFindNodeConvertMap(flwDefIdSet);
        if (MapUtils.isNotEmpty(nodeConvertMapMap)) {
            resp.setSolutionConvertNodeMaps(new ArrayList(nodeConvertMapMap.size()));
            nodeConvertMapMap.forEach((flwDefId, nodeConvertMaps) -> {
                FlwSolutionConvertNodeMapDto flwSolutionConvertNodeMapDto = new FlwSolutionConvertNodeMapDto();
                flwSolutionConvertNodeMapDto.setFlowDefId(flwDefId);
                flwSolutionConvertNodeMapDto.setNodeConvertMaps((Collection)nodeConvertMaps);
                resp.getSolutionConvertNodeMaps().add(flwSolutionConvertNodeMapDto);
            });
        }
        return resp;
    }

    @Override
    public PageInfo<FlwSolutionRespDto> queryFlwSolutionByPage(FlwSolutionQueryReqDto flwSolutionQueryReqDto, Integer pageNum, Integer pageSize) {
        FlwSolutionEo flwSolutionEo = new FlwSolutionEo();
        DtoHelper.dto2Eo((BaseVo)flwSolutionQueryReqDto, (BaseEo)flwSolutionEo);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (StringUtils.isNotBlank((CharSequence)flwSolutionQueryReqDto.getName())) {
            sqlFilters.add(SqlFilter.like((String)"name", (Object)("%" + flwSolutionQueryReqDto.getName() + "%")));
            flwSolutionEo.setName(null);
        }
        if (StringUtils.isNotBlank((CharSequence)flwSolutionQueryReqDto.getCode())) {
            sqlFilters.add(SqlFilter.like((String)"code", (Object)("%" + flwSolutionQueryReqDto.getCode() + "%")));
            flwSolutionEo.setName(null);
        }
        flwSolutionEo.setSqlFilters(sqlFilters);
        flwSolutionEo.setOrderByDesc("update_time");
        flwSolutionEo.setCurShow(Constants.ENABLE);
        PageInfo eoPageInfo = this.flwSolutionDas.selectPage((BaseEo)flwSolutionEo, pageNum, pageSize);
        ArrayList flwSolutionRespDtos = new ArrayList();
        if (eoPageInfo != null && CollectionUtils.isNotEmpty((Collection)eoPageInfo.getList())) {
            DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), flwSolutionRespDtos, FlwSolutionRespDto.class);
        }
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        dtoPageInfo.setList(flwSolutionRespDtos);
        return dtoPageInfo;
    }

    @Override
    public PageInfo<FlwStatusRespDto> queryFlwStatus(String ... docTypes) {
        LinkedHashSet flwStatusRespDtos = new LinkedHashSet();
        List flwDocEos = this.flwDocDas.select(Arrays.asList(docTypes));
        for (FlwDocEo flwDocEo : flwDocEos) {
            Map presetStatuses = flwDocEo.readStatusFieldMap();
            if (presetStatuses == null) continue;
            presetStatuses.forEach((statusField, statusValueInfo) -> statusValueInfo.getValues().forEach(statusValue -> {
                FlwStatusRespDto dto = new FlwStatusRespDto();
                dto.setCode(statusValue);
                dto.setName(statusValue);
                dto.setDocType(flwDocEo.getCode());
                dto.setStatusField(statusField);
                flwStatusRespDtos.add(dto);
            }));
        }
        FlwStatusEo statusEoSelectParam = new FlwStatusEo();
        statusEoSelectParam.setSqlFilters(SqlFilterBuilder.newInstance().buildInSqlFilter("doc_type", Arrays.asList(docTypes)).get());
        List flwStatusEos = this.flwStatusDas.select((BaseEo)statusEoSelectParam);
        if (CollectionUtils.isNotEmpty((Collection)flwStatusEos)) {
            flwStatusEos.forEach(eo -> {
                FlwStatusRespDto dto = new FlwStatusRespDto();
                DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)dto);
                dto.setName(eo.getStatusName());
                dto.setCode(eo.getStatusCode());
                flwStatusRespDtos.add(dto);
            });
        }
        return new PageInfo(new ArrayList(flwStatusRespDtos));
    }

    @Override
    public PageInfo<FlwActionNodeRespDto> queryFlwActionNode(String ... docTypes) {
        FlwNodeEo selectParam = new FlwNodeEo();
        selectParam.setSqlFilters(SqlFilterBuilder.newInstance().buildInSqlFilter("doc_type", Arrays.asList(docTypes)).get());
        List flwNodeEos = this.flwNodeDas.select((BaseEo)selectParam);
        Map<Object, Object> node2Results = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)flwNodeEos)) {
            Set flwNodeCodes = flwNodeEos.stream().map(StdFlwNodeEo::getCode).collect(Collectors.toSet());
            List flwNodeResultEos = this.flwNodeResultDas.select(flwNodeCodes);
            node2Results = flwNodeResultEos.stream().collect(Collectors.groupingBy(StdFlwNodeResultEo::getFlwNodeCode));
        }
        ArrayList<FlwActionNodeRespDto> flwActionNodeRespDtos = new ArrayList<FlwActionNodeRespDto>();
        for (FlwNodeEo flwNodeEo : flwNodeEos) {
            FlwActionNodeRespDto flwActionNodeRespDto = new FlwActionNodeRespDto();
            DtoHelper.eo2Dto((BaseEo)flwNodeEo, (BaseVo)flwActionNodeRespDto);
            ArrayList actionNodeResults = new ArrayList();
            if (node2Results.size() > 0 && CollectionUtils.isNotEmpty((Collection)((Collection)node2Results.get(flwNodeEo.getCode())))) {
                ((List)node2Results.get(flwNodeEo.getCode())).forEach(eo -> {
                    ActionNodeResultDto actionNodeResultDto = new ActionNodeResultDto();
                    actionNodeResultDto.setCode(eo.getCode());
                    actionNodeResultDto.setName(eo.getName());
                    actionNodeResultDto.setPrevResultCalls(this.getCalleeActionNode(flwNodeEo.getCode(), eo.getCode()));
                    actionNodeResults.add(actionNodeResultDto);
                });
                flwActionNodeRespDto.setActionNodeResults(actionNodeResults);
            }
            flwActionNodeRespDtos.add(flwActionNodeRespDto);
        }
        return new PageInfo(flwActionNodeRespDtos);
    }

    private Set<String> getCalleeActionNode(String callerNodeCode, String result) {
        FlwNodeResultCallEo queryEo = new FlwNodeResultCallEo();
        queryEo.setCallerFlwNodeCode(callerNodeCode);
        queryEo.setFlwNodeResultCode(result);
        List resultCallEos = this.flwNodeResultCallDas.select((BaseEo)queryEo, Integer.valueOf(1), Integer.valueOf(100));
        if (CollectionUtils.isEmpty((Collection)resultCallEos)) {
            return new HashSet<String>();
        }
        return resultCallEos.stream().map(StdFlwNodeResultCallEo::getCalleeFlwNodeCode).collect(Collectors.toSet());
    }

    @Override
    public PageInfo<FlwDocRespDto> queryFlwDoc(FlwDocQueryReqDto flwDocQueryReqDto) {
        FlwDocEo flwDocEo = new FlwDocEo();
        DtoHelper.dto2Eo((BaseVo)flwDocQueryReqDto, (BaseEo)flwDocEo);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (StringUtils.isNotBlank((CharSequence)flwDocQueryReqDto.getName())) {
            sqlFilters.add(SqlFilter.like((String)"name", (Object)("%" + flwDocQueryReqDto.getName() + "%")));
            flwDocEo.setName(null);
        }
        flwDocEo.setSqlFilters(sqlFilters);
        flwDocEo.setOrderBy("code");
        List flwDocEos = this.flwDocDas.select((BaseEo)flwDocEo, Integer.valueOf(1), Integer.valueOf(5000));
        ArrayList flwDocRespDtos = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)flwDocEos)) {
            DtoHelper.eoList2DtoList((Collection)flwDocEos, flwDocRespDtos, FlwDocRespDto.class);
        }
        return new PageInfo(flwDocRespDtos);
    }

    @Override
    public void addAndUpdateDocType(List<BundleFlowDto.FlowDoc> flowDocs) {
        List results;
        if (CollectionUtils.isEmpty(flowDocs)) {
            return;
        }
        Set domainSet = flowDocs.stream().map(BundleFlowDto.FlowDoc::getDomain).collect(Collectors.toSet());
        Map<Object, Object> code2FlwDoc = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(domainSet) && CollectionUtils.isNotEmpty((Collection)(results = this.flwDocDas.selectByDomain(new ArrayList(domainSet))))) {
            code2FlwDoc = results.stream().collect(Collectors.toMap(StdFlwDocEo::getCode, Function.identity(), (k1, k2) -> k1));
        }
        ArrayList<FlwDocEo> insertEos = new ArrayList<FlwDocEo>();
        Map<Object, Object> code2StatusEoMap = Maps.newHashMap();
        List<FlwColorPoolEo> flwColorPoolEos = this.fetchColorPoolOrdered();
        final ArrayList docTypes = Lists.newArrayList();
        for (BundleFlowDto.FlowDoc bundleFlwDocDto : flowDocs) {
            String docType = bundleFlwDocDto.getCode();
            docTypes.add(docType);
            HashMap statusFieldMap = Maps.newHashMap();
            code2StatusEoMap = this.collectStatusNodeAndSetColor(code2StatusEoMap, bundleFlwDocDto, docType, statusFieldMap, flwColorPoolEos);
            if (null != code2FlwDoc.get(docType)) {
                FlwDocEo updateEo = new FlwDocEo();
                updateEo.setDomain(bundleFlwDocDto.getDomain());
                updateEo.setName(bundleFlwDocDto.getName());
                updateEo.setId(((FlwDocEo)code2FlwDoc.get(docType)).getId());
                updateEo.setStatusField(JSON.toJSONString((Object)statusFieldMap));
                this.flwDocDas.updateSelective((BaseEo)updateEo);
                code2FlwDoc.remove(docType);
                continue;
            }
            FlwDocEo insertEo = new FlwDocEo();
            insertEo.setCode(bundleFlwDocDto.getCode());
            insertEo.setName(bundleFlwDocDto.getName());
            insertEo.setDomain(bundleFlwDocDto.getDomain());
            insertEo.setStatusField(JSON.toJSONString((Object)statusFieldMap));
            insertEo.setExtension("");
            insertEos.add(insertEo);
        }
        if (CollectionUtils.isNotEmpty(code2FlwDoc.values())) {
            FlwDocEo docDeleteEo = new FlwDocEo();
            docDeleteEo.setSqlFilters(SqlFilterBuilder.newInstance().buildInSqlFilter("id", code2FlwDoc.values().stream().map(BaseEo::getId).collect(Collectors.toList())).get());
            this.flwDocDas.logicDelete((BaseEo)docDeleteEo);
        }
        new IDataUpdater<String, FlwStatusEo>(){

            public String getKey(FlwStatusEo source) {
                return FlowServiceImpl.this.getFlwStatusNodeKey(source);
            }

            public int deleteMode() {
                return IDataUpdater.DeleteMode.LOGIC_DELETE.getMode();
            }

            public Map<Long, Boolean> getUsedMap() {
                return FlowServiceImpl.this.flwNodeLinkDas.getUsedStatusNodeMap(FlowNodeType.STATUS_NODE.getCode(), Constants.ENABLE.intValue());
            }

            public FlwStatusEo getDeleteParamEo() {
                FlwStatusEo deleteParam = new FlwStatusEo();
                deleteParam.setPreSet(Common.YES);
                return deleteParam;
            }

            public FlwStatusEo getSelectParamEo() {
                FlwStatusEo selectParam = new FlwStatusEo();
                selectParam.setSqlFilters(SqlFilterBuilder.newInstance().buildInSqlFilter("doc_type", docTypes).get());
                return selectParam;
            }
        }.process((Map)code2StatusEoMap, (AbstractBaseDas)this.flwStatusDas);
        this.flwDocDas.insertBatch(insertEos);
    }

    @Override
    public List<FlwColorPoolEo> fetchColorPoolOrdered() {
        List flwColorPoolEos = this.flwColorPoolDas.selectAll();
        if (flwColorPoolEos == null) {
            flwColorPoolEos = Lists.newArrayList();
        }
        flwColorPoolEos.sort(Comparator.comparing(StdFlwColorPoolEo::getRgb));
        return flwColorPoolEos;
    }

    public static String getColor(String docType, String statusField, List<FlwColorPoolEo> finalFlwColorPoolEos) {
        if (CollectionUtils.isEmpty(finalFlwColorPoolEos)) {
            return "";
        }
        long hash = docType.hashCode() + statusField.hashCode();
        int index = (int)hash % finalFlwColorPoolEos.size();
        if (index < 0) {
            index *= -1;
        }
        return finalFlwColorPoolEos.get(index).getRgb();
    }

    Map<String, FlwStatusEo> collectStatusNodeAndSetColor(Map<String, FlwStatusEo> code2EoMap, BundleFlowDto.FlowDoc bundleFlwDocDto, String docType, Map<String, String> statusFieldMap, List<FlwColorPoolEo> finalFlwColorPoolEos) {
        bundleFlwDocDto.getStatusPropDesc().forEach((key, value) -> {
            String color = FlowServiceImpl.getColor(docType, key, finalFlwColorPoolEos);
            if (CollectionUtils.isNotEmpty((Collection)value.getPairs())) {
                value.getPairs().forEach(nameCodePair -> {
                    FlwStatusEo flwStatusEo = new FlwStatusEo();
                    flwStatusEo.setDocType(bundleFlwDocDto.getCode());
                    flwStatusEo.setStatusField(key);
                    flwStatusEo.setStatusCode(nameCodePair.getCode());
                    flwStatusEo.setStatusName(nameCodePair.getName());
                    flwStatusEo.setColor(color);
                    flwStatusEo.setReadOnly(Common.YES);
                    flwStatusEo.setPreSet(Common.YES);
                    flwStatusEo.setExtension("");
                    code2EoMap.put(this.getFlwStatusNodeKey(flwStatusEo), flwStatusEo);
                });
            }
            statusFieldMap.put((String)key, value.getStatusDesc());
        });
        return code2EoMap;
    }

    @Override
    public void addAndUpdateFlwNode(List<BundleFlowDto.FlowNode> flowNodes) {
        ArrayList insertNodeEos = new ArrayList();
        HashMap code2NodeEoMap = Maps.newHashMap();
        final ArrayList flwNodeCodes = Lists.newArrayList();
        HashMap code2ResultCallEoMap = Maps.newHashMap();
        final ArrayList flwNodeResultCodes = Lists.newArrayList();
        HashMap code2ResultEoMap = Maps.newHashMap();
        if (CollectionUtils.isEmpty(flowNodes)) {
            return;
        }
        for (BundleFlowDto.FlowNode bundleFlwNodeDto : flowNodes) {
            flwNodeCodes.add(bundleFlwNodeDto.getCode());
            String nodeCode = bundleFlwNodeDto.getCode();
            FlwNodeEo flwNodeEo = new FlwNodeEo();
            BeanUtils.copyProperties((Object)bundleFlwNodeDto, (Object)flwNodeEo);
            flwNodeEo.setExtension("");
            code2NodeEoMap.put(nodeCode, flwNodeEo);
            List nodeResultDtos = bundleFlwNodeDto.getResults();
            for (BundleFlowDto.FlowNode.Result nodeResultDto : nodeResultDtos) {
                flwNodeResultCodes.add(nodeResultDto.getCode());
                if (nodeResultDto.getCall() != null) {
                    for (String call : nodeResultDto.getCall()) {
                        if (StringUtils.isEmpty((CharSequence)call)) continue;
                        FlwNodeResultCallEo insertFlwNodeResultCallEo = new FlwNodeResultCallEo();
                        insertFlwNodeResultCallEo.setCalleeFlwNodeCode(call);
                        insertFlwNodeResultCallEo.setFlwNodeResultCode(nodeResultDto.getCode());
                        insertFlwNodeResultCallEo.setCallerFlwNodeCode(nodeCode);
                        insertFlwNodeResultCallEo.setExtension("");
                        code2ResultCallEoMap.put(this.getFlwNodeResultCallKey(insertFlwNodeResultCallEo), insertFlwNodeResultCallEo);
                    }
                }
                FlwNodeResultEo nodeResultInsertEo = new FlwNodeResultEo();
                BeanUtils.copyProperties((Object)nodeResultDto, (Object)nodeResultInsertEo);
                if (StringUtils.isBlank((CharSequence)nodeResultDto.getName())) {
                    nodeResultInsertEo.setName(nodeResultDto.getCode());
                }
                nodeResultInsertEo.setExtension("");
                nodeResultInsertEo.setFlwNodeCode(nodeCode);
                code2ResultEoMap.put(this.getFlwNodeResultKey(nodeResultInsertEo), nodeResultInsertEo);
            }
        }
        new IDataUpdater<String, FlwNodeEo>(){

            public String getKey(FlwNodeEo source) {
                return source.getCode();
            }

            public FlwNodeEo getSelectParamEo() {
                return new FlwNodeEo();
            }

            public Map<Long, Boolean> getUsedMap() {
                return FlowServiceImpl.this.flwNodeLinkDas.getUsedProcessNodeMap(FlowNodeType.ACTION_NODE.getCode(), Constants.ENABLE.intValue());
            }

            public int deleteMode() {
                return IDataUpdater.DeleteMode.LOGIC_DELETE.getMode();
            }

            public FlwNodeEo getDeleteParamEo() {
                FlwNodeEo deleteParam = new FlwNodeEo();
                return deleteParam;
            }
        }.process((Map)code2NodeEoMap, (AbstractBaseDas)this.flwNodeDas);
        new IDataUpdater<String, FlwNodeResultCallEo>(){

            public String getKey(FlwNodeResultCallEo source) {
                return FlowServiceImpl.this.getFlwNodeResultCallKey(source);
            }

            public FlwNodeResultCallEo getDeleteParamEo() {
                return new FlwNodeResultCallEo();
            }

            public int deleteMode() {
                return IDataUpdater.DeleteMode.NOT_DELETE.getMode();
            }

            public FlwNodeResultCallEo getSelectParamEo() {
                FlwNodeResultCallEo selectParam = new FlwNodeResultCallEo();
                selectParam.setSqlFilters(SqlFilterBuilder.newInstance().buildInSqlFilter("flw_node_result_code", flwNodeResultCodes).get());
                return selectParam;
            }
        }.process((Map)code2ResultCallEoMap, (AbstractBaseDas)this.flwNodeResultCallDas);
        new IDataUpdater<String, FlwNodeResultEo>(){

            public String getKey(FlwNodeResultEo source) {
                return FlowServiceImpl.this.getFlwNodeResultKey(source);
            }

            public FlwNodeResultEo getDeleteParamEo() {
                return new FlwNodeResultEo();
            }

            public int deleteMode() {
                return IDataUpdater.DeleteMode.NOT_DELETE.getMode();
            }

            public FlwNodeResultEo getSelectParamEo() {
                FlwNodeResultEo selectParam = new FlwNodeResultEo();
                selectParam.setSqlFilters(SqlFilterBuilder.newInstance().buildInSqlFilter("flw_node_code", flwNodeCodes).get());
                return selectParam;
            }
        }.process((Map)code2ResultEoMap, (AbstractBaseDas)this.flwNodeResultDas);
        if (CollectionUtils.isNotEmpty(insertNodeEos)) {
            this.flwNodeDas.insertBatch(insertNodeEos);
        }
    }

    private String getFlwNodeResultKey(FlwNodeResultEo source) {
        return RedisKeyConstants.combineKey((String)source.getFlwNodeCode(), (Object[])new Object[]{source.getCode()});
    }

    private String getFlwNodeResultCallKey(FlwNodeResultCallEo source) {
        return RedisKeyConstants.combineKey((String)source.getCallerFlwNodeCode(), (Object[])new Object[]{source.getFlwNodeResultCode(), source.getCalleeFlwNodeCode()});
    }

    private String getFlwStatusNodeKey(FlwStatusEo source) {
        return RedisKeyConstants.combineKey((String)source.getDocType(), (Object[])new Object[]{source.getStatusField(), source.getStatusCode()});
    }

    @Override
    public void addAndUpdateFlwConvertNode(List<BundleFlowDto.ConvertNode> convertNodes) {
        if (CollectionUtils.isEmpty(convertNodes)) {
            return;
        }
        final Map<String, FlwConvertNodeEo> code2FlwConertNodeEoMap = convertNodes.stream().collect(Collectors.toMap(BundleFlowDto.ConvertNode::getCode, convertNode -> {
            FlwConvertNodeEo flwConvertNodeEo = new FlwConvertNodeEo();
            BeanUtils.copyProperties((Object)convertNode, (Object)flwConvertNodeEo);
            flwConvertNodeEo.setExtension("");
            return flwConvertNodeEo;
        }, (oldOne, newOne) -> oldOne));
        new IDataUpdater<String, FlwConvertNodeEo>(){

            public String getKey(FlwConvertNodeEo source) {
                return source.getCode();
            }

            public FlwConvertNodeEo getDeleteParamEo() {
                return new FlwConvertNodeEo();
            }

            public int deleteMode() {
                return IDataUpdater.DeleteMode.PHYSICAL_DELETE.getMode();
            }

            public FlwConvertNodeEo getSelectParamEo() {
                FlwConvertNodeEo selectParam = new FlwConvertNodeEo();
                selectParam.setSqlFilters(SqlFilterBuilder.newInstance().buildInSqlFilter("code", code2FlwConertNodeEoMap.keySet()).get());
                return selectParam;
            }
        }.process(code2FlwConertNodeEoMap, (AbstractBaseDas)this.flwConvertNodeDas);
    }

    @Override
    public FlwActionStatusRespDto queryActionStatusNode(String docType) {
        FlwDocEo flwDocEo = this.flwDocDas.select(docType);
        List<FlwColorPoolEo> colorPoolEos = this.fetchColorPoolOrdered();
        PageInfo<FlwActionNodeRespDto> actionNodePage = this.queryFlwActionNode(docType);
        PageInfo<FlwStatusRespDto> statusNodePage = this.queryFlwStatus(docType);
        return this.packageDto(actionNodePage.getList(), statusNodePage.getList(), flwDocEo, colorPoolEos);
    }

    private FlwActionStatusRespDto packageDto(List<FlwActionNodeRespDto> actionNodeRespDtos, List<FlwStatusRespDto> statusNodeList, FlwDocEo flwDocEo, List<FlwColorPoolEo> colorPoolEos) {
        Map<String, String> statusField2NameMap = null;
        if (null != flwDocEo) {
            String statusField = flwDocEo.getStatusField();
            statusField2NameMap = (Map)JSONObject.parse((String)statusField);
        }
        if (statusField2NameMap == null) {
            statusField2NameMap = Maps.newHashMap();
        }
        FlwActionStatusRespDto flwActionStatusRespDto = new FlwActionStatusRespDto();
        flwActionStatusRespDto.setActionNodeList(actionNodeRespDtos);
        if (CollectionUtils.isNotEmpty(statusNodeList)) {
            Map<String, List<FlwStatusRespDto>> field2Status = statusNodeList.stream().collect(Collectors.groupingBy(FlwStatusRespDto::getStatusField));
            statusField2NameMap.forEach((key, value) -> {
                if (!field2Status.containsKey(key)) {
                    field2Status.put((String)key, Lists.newArrayList());
                }
            });
            ArrayList<FlwStatusFieldRespDto> fieldStatus = new ArrayList<FlwStatusFieldRespDto>();
            for (Map.Entry<String, List<FlwStatusRespDto>> entry : field2Status.entrySet()) {
                FlwStatusFieldRespDto respDto = new FlwStatusFieldRespDto();
                respDto.setStatusField(entry.getKey());
                String statusFieldName = (String)statusField2NameMap.get(entry.getKey());
                if (StringUtils.isBlank((CharSequence)statusFieldName)) {
                    statusFieldName = entry.getKey();
                }
                respDto.setStatusFieldName(statusFieldName);
                respDto.setStatusFieldColor(FlowServiceImpl.getColor(flwDocEo.getCode(), entry.getKey(), colorPoolEos));
                ArrayList statusDetails = new ArrayList();
                CubeBeanUtils.copyCollection(statusDetails, (Collection)entry.getValue(), FlwStatusDetailDto.class);
                respDto.setStatusDetails(statusDetails);
                fieldStatus.add(respDto);
            }
            flwActionStatusRespDto.setFieldStatus(fieldStatus);
        } else {
            ArrayList fieldStatus = Lists.newArrayList();
            statusField2NameMap.forEach((key, value) -> {
                FlwStatusFieldRespDto flwStatusFieldRespDto = new FlwStatusFieldRespDto();
                flwStatusFieldRespDto.setStatusField(key);
                flwStatusFieldRespDto.setStatusFieldName(value);
                fieldStatus.add(flwStatusFieldRespDto);
            });
            flwActionStatusRespDto.setFieldStatus((List)fieldStatus);
        }
        return flwActionStatusRespDto;
    }

    @Override
    public Map<String, FlwActionStatusRespDto> batchQueryActionStatusNode(List<String> docTypes) {
        String[] docTypeArray = new String[docTypes.size()];
        int i = 0;
        for (String docType : docTypes) {
            docTypeArray[i++] = docType;
        }
        List<FlwColorPoolEo> colorPoolEos = this.fetchColorPoolOrdered();
        FlwDocEo selectParam = new FlwDocEo();
        selectParam.setSqlFilters(SqlFilterBuilder.newInstance().buildInSqlFilter("code", docTypes).get());
        List flwDocEoList = this.flwDocDas.select((BaseEo)selectParam);
        if (CollectionUtils.isEmpty((Collection)flwDocEoList)) {
            return Maps.newHashMap();
        }
        PageInfo<FlwActionNodeRespDto> actionNodePage = this.queryFlwActionNode(docTypeArray);
        Map<Object, Object> docType2ActionNodeDto = Maps.newHashMap();
        if (null != actionNodePage && CollectionUtils.isNotEmpty((Collection)actionNodePage.getList())) {
            docType2ActionNodeDto = actionNodePage.getList().stream().collect(Collectors.groupingBy(FlwActionNodeRespDto::getDocType));
        }
        PageInfo<FlwStatusRespDto> statusNodePage = this.queryFlwStatus(docTypeArray);
        Map<Object, Object> docType2StatusNodeDto = Maps.newHashMap();
        if (null != actionNodePage && CollectionUtils.isNotEmpty((Collection)actionNodePage.getList())) {
            docType2StatusNodeDto = statusNodePage.getList().stream().collect(Collectors.groupingBy(FlwStatusRespDto::getDocType));
        }
        HashMap map = Maps.newHashMap();
        for (FlwDocEo flwDocEo : flwDocEoList) {
            map.put(flwDocEo.getCode(), this.packageDto((List)docType2ActionNodeDto.get(flwDocEo.getCode()), (List)docType2StatusNodeDto.get(flwDocEo.getCode()), flwDocEo, colorPoolEos));
        }
        return map;
    }

    private FlwNodeLinkDto correctFlwNodeLink(FlwNodeLinkDto flwNodeLinkDto) {
        if (FlowPreNodeCode.START.getCode().equals(flwNodeLinkDto.getPrevCode()) || FlowPreNodeCode.START.getCode().toLowerCase().equals(flwNodeLinkDto.getPrevCode())) {
            flwNodeLinkDto.setPrevCode(FlowPreNodeCode.START.getCode());
            if (flwNodeLinkDto.getPrevType() == null) {
                flwNodeLinkDto.setPrevType(Integer.valueOf(FlowNodeType.PRE_NODE.getCode()));
            }
        }
        if (FlowPreNodeCode.START.getCode().equals(flwNodeLinkDto.getNextCode()) || FlowPreNodeCode.START.getCode().toLowerCase().equals(flwNodeLinkDto.getNextCode())) {
            flwNodeLinkDto.setNextCode(FlowPreNodeCode.START.getCode());
            if (flwNodeLinkDto.getNextType() == null) {
                flwNodeLinkDto.setNextType(Integer.valueOf(FlowNodeType.PRE_NODE.getCode()));
            }
        }
        if (FlowPreNodeCode.END.getCode().equals(flwNodeLinkDto.getPrevCode()) || FlowPreNodeCode.END.getCode().toLowerCase().equals(flwNodeLinkDto.getPrevCode())) {
            flwNodeLinkDto.setPrevCode(FlowPreNodeCode.END.getCode());
            if (flwNodeLinkDto.getPrevType() == null) {
                flwNodeLinkDto.setPrevType(Integer.valueOf(FlowNodeType.PRE_NODE.getCode()));
            }
        }
        if (FlowPreNodeCode.END.getCode().equals(flwNodeLinkDto.getNextCode()) || FlowPreNodeCode.END.getCode().toLowerCase().equals(flwNodeLinkDto.getNextCode())) {
            flwNodeLinkDto.setNextCode(FlowPreNodeCode.END.getCode());
            if (flwNodeLinkDto.getNextType() == null) {
                flwNodeLinkDto.setNextType(Integer.valueOf(FlowNodeType.PRE_NODE.getCode()));
            }
        }
        return flwNodeLinkDto;
    }

    private void processNodeLink(Long flwSolutionId, List<FlwNodeLinkDto> flwNodeLinkDtos, Collection<FlwNodeConvertMapReqDto> flwNodeConvertMapReqDtos) {
        ArrayList<FlwStatusEo> flwStatusInsertEos = new ArrayList<FlwStatusEo>();
        ArrayList flwNodeLinkEos = new ArrayList();
        boolean existStart = false;
        boolean existAction = false;
        HashMap<String, String> statusName2StatusId = new HashMap<String, String>();
        HashMap actionResult2Status = new HashMap();
        HashSet<String> linkSet = new HashSet<String>();
        HashSet<String> fieldStatusDetailSet = new HashSet<String>();
        HashMap statusAfterProcessMap = Maps.newHashMap();
        for (FlwNodeLinkDto flwNodeLinkDto2 : flwNodeLinkDtos) {
            flwNodeLinkDto2 = this.correctFlwNodeLink(flwNodeLinkDto2);
            String docType = flwNodeLinkDto2.getDocType();
            String preNodeCode = flwNodeLinkDto2.getPrevCode();
            Integer preNodeType = flwNodeLinkDto2.getPrevType();
            String nextNodeCode = flwNodeLinkDto2.getNextCode();
            Integer nextNodeType = flwNodeLinkDto2.getNextType();
            if (preNodeType.equals(FlowNodeType.PRE_NODE.getCode())) {
                if (preNodeCode.equals(FlowPreNodeCode.START.getCode())) {
                    if (!nextNodeType.equals(FlowNodeType.ACTION_NODE.getCode())) {
                        throw new BizException("\u5f00\u59cb\u8282\u70b9\u7684\u4e0b\u4e00\u4e2a\u8282\u70b9\u5fc5\u987b\u662f\u5904\u7406\u8282\u70b9");
                    }
                    existAction = true;
                    if (existStart) {
                        throw new BizException("\u5f00\u59cb\u8282\u70b9\u4ec5\u6709\u4e00\u4e2a\u4e14\u53ea\u6709\u4e00\u4e2a\u8f93\u51fa");
                    }
                    existStart = true;
                } else if (preNodeCode.equals(FlowPreNodeCode.END.getCode())) {
                    throw new BizException("\u7ed3\u675f\u8282\u70b9\u4e0d\u5b58\u5728\u8f93\u51fa\u7ebf");
                }
            } else if (preNodeType.equals(FlowNodeType.ACTION_NODE.getCode())) {
                Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)docType), (String)"\u53c2\u6570\u7f3a\u5c11\u5355\u636e\u5b9e\u4f53\u6570\u636e\uff0c\u8bf7\u68c0\u67e5");
                if (StringUtils.isBlank((CharSequence)nextNodeCode) || null == nextNodeType || nextNodeType.equals(FlowNodeType.PRE_NODE.getCode())) {
                    throw new BizException("\u5904\u7406\u8282\u70b9\u7684\u4e0b\u4e00\u4e2a\u8282\u70b9\u53ea\u80fd\u4e3a\u72b6\u6001\u8282\u70b9\u6216\u8005\u5904\u7406\u8282\u70b9");
                }
                if (!existAction) {
                    existAction = true;
                }
                if (nextNodeType.equals(FlowNodeType.STATUS_NODE.getCode())) {
                    String actionWithResult = preNodeCode + flwNodeLinkDto2.getPrevResult();
                    String statusField = flwNodeLinkDto2.getNextField();
                    String docTypeAndStatusField = docType + STATUS_SIGN + statusField;
                    String docTypeAndStatusFieldAndName = docTypeAndStatusField + flwNodeLinkDto2.getNextName();
                    ArrayList<String> statusFieldList = (ArrayList<String>)actionResult2Status.get(actionWithResult);
                    if (CollectionUtils.isNotEmpty((Collection)statusFieldList)) {
                        if (statusFieldList.contains(docTypeAndStatusField)) {
                            throw new BizException("\u5904\u7406\u8282\u70b9[" + flwNodeLinkDto2.getPrevName() + "]\u7684\u540c\u4e00\u7ed3\u679c[" + flwNodeLinkDto2.getPrevResult() + "]\u53ea\u80fd\u8fde\u4e00\u4e2a\u540c\u7c7b\u578b\u7684\u72b6\u6001");
                        }
                        statusFieldList.add(docTypeAndStatusField);
                    } else {
                        statusFieldList = new ArrayList<String>();
                        statusFieldList.add(docTypeAndStatusField);
                    }
                    actionResult2Status.put(actionWithResult, statusFieldList);
                    if (!fieldStatusDetailSet.contains(docTypeAndStatusFieldAndName)) {
                        Long statusId = this.processFlwStatusEo(nextNodeCode, statusField, flwNodeLinkDto2.getNextName(), docType, flwStatusInsertEos);
                        flwNodeLinkDto2.setNextCode(statusId.toString());
                        fieldStatusDetailSet.add(docTypeAndStatusFieldAndName);
                        statusName2StatusId.put(docTypeAndStatusFieldAndName, statusId.toString());
                    } else {
                        String statusIdStr = (String)statusName2StatusId.get(docTypeAndStatusFieldAndName);
                        flwNodeLinkDto2.setNextCode(statusIdStr);
                    }
                }
            } else if (preNodeType.equals(FlowNodeType.STATUS_NODE.getCode())) {
                Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)docType), (String)"\u53c2\u6570\u7f3a\u5c11\u5355\u636e\u5b9e\u4f53\u6570\u636e\uff0c\u8bf7\u68c0\u67e5");
                String statusField = flwNodeLinkDto2.getPrevField();
                String docTypeAndStatusField = docType + STATUS_SIGN + statusField;
                String docTypeAndStatusFieldAndName = docTypeAndStatusField + flwNodeLinkDto2.getPrevName();
                if (!fieldStatusDetailSet.contains(docTypeAndStatusFieldAndName)) {
                    Long statusId = this.processFlwStatusEo(preNodeCode, statusField, flwNodeLinkDto2.getPrevName(), docType, flwStatusInsertEos);
                    flwNodeLinkDto2.setPrevCode(statusId.toString());
                    fieldStatusDetailSet.add(docTypeAndStatusFieldAndName);
                    statusName2StatusId.put(docTypeAndStatusFieldAndName, statusId.toString());
                } else {
                    String statusIdStr = (String)statusName2StatusId.get(docTypeAndStatusFieldAndName);
                    flwNodeLinkDto2.setPrevCode(statusIdStr);
                }
            }
            this.checkLinkMultiple(docType, preNodeCode, preNodeType, nextNodeCode, nextNodeType, linkSet);
        }
        flwNodeLinkDtos.forEach(flwNodeLinkDto -> {
            FlwNodeLinkEo flwNodeLinkEo = this.toFlwNodeLinkEo((FlwNodeLinkDto)flwNodeLinkDto, flwSolutionId);
            flwNodeLinkEos.add(flwNodeLinkEo);
        });
        this.flwNodeLinkDas.insertBatch(flwNodeLinkEos);
        this.flwStatusDas.insertBatch(flwStatusInsertEos);
        this.flwNodeConvertMapService.refreshNodeConvertMap(flwSolutionId, flwNodeConvertMapReqDtos);
    }

    private String getStatusField(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        String[] statusArray = StringUtils.split((String)code, (String)STATUS_SIGN);
        return statusArray[0];
    }

    private String getStatusFlowCode(String statusField, String statusCode) {
        return statusField + STATUS_SIGN + statusCode;
    }

    private void checkLinkMultiple(String docType, String prevCode, Integer prevType, String nextCode, Integer nextType, Set<String> linkSet) {
        StringBuilder link = new StringBuilder();
        if (prevType.equals(FlowNodeType.STATUS_NODE.getCode())) {
            link.append(docType).append(prevCode);
        } else {
            link.append(prevCode);
        }
        if (nextType.equals(FlowNodeType.STATUS_NODE.getCode())) {
            link.append(docType).append(nextCode);
        } else {
            link.append(nextCode);
        }
        if (null != linkSet && linkSet.contains(link.toString())) {
            throw new BizException("\u53c2\u6570\u5b58\u5728\u91cd\u590d\u6d41\u8f6c\u94fe\u6761\uff0c\u8bf7\u68c0\u67e5");
        }
        if (null == linkSet) {
            linkSet = new HashSet<String>();
        }
        linkSet.add(link.toString());
    }

    private FlwNodeLinkEo toFlwNodeLinkEo(FlwNodeLinkDto flwNodeLinkDto, Long flwSolutionId) {
        FlwNodeLinkEo flwNodeLinkEo = new FlwNodeLinkEo();
        DtoHelper.dto2Eo((BaseVo)flwNodeLinkDto, (BaseEo)flwNodeLinkEo, (String[])new String[]{"id"});
        if (StringUtils.isBlank((CharSequence)flwNodeLinkDto.getPrevResult())) {
            flwNodeLinkEo.setPrevResult(FlowPreResultStatus.SUCC.getCode());
        }
        if (StringUtils.isBlank((CharSequence)flwNodeLinkDto.getPrevCode())) {
            flwNodeLinkEo.setPrevCode(NODE_NONE);
        }
        if (StringUtils.isBlank((CharSequence)flwNodeLinkDto.getNextCode())) {
            flwNodeLinkEo.setNextCode(NODE_NONE);
        }
        if (null == flwNodeLinkDto.getNextType()) {
            flwNodeLinkEo.setNextType(Integer.valueOf(0));
        }
        flwNodeLinkEo.setFlowDefId(flwSolutionId);
        if (StringUtils.isBlank((CharSequence)flwNodeLinkDto.getExtension())) {
            flwNodeLinkEo.setExtension("");
        }
        return flwNodeLinkEo;
    }

    private Long processFlwStatusEo(String statusflwCode, String statusField, String statusName, String docType, List<FlwStatusEo> flwStatusInsertEos) {
        Long statusId;
        if (StringUtils.isEmpty((CharSequence)statusflwCode)) {
            throw new BizException("\u72b6\u6001\u8282\u70b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List existedCodeEos = this.flwStatusDas.select4Unique(docType, statusField, statusflwCode, statusName);
        FlwStatusEo existedCodeEo = null;
        if (CollectionUtils.isNotEmpty((Collection)existedCodeEos)) {
            existedCodeEo = (FlwStatusEo)existedCodeEos.get(0);
        }
        if (existedCodeEo != null) {
            statusId = existedCodeEo.getId();
            FlwStatusEo updateStatusEo = new FlwStatusEo();
            updateStatusEo.setStatusName(statusName);
            updateStatusEo.setStatusField(statusField);
            updateStatusEo.setStatusCode(statusflwCode);
            updateStatusEo.setExtension("");
            updateStatusEo.setId(statusId);
            this.flwStatusDas.updateSelective((BaseEo)updateStatusEo);
        } else {
            FlwStatusEo flwStatusEo = new FlwStatusEo();
            flwStatusEo.setStatusField(statusField);
            flwStatusEo.setStatusCode(statusflwCode);
            flwStatusEo.setStatusName(statusName);
            flwStatusEo.setDocType(docType);
            flwStatusEo.setExtension("");
            flwStatusEo.setId(this.getId());
            statusId = flwStatusEo.getId();
            flwStatusEo.setStatus(Integer.valueOf(FlowStatusType.ANABLE.getCode()));
            flwStatusEo.setReadOnly(Common.DISABLE);
            flwStatusEo.setPreSet(Common.NO);
            List<FlwColorPoolEo> flwColorPoolEos = this.fetchColorPoolOrdered();
            String color = FlowServiceImpl.getColor(docType, statusField, flwColorPoolEos);
            flwStatusEo.setColor(color);
            flwStatusInsertEos.add(flwStatusEo);
        }
        return statusId;
    }

    private Long getId() {
        return IdGenrator.getDistributedId();
    }

    private String getSolutionCode() {
        return UUID.randomUUID().toString();
    }

    private String getSolutionVersion(String docType) {
        Integer versionInt = 1;
        String maxVersion = this.flwSolutionDas.selectMaxVersion(docType);
        if (StringUtils.isNotBlank((CharSequence)maxVersion)) {
            versionInt = Integer.valueOf(maxVersion) + 1;
        }
        return VERSION_PRE + versionInt.toString();
    }

    @Override
    public void publish() {
        this.commonsMqService.publishMessageAsync(this.environment.resolvePlaceholders("${flow.solution.refresh.topic:FLOW_PUBLISH_TOPIC}"), this.environment.resolvePlaceholders("${flow.solution.refresh.tag:FLOW_SOLUTION_MQ_TAG}"), (Object)"");
    }
}

