/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.flow.biz.service.impl;

import com.dtyunxi.cube.enhance.flow.NodeConvertMap;
import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.cube.starter.bundle.materiel.consumer.das.AbstractBaseDas;
import com.dtyunxi.cube.starter.bundle.utils.MyMapUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.flow.api.dto.request.FlwNodeConvertMapReqDto;
import com.dtyunxi.yundt.cube.center.flow.api.dto.response.FlwConvertNodeRespDto;
import com.dtyunxi.yundt.cube.center.flow.api.dto.response.FlwNodeConvertMapRespDto;
import com.dtyunxi.yundt.cube.center.flow.biz.service.IFlwNodeConvertMapService;
import com.dtyunxi.yundt.cube.center.flow.biz.util.SqlFilterBuilder;
import com.dtyunxi.yundt.cube.center.flow.dao.das.FlwConvertNodeDas;
import com.dtyunxi.yundt.cube.center.flow.dao.das.FlwNodeConvertMapDas;
import com.dtyunxi.yundt.cube.center.flow.dao.das.FlwNodeDas;
import com.dtyunxi.yundt.cube.center.flow.dao.eo.FlwConvertNodeEo;
import com.dtyunxi.yundt.cube.center.flow.dao.eo.FlwNodeConvertMapEo;
import com.dtyunxi.yundt.cube.center.flow.dao.eo.FlwNodeEo;
import com.dtyunxi.yundt.cube.center.func.biz.util.IDataUpdater;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class FlwNodeConvertMapServiceImpl
implements IFlwNodeConvertMapService {
    @Resource
    private FlwNodeDas flwNodeDas;
    @Resource
    private FlwConvertNodeDas flwConvertNodeDas;
    @Resource
    private FlwNodeConvertMapDas flwNodeConvertMapDas;

    @Override
    public Collection<FlwConvertNodeRespDto> searchConvertNode() {
        FlwConvertNodeEo selectParam = new FlwConvertNodeEo();
        List list = this.flwConvertNodeDas.select((BaseEo)selectParam);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        return list.stream().map(flwConvertNodeEo -> {
            FlwConvertNodeRespDto flwConvertNodeRespDto = new FlwConvertNodeRespDto();
            flwConvertNodeRespDto.setConvertNodeCode(flwConvertNodeEo.getCode());
            flwConvertNodeRespDto.setConvertNodeName(flwConvertNodeEo.getName());
            flwConvertNodeRespDto.setInputCode(flwConvertNodeEo.getInputCode());
            flwConvertNodeRespDto.setOutputCode(flwConvertNodeEo.getOutputCode());
            return flwConvertNodeRespDto;
        }).collect(Collectors.toList());
    }

    @Override
    public Collection<NodeConvertMap> findNodeConvertMap(Long flowDefId) {
        Map<Long, List<NodeConvertMap>> map = this.batchFindNodeConvertMap(Lists.newArrayList((Object[])new Long[]{flowDefId}));
        if (map != null) {
            return map.get(flowDefId);
        }
        return Lists.newArrayList();
    }

    @Override
    public Map<Long, List<NodeConvertMap>> batchFindNodeConvertMap(Collection<Long> flowDefIds) {
        HashMap map = Maps.newHashMap();
        FlwNodeConvertMapEo selectParam = new FlwNodeConvertMapEo();
        selectParam.setSqlFilters(SqlFilterBuilder.newInstance().buildInSqlFilter("flow_def_id", flowDefIds).get());
        List list = this.flwNodeConvertMapDas.select((BaseEo)selectParam);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Maps.newHashMap();
        }
        for (FlwNodeConvertMapEo flwNodeConvertMapEo : list) {
            NodeConvertMap nodeConvertMap = new NodeConvertMap();
            nodeConvertMap.setPrevNodeCode(flwNodeConvertMapEo.getPrevNodeCode());
            nodeConvertMap.setPrevNodeResultCode(flwNodeConvertMapEo.getPrevNodeResultCode());
            nodeConvertMap.setNextNodeCode(flwNodeConvertMapEo.getNextNodeCode());
            nodeConvertMap.setConvertNodeCode(flwNodeConvertMapEo.getConvertNodeCode());
            MyMapUtils.append2ListMap((Object)flwNodeConvertMapEo.getFlowDefId(), (Map)map, (Object)nodeConvertMap);
        }
        return map;
    }

    void rebindProcessNodeInfo(Map<String, List<FlwNodeConvertMapRespDto>> nodeCode2DtoMap) {
        if (MapUtils.isNotEmpty(nodeCode2DtoMap)) {
            FlwNodeEo flwNodeParam = new FlwNodeEo();
            flwNodeParam.setSqlFilters(SqlFilterBuilder.newInstance().buildInSqlFilter("code", nodeCode2DtoMap.keySet()).get());
            List flwNodeEos = this.flwNodeDas.select((BaseEo)flwNodeParam);
            if (CollectionUtils.isNotEmpty((Collection)flwNodeEos)) {
                flwNodeEos.forEach(item -> {
                    List bindList = (List)nodeCode2DtoMap.get(item.getCode());
                    if (CollectionUtils.isNotEmpty((Collection)bindList)) {
                        bindList.forEach(flwNodeConvertMapRespDto -> {
                            if (flwNodeConvertMapRespDto.getPrevNodeCode().equals(item.getCode())) {
                                flwNodeConvertMapRespDto.setPrevNodeName(item.getName());
                            }
                            if (flwNodeConvertMapRespDto.getNextNodeCode().equals(item.getCode())) {
                                flwNodeConvertMapRespDto.setNextNodeName(item.getName());
                            }
                        });
                    }
                });
            }
        }
    }

    void rebindConvertNodeInfo(Map<String, List<FlwNodeConvertMapRespDto>> convertNodeCode2DtoMap) {
        if (MapUtils.isNotEmpty(convertNodeCode2DtoMap)) {
            FlwConvertNodeEo flwConvertParam = new FlwConvertNodeEo();
            flwConvertParam.setSqlFilters(SqlFilterBuilder.newInstance().buildInSqlFilter("code", convertNodeCode2DtoMap.keySet()).get());
            List flwConvertNodeEos = this.flwConvertNodeDas.select((BaseEo)flwConvertParam);
            if (CollectionUtils.isNotEmpty((Collection)flwConvertNodeEos)) {
                flwConvertNodeEos.forEach(item -> {
                    List bindList = (List)convertNodeCode2DtoMap.get(item.getCode());
                    if (CollectionUtils.isNotEmpty((Collection)bindList)) {
                        bindList.forEach(flwNodeConvertMapRespDto -> {
                            FlwConvertNodeRespDto convertNode = flwNodeConvertMapRespDto.getConvertNode();
                            convertNode.setOutputCode(item.getOutputCode());
                            convertNode.setInputCode(item.getInputCode());
                            convertNode.setConvertNodeName(item.getName());
                        });
                    }
                });
            }
        }
    }

    @Override
    public void refreshNodeConvertMap(final Long flowDefId, Collection<FlwNodeConvertMapReqDto> list) {
        IDataUpdater<String, FlwNodeConvertMapEo> dataUpdater = new IDataUpdater<String, FlwNodeConvertMapEo>(){

            public String getKey(FlwNodeConvertMapEo source) {
                return String.format("%s_%s_%s_%s", source.getPrevNodeCode(), source.getPrevNodeResultCode(), source.getConvertNodeCode(), source.getNextNodeCode());
            }

            public FlwNodeConvertMapEo getSelectParamEo() {
                FlwNodeConvertMapEo selectParam = new FlwNodeConvertMapEo();
                selectParam.setFlowDefId(flowDefId);
                return selectParam;
            }

            public FlwNodeConvertMapEo getDeleteParamEo() {
                return new FlwNodeConvertMapEo();
            }
        };
        HashMap key2EoMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(list)) {
            for (FlwNodeConvertMapReqDto item : list) {
                FlwNodeConvertMapEo eo = new FlwNodeConvertMapEo();
                BeanUtils.copyProperties((Object)item, (Object)eo);
                eo.setFlowDefId(flowDefId);
                eo.setExtension("");
                key2EoMap.put(dataUpdater.getKey((CubeBaseEo)eo), eo);
            }
        }
        dataUpdater.process((Map)key2EoMap, (AbstractBaseDas)this.flwNodeConvertMapDas);
    }
}

