package com.dtyunxi.yundt.cube.bundle.org.center.user.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.bundle.org.center.user.api.dto.base.BatchDto;
import com.dtyunxi.yundt.cube.bundle.org.center.user.api.dto.request.PostReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * 岗位服务接口
 *
 * @see com.dtyunxi.yundt.cube.center.user.api.IPostExtApi
 * @author 代码生成器
 */
@Api(tags = {"用户中心：岗位服务(v1)"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-bundle-org-center-user-api-IPostApi",
        name = "${dtyunxi.yundt.cube_organization-center-user_api.name:organization-center-user}",
        url = "${dtyunxi.yundt.cube_organization-center-user_api:}",
        path = "/v1/post"
)
public interface IPostApi {

    /**
     * 新增岗位
     *
     * @param addReqDto 岗位请求对象
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增岗位", notes = "新增岗位")
    RestResponse<Long> add(@RequestBody PostReqDto addReqDto);

    /**
     * 修改岗位
     *
     * @param modifyReqDto 岗位请求对象
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改岗位", notes = "修改岗位")
    RestResponse<Void> modify(@RequestBody PostReqDto modifyReqDto);

    /**
     * 删除岗位
     *
     * @param ids        岗位删除数据ID
     * @param instanceId 实例ID
     * @return 处理结果
     */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除岗位", notes = "删除岗位")
    RestResponse<Void> remove(@PathVariable("ids") String ids, @RequestParam("instanceId") Long instanceId);

    /**
     * 启用岗位
     *
     * @param id id
     * @return 处理结果
     */
    @PutMapping("{id}/enable")
    @ApiOperation(value = "启用岗位", notes = "启用岗位")
    RestResponse<Void> enable(@PathVariable("id") Long id);

    /**
     * 禁用岗位
     *
     * @param id id
     * @return 处理结果
     */
    @PutMapping("{id}/disable")
    @ApiOperation(value = "禁用岗位", notes = "禁用岗位")
    RestResponse<Void> disable(@PathVariable("id") Long id);


    /**
     * 批量启用岗位
     *
     * @param batchDto
     * @return 处理结果
     */
    @PutMapping("enable")
    @ApiOperation(value = "批量启用岗位", notes = "批量启用岗位")
    RestResponse<Void> batchEnable(BatchDto batchDto);

    /**
     * 批量禁用岗位
     *
     * @param batchDto
     * @return 处理结果
     */
    @PutMapping("disable")
    @ApiOperation(value = "批量禁用岗位", notes = "批量禁用岗位")
    RestResponse<Void> batchDisable(BatchDto batchDto);
}
