/**
 * @(#)OrganizationInfoDto.java 1.0 May 17, 2018
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.dto;

import com.dtyunxi.cube.utils.bean.VerifyUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.Email;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.util.Date;

/**
 * 组织信息Dto
 * 用于新建,存放,查询组织信息的数据传输对象
 *
 * @author 伊泽
 * @since 1.0.0
 */
@ApiModel(value = "OrganizationInfoDto", description = "组织信息")
public class OrganizationInfoDto extends BaseDto {

    private static final long serialVersionUID = 6299927543391517961L;

    /**
     * id
     */
    @ApiModelProperty(value = "id")
    private Long id;
    /**
     * 统一社会信用代码
     */
    @NotNull(message = "统一社会信用代码不能为null")
    @ApiModelProperty(value = "统一社会信用代码，新增必填")
    private String creditCode;
    /**
     * 组织名称
     */
    @NotNull(message = "组织名称不能为null")
    @ApiModelProperty(value = "组织名称，新增必填")
    private String orgName;
    /**
     * 公司地址
     */
    @ApiModelProperty(value = "公司地址，选填")
    private String address;
    /**
     * 法人姓名
     */
    @NotNull(message = "法人姓名不能为null")
    @ApiModelProperty(value = "法人姓名，新增必填")
    private String legalName;
    /**
     * 注册资本
     */
    @ApiModelProperty(value = "注册资本，选填")
    private String registeredCapital;

    /**
     * 机构类型
     */
    @ApiModelProperty(value = "机构类型，选填")
    private String orgType;
    /**
     * 经营范围
     */
    @ApiModelProperty(value = "经营范围，选填")
    private String busiScope;
    /**
     * 企业注册日期
     */
    @DateTimeFormat(iso = DateTimeFormat.ISO.DATE)
    @ApiModelProperty(value = "企业注册日期，选填")
    private Date foundingTime;
    /**
     * 用户Id
     */
    @ApiModelProperty(value = "用户Id")
    private Long userId;

    /**
     * 组织编号
     */
    @NotNull(message = "组织编号不能为null")
    @ApiModelProperty(value = "组织编号，新增必填")
    private String orgCode;

    /**
     * 简称
     */
    @ApiModelProperty(value = "简称，选填")
    private String simpleName;

    /**
     * 邮编
     */
    @ApiModelProperty(value = "邮编，选填")
    private String postcode;
    /**
     * 传真
     */
    @ApiModelProperty(value = "传真，选填")
    private String fax;
    /**
     * 员工数量
     */
    @ApiModelProperty(value = "员工数量，选填")
    private String staffNum;
    /**
     * 法人证件号码
     */
    @ApiModelProperty(value = "法人证件号码，选填")
    private String legalCardNum;

    /**
     * 身份证正面
     */
    @ApiModelProperty(value = "身份证正面，选填")
    private String idCardFront;

    /**
     * 身份证反面
     */
    @ApiModelProperty(value = "身份证反面，选填")
    private String idCardBack;

    /**
     * 联系人
     */
    @ApiModelProperty(value = "联系人，选填")
    private String linkman;
    /**
     * 联系电话
     */
    @Pattern(regexp = VerifyUtil.REGEX_MOBILE, message = "联系电话格式错误")
    @ApiModelProperty(value = "联系电话，选填")
    private String phoneNum;

    /**
     * 公司电话
     */
    @Pattern(regexp = "0[0-9]{2,3}\\-[1-9][0-9]{6,7}", message = "公司电话格式错误")
    @ApiModelProperty(value = "公司电话，选填")
    private String companyTel;
    /**
     * 公司邮箱
     */
    @Email
    @ApiModelProperty(value = "公司邮箱，选填")
    private String companyEmail;
    /**
     * 营业执照URL
     */
    @ApiModelProperty(value = "营业执照URL，选填")
    private String bussinessLicenseUrl;

    /**
     * 法人身份证
     */
    @ApiModelProperty(value = "法人身份证，选填")
    private String legalManCard;
    /**
     * 银行开户名
     */
    @ApiModelProperty(value = "银行开户名，选填")
    private String accountName;
    /**
     * 开户行卡号
     */
    @ApiModelProperty(value = "开户行卡号，选填")
    private String accountNum;
    /**
     * 开户行支行名称
     */
    @ApiModelProperty(value = "开户行支行名称，选填")
    private String branchAccountName;
    /**
     * 开户行支行联行号
     */
    @ApiModelProperty(value = "开户行支行联行号，选填")
    private String branchAccountNum;

    /**
     * 企业logoURL
     */
    @ApiModelProperty(value = "企业logoURL，选填")
    private String logoUrl;

    /**
     * 组织机构代码证号
     */
    @ApiModelProperty(value = "组织机构代码证号，选填")
    private String orgCertNo;
    /**
     * 税务登记号
     */
    @ApiModelProperty(value = "税务登记号，选填")
    private String taxNo;
    /**
     * 营业执照号
     */
    @ApiModelProperty(value = "营业执照号，选填")
    private String businessLicenseNo;

    public String getIdCardFront() {
        return idCardFront;
    }

    public void setIdCardFront(String idCardFront) {
        this.idCardFront = idCardFront;
    }

    public String getIdCardBack() {
        return idCardBack;
    }

    public void setIdCardBack(String idCardBack) {
        this.idCardBack = idCardBack;
    }

    public String getCreditCode() {
        return creditCode;
    }

    public void setCreditCode(String creditCode) {
        this.creditCode = creditCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getLegalName() {
        return legalName;
    }

    public void setLegalName(String legalName) {
        this.legalName = legalName;
    }

    public String getRegisteredCapital() {
        return registeredCapital;
    }

    public void setRegisteredCapital(String registeredCapital) {
        this.registeredCapital = registeredCapital;
    }

    public String getOrgType() {
        return orgType;
    }

    public void setOrgType(String orgType) {
        this.orgType = orgType;
    }

    public String getBusiScope() {
        return busiScope;
    }

    public void setBusiScope(String busiScope) {
        this.busiScope = busiScope;
    }

    public Date getFoundingTime() {
        return foundingTime;
    }

    public void setFoundingTime(Date foundingTime) {
        this.foundingTime = foundingTime;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getSimpleName() {
        return simpleName;
    }

    public void setSimpleName(String simpleName) {
        this.simpleName = simpleName;
    }

    public String getPostcode() {
        return postcode;
    }

    public void setPostcode(String postcode) {
        this.postcode = postcode;
    }

    public String getFax() {
        return fax;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    public String getStaffNum() {
        return staffNum;
    }

    public void setStaffNum(String staffNum) {
        this.staffNum = staffNum;
    }

    public String getLegalCardNum() {
        return legalCardNum;
    }

    public void setLegalCardNum(String legalCardNum) {
        this.legalCardNum = legalCardNum;
    }

    public String getLinkman() {
        return linkman;
    }

    public void setLinkman(String linkman) {
        this.linkman = linkman;
    }

    public String getPhoneNum() {
        return phoneNum;
    }

    public void setPhoneNum(String phoneNum) {
        this.phoneNum = phoneNum;
    }

    public String getCompanyTel() {
        return companyTel;
    }

    public void setCompanyTel(String companyTel) {
        this.companyTel = companyTel;
    }

    public String getCompanyEmail() {
        return companyEmail;
    }

    public void setCompanyEmail(String companyEmail) {
        this.companyEmail = companyEmail;
    }

    public String getLegalManCard() {
        return legalManCard;
    }

    public void setLegalManCard(String legalManCard) {
        this.legalManCard = legalManCard;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getAccountNum() {
        return accountNum;
    }

    public void setAccountNum(String accountNum) {
        this.accountNum = accountNum;
    }

    public String getBranchAccountName() {
        return branchAccountName;
    }

    public void setBranchAccountName(String branchAccountName) {
        this.branchAccountName = branchAccountName;
    }

    public String getBranchAccountNum() {
        return branchAccountNum;
    }

    public void setBranchAccountNum(String branchAccountNum) {
        this.branchAccountNum = branchAccountNum;
    }

    public String getBussinessLicenseUrl() {
        return bussinessLicenseUrl;
    }

    public void setBussinessLicenseUrl(String bussinessLicenseUrl) {
        this.bussinessLicenseUrl = bussinessLicenseUrl;
    }

    public String getLogoUrl() {
        return logoUrl;
    }

    public void setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getOrgCertNo() {
        return orgCertNo;
    }

    public void setOrgCertNo(String orgCertNo) {
        this.orgCertNo = orgCertNo;
    }

    public String getTaxNo() {
        return taxNo;
    }

    public void setTaxNo(String taxNo) {
        this.taxNo = taxNo;
    }

    public String getBusinessLicenseNo() {
        return businessLicenseNo;
    }

    public void setBusinessLicenseNo(String businessLicenseNo) {
        this.businessLicenseNo = businessLicenseNo;
    }
}
