package com.dtyunxi.yundt.cube.center.user.api.dto.response;

import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.user.api.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 高级用户组织功能包的组织单元(业务单元)详情信息
 *
 * @author shuangqing
 */
@ApiModel(value = "OrgAdvDetailRespDto", description = "组织单元(业务单元)详情信息dto")
public class OrgAdvDetailRespDto extends BaseVo {
    /**
     * 组织单元id
     */
    @ApiModelProperty(value = "组织单元id")
    private Long id;

    /**
     * 第三方组织id
     */
    private String thirdOrgId;

    /**
     * 组织单元编号
     */
    @ApiModelProperty(value = "组织单元编号")
    private String code;

    /**
     * 组织类型
     */
    @ApiModelProperty(value = "用户组织功能包需求 0：公司 1：部门 2：业务组织单元 3：虚拟组织单元")
    private String type;

    /**
     * 组织单元名称
     */
    @ApiModelProperty(value = "组织单元名称")
    private String name;

    /**
     * 父级单元Id
     */
    @ApiModelProperty(value = "父级单元Id")
    private Long parentId;

    /**
     * 父级名称
     */
    @ApiModelProperty(value = "父级名称")
    private String parentName;
    /**
     * 状态(0禁用,1启用)
     */
    @ApiModelProperty(value = "状态(0禁用,1启用)")
    private String status;

    /**
     * 实体属性编码
     */
    @ApiModelProperty(value = "实体属性编码")
    private String entityPropCode;

    /**
     * 实体属性名称
     */
    @ApiModelProperty(value = "实体属性名称")
    private String entityPropName;

    /**
     * 公司组织机构码
     */
    @ApiModelProperty(value = "公司组织机构码")
    private String companyOrgCode;

    /**
     * 公司组织机构名称
     */
    @ApiModelProperty(value = "公司组织机构名称")
    private String companyOrgName;

    /**
     * 电话
     */
    @ApiModelProperty(value = "电话")
    private String telephone;
    /**
     * 负责人
     */
    @ApiModelProperty(value = "负责人")
    private String principal;

    /**
     * 地址
     */
    @ApiModelProperty(value = "地址")
    private String address;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;

    /**
     * 排序号
     */
    @ApiModelProperty(value = "排序号")
    private Integer sortNO;

    /**
     * 组织职能类型编码列表
     */
    @ApiModelProperty(value = "组织职能类型编码列表")
    private List<String> funcTypeCodes;

    /**
     * 组织业务单元的组织属性dto列表
     */
    @ApiModelProperty(value = "组织业务单元的组织属性dto列表")
    private List<OrgAdvPropRespDto> orgAdvPropRespDtos;

    /**
     * 组织单元-公司相关信息响应dto
     */
    @ApiModelProperty(value = "组织单元-公司相关信息响应dto")
    private OrgAdvInfoRespDto orgAdvInfoRespDto;

    /**
     * 组织名称(国际语言1约定为英文，组织信息同步到企业微信作为部门英文名称时使用)
     */
    @ApiModelProperty(value = "组织名称(国际语言1约定为英文，组织信息同步到企业微信作为部门英文名称时使用)")
    private String nameI1;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getEntityPropCode() {
        return entityPropCode;
    }

    public void setEntityPropCode(String entityPropCode) {
        this.entityPropCode = entityPropCode;
    }

    public String getCompanyOrgCode() {
        return companyOrgCode;
    }

    public void setCompanyOrgCode(String companyOrgCode) {
        this.companyOrgCode = companyOrgCode;
    }

    public String getTelephone() {
        return telephone;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    public String getPrincipal() {
        return principal;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Integer getSortNO() {
        return sortNO;
    }

    public void setSortNO(Integer sortNO) {
        this.sortNO = sortNO;
    }

    public List<OrgAdvPropRespDto> getOrgAdvPropRespDtos() {
        return orgAdvPropRespDtos;
    }

    public void setOrgAdvPropRespDtos(List<OrgAdvPropRespDto> orgAdvPropRespDtos) {
        this.orgAdvPropRespDtos = orgAdvPropRespDtos;
    }

    public List<String> getFuncTypeCodes() {
        return funcTypeCodes;
    }

    public void setFuncTypeCodes(List<String> funcTypeCodes) {
        this.funcTypeCodes = funcTypeCodes;
    }

    public String getParentName() {
        return parentName;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public String getEntityPropName() {
        return entityPropName;
    }

    public void setEntityPropName(String entityPropName) {
        this.entityPropName = entityPropName;
    }

    public String getCompanyOrgName() {
        return companyOrgName;
    }

    public void setCompanyOrgName(String companyOrgName) {
        this.companyOrgName = companyOrgName;
    }

    public OrgAdvInfoRespDto getOrgAdvInfoRespDto() {
        return orgAdvInfoRespDto;
    }

    public void setOrgAdvInfoRespDto(OrgAdvInfoRespDto orgAdvInfoRespDto) {
        this.orgAdvInfoRespDto = orgAdvInfoRespDto;
    }

    public String getNameI1() {
        return nameI1;
    }

    public void setNameI1(String nameI1) {
        this.nameI1 = nameI1;
    }

    public String getThirdOrgId() {
        return thirdOrgId;
    }

    public void setThirdOrgId(String thirdOrgId) {
        this.thirdOrgId = thirdOrgId;
    }
}
