/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.user.api.constants.RedisKeyConstants;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeAddReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeExtQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeModifyReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgOrgDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.EmployeeRespDto;
import com.dtyunxi.yundt.cube.center.user.biz.service.IEmployeeEventService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IEmployeeExtService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IOrgGroupService;
import com.dtyunxi.yundt.cube.center.user.dao.das.EmployeeDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.EmployeeOrgDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.EmployeePostDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.OrganizationDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.PostDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.UserDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.EmployeeEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.EmployeeOrgEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.EmployeePostEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.PostEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdUserEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.UserEo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class EmployeeExtServiceImpl
implements IEmployeeExtService {
    @Resource
    private EmployeeDas employeeDas;
    @Resource
    private EmployeePostDas employeePostDas;
    @Resource
    private EmployeeOrgDas employeeOrgDas;
    @Resource
    private OrganizationDas organizationDas;
    @Resource
    private IOrgGroupService orgGroupService;
    @Resource
    private UserDas userDas;
    @Resource
    private IEmployeeEventService employeeEventService;
    @Resource
    private ICacheService cacheService;
    @Resource
    private PostDas postDas;

    private Long getTenantId(Long tenantId) {
        Long l = tenantId = tenantId == null ? ServiceContext.getContext().getRequestTenantId() : tenantId;
        if (tenantId == null) {
            throw new BizException("500", "\u79df\u6237Id\u4e0d\u80fd\u4e3anull");
        }
        if (tenantId == 0L) {
            throw new BizException("500", "\u79df\u6237Id\u4e0d\u80fd\u4e3a0");
        }
        return tenantId;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addEmployee(EmployeeAddReqDto reqDto) {
        List postIds;
        reqDto.setTenantId(this.getTenantId(reqDto.getTenantId()));
        if (reqDto.getStatus() == null) {
            reqDto.setStatus(Integer.valueOf(1));
        }
        EmployeeEo record = new EmployeeEo();
        record.setTenantId(reqDto.getTenantId());
        String employeeNo = reqDto.getEmployeeNo();
        record.setEmployeeNo(employeeNo);
        if (this.employeeDas.count((BaseEo)record) > 0) {
            throw new BizException("500", "\u5458\u5de5\u7f16\u53f7\u5df2\u5b58\u5728");
        }
        final EmployeeEo employeeEo = new EmployeeEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)employeeEo);
        List employeeOrgDtos = reqDto.getOrgDtoList();
        this.employeeDas.insert((BaseEo)employeeEo);
        Long id = employeeEo.getId();
        Long tenantId = reqDto.getTenantId();
        if (!CollectionUtils.isEmpty((Collection)employeeOrgDtos)) {
            this.insertBatchEmployeeOrg(employeeOrgDtos, tenantId, id, reqDto.getUserId());
        }
        if (!CollectionUtils.isEmpty((Collection)(postIds = reqDto.getPostIds()))) {
            this.insertBatchEmployeePost(id, employeeNo, tenantId, postIds);
        }
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

            public void afterCommit() {
                EmployeeExtServiceImpl.this.employeeEventService.addEvent(employeeEo);
            }
        });
        return employeeEo.getId();
    }

    private void checkPhoneNum(Long tenantId, String phoneNum) {
        EmployeeEo query = new EmployeeEo();
        query.setTenantId(tenantId);
        query.setPhoneNum(phoneNum);
        if (this.employeeDas.count((BaseEo)query) > 0) {
            throw new BizException("500", "\u8054\u7cfb\u65b9\u5f0f\u5df2\u5b58\u5728");
        }
    }

    private void insertBatchEmployeeOrg(List<OrgOrgDto> employeeOrgDtos, Long tenantId, Long employeeId, Long userId) {
        long existNull = employeeOrgDtos.stream().filter(e -> e.getOrgGroupId() == null).count();
        Long orgGroupId = null;
        if (existNull > 0L && (orgGroupId = this.orgGroupService.queryDefaultHumanOrgGroup(tenantId)) == null) {
            throw new BizException("500", "orgGroupId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long finalOrgGroupId = orgGroupId;
        List employeeOrgEos = employeeOrgDtos.stream().map(e -> {
            EmployeeOrgEo eo = new EmployeeOrgEo();
            eo.setTenantId(tenantId);
            eo.setEmployeeId(employeeId);
            eo.setOrgGroupId(e.getOrgGroupId() == null ? finalOrgGroupId : e.getOrgGroupId());
            eo.setOrganizationId(e.getOrgId());
            eo.setUserId(userId);
            eo.setExtension("");
            return eo;
        }).collect(Collectors.toList());
        this.employeeOrgDas.insertBatch(employeeOrgEos);
    }

    private void insertBatchEmployeePost(Long employeeId, String employeeNo, Long tenantId, List<Long> postIds) {
        List employeePostEoList = postIds.stream().map(e -> {
            EmployeePostEo eo = new EmployeePostEo();
            eo.setTenantId(tenantId);
            eo.setEmployeeId(employeeId);
            eo.setEmployeeNo(employeeNo);
            eo.setPostId(e);
            PostEo postEo = (PostEo)this.postDas.selectByPrimaryKey(e);
            if (postEo != null) {
                eo.setPostCode(postEo.getCode());
            }
            eo.setStatus(Integer.valueOf(1));
            eo.setExtension("");
            return eo;
        }).collect(Collectors.toList());
        this.employeePostDas.insertBatch(employeePostEoList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyEmployee(EmployeeModifyReqDto reqDto) {
        List postIds;
        Long id = reqDto.getId();
        EmployeeEo empDb = (EmployeeEo)this.employeeDas.selectByPrimaryKey(id);
        if (empDb == null) {
            return;
        }
        reqDto.setTenantId(this.getTenantId(reqDto.getTenantId()));
        if (StrUtil.isNotBlank((CharSequence)reqDto.getPhoneNum()) && ObjectUtil.notEqual((Object)reqDto.getPhoneNum(), (Object)empDb.getPhoneNum())) {
            this.checkPhoneNum(reqDto.getTenantId(), reqDto.getPhoneNum());
        }
        final EmployeeEo employeeEo = new EmployeeEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)employeeEo);
        employeeEo.setTenantId(null);
        employeeEo.setEmployeeNo(null);
        this.employeeDas.updateSelective((BaseEo)employeeEo);
        List employeeOrgDtos = reqDto.getOrgDtoList();
        Long tenantId = empDb.getTenantId();
        if (employeeOrgDtos != null) {
            EmployeeOrgEo eo = new EmployeeOrgEo();
            eo.setTenantId(tenantId);
            eo.setEmployeeId(id);
            this.employeeOrgDas.delete((BaseEo)eo);
            if (employeeOrgDtos.size() > 0) {
                this.insertBatchEmployeeOrg(employeeOrgDtos, tenantId, id, reqDto.getUserId());
            }
            String key = RedisKeyConstants.combineKey((String)"findByEmployeeId", (Object[])new Object[]{employeeEo.getId()});
            this.cacheService.delCache(key);
        }
        if ((postIds = reqDto.getPostIds()) != null) {
            EmployeePostEo eo = new EmployeePostEo();
            eo.setTenantId(tenantId);
            eo.setEmployeeId(id);
            this.employeePostDas.delete((BaseEo)eo);
            if (postIds.size() > 0) {
                this.insertBatchEmployeePost(id, empDb.getEmployeeNo(), tenantId, postIds);
            }
        }
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

            public void afterCommit() {
                EmployeeExtServiceImpl.this.employeeEventService.updateEvent(employeeEo);
            }
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void changeEmployeeStatus(String ids, Integer status) {
        if (!StringUtils.hasText((String)ids)) {
            throw new BizException("500", "ids\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (status == null || !Arrays.asList(0, 1).contains(status)) {
            throw new BizException("500", "\u72b6\u6001\u53ea\u4e3a\u7981\u75280,\u542f\u75281");
        }
        final ArrayList employeeEos = new ArrayList();
        Arrays.stream(ids.split(",")).forEach(idStr -> {
            EmployeeEo employeeEo = (EmployeeEo)this.employeeDas.selectByPrimaryKey(Long.valueOf(idStr));
            if (employeeEo != null) {
                employeeEos.add(employeeEo);
                employeeEo.setStatus(status);
                this.employeeDas.updateSelective((BaseEo)employeeEo);
            }
        });
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

            public void afterCommit() {
                employeeEos.forEach(employeeEo -> EmployeeExtServiceImpl.this.employeeEventService.updateEvent((EmployeeEo)employeeEo));
            }
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeEmployee(String ids) {
        String[] removeIds;
        final ArrayList<EmployeeEo> employeeEos = new ArrayList<EmployeeEo>();
        for (String id : removeIds = ids.split(",")) {
            String key;
            Long idLong = Long.valueOf(id.trim());
            EmployeeEo employeeEo = (EmployeeEo)this.employeeDas.selectByPrimaryKey(idLong);
            if (employeeEo == null) continue;
            employeeEos.add(employeeEo);
            this.employeeDas.logicDeleteById(idLong);
            EmployeeOrgEo employeeOrgEo = new EmployeeOrgEo();
            employeeOrgEo.setTenantId(employeeEo.getTenantId());
            employeeOrgEo.setEmployeeId(employeeEo.getId());
            this.employeeOrgDas.logicDelete((BaseEo)employeeOrgEo);
            EmployeePostEo employeePostEo = new EmployeePostEo();
            employeePostEo.setTenantId(employeeEo.getTenantId());
            employeePostEo.setEmployeeId(idLong);
            this.employeePostDas.logicDelete((BaseEo)employeePostEo);
            if (employeeEo.getUserId() != null) {
                key = RedisKeyConstants.combineKey((String)"findByUserId", (Object[])new Object[]{employeeEo.getUserId()});
                this.cacheService.delCache(key);
            }
            key = RedisKeyConstants.combineKey((String)"findByEmployeeId", (Object[])new Object[]{employeeEo.getId()});
            this.cacheService.delCache(key);
        }
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

            public void afterCommit() {
                employeeEos.forEach(employeeEo -> {
                    employeeEo.setDr(1);
                    EmployeeExtServiceImpl.this.employeeEventService.deleteEvent((EmployeeEo)employeeEo);
                });
            }
        });
    }

    @Override
    public EmployeeRespDto queryById(Long id) {
        UserEo userEo;
        EmployeeEo employeeEo = (EmployeeEo)this.employeeDas.selectByPrimaryKey(id);
        if (employeeEo == null) {
            return null;
        }
        EmployeeRespDto employeeRespDto = new EmployeeRespDto();
        DtoHelper.eo2Dto((BaseEo)employeeEo, (BaseVo)employeeRespDto);
        Long tenantId = employeeEo.getTenantId();
        List orgDtos = this.employeeDas.selectOrg(tenantId, null, id);
        employeeRespDto.setOrgDtoList(orgDtos);
        employeeRespDto.setPostDtoList(this.employeeDas.selectPost(tenantId, null, id));
        if (employeeRespDto.getUserId() != null && (userEo = (UserEo)this.userDas.selectByPrimaryKey(employeeRespDto.getUserId())) != null) {
            employeeRespDto.setUserName(userEo.getUserName());
        }
        return employeeRespDto;
    }

    @Override
    public EmployeeRespDto queryByUserId() {
        Long userId = ServiceContext.getContext().getRequestUserId();
        Assert.notNull((Object)userId, (String)"\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        List employeeList = this.employeeDas.findByUserId(userId);
        if (CollectionUtil.isNotEmpty((Collection)employeeList)) {
            return this.queryById(((EmployeeEo)employeeList.get(0)).getId());
        }
        return null;
    }

    @Override
    public PageInfo<EmployeeRespDto> queryByPage(EmployeeExtQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        Set userIds;
        reqDto.setTenantId(this.getTenantId(reqDto.getTenantId()));
        if (reqDto.getOrgGroupId() == null) {
            Long orgGroupId = this.orgGroupService.queryDefaultHumanOrgGroup(reqDto.getTenantId());
            if (orgGroupId == null) {
                throw new BizException("500", "orgGroupId\u4e0d\u80fd\u4e3a\u7a7a");
            }
            reqDto.setOrgGroupId(orgGroupId);
        }
        if (reqDto.getUserId() != null) {
            reqDto.setUserIdList(Collections.singletonList(reqDto.getUserId()));
        } else if (StrUtil.isNotBlank((CharSequence)reqDto.getUserName())) {
            UserEo queryEo = new UserEo();
            queryEo.setSqlFilters(Collections.singletonList(SqlFilter.like((String)"user_name", (Object)("%" + reqDto.getUserName() + "%"))));
            List userEoList = this.userDas.select((BaseEo)queryEo, Integer.valueOf(1), Integer.valueOf(100));
            if (CollectionUtil.isNotEmpty((Collection)userEoList)) {
                reqDto.setUserIdList(userEoList.stream().map(BaseEo::getId).collect(Collectors.toList()));
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)reqDto.getUserIdList())) {
            reqDto.setEmployeeNo(null);
            reqDto.setName(null);
            reqDto.setOrgId(null);
            reqDto.setStatus(null);
            reqDto.setPhoneNum(null);
        } else if (reqDto.getUserId() != null || StrUtil.isNotBlank((CharSequence)reqDto.getUserName())) {
            return new PageInfo();
        }
        pageNum = pageNum == null ? 1 : pageNum;
        pageSize = pageSize == null ? 10 : pageSize;
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List dtoList = this.employeeDas.selectOrgGroupEmployee(reqDto);
        if (Boolean.TRUE.equals(reqDto.getWithOrg())) {
            dtoList.forEach(dto -> {
                String orgIdsStr = dto.getOrgIds();
                if (StringUtils.hasText((String)orgIdsStr)) {
                    List orgIds = Arrays.stream(orgIdsStr.split(",")).map(Long::parseLong).collect(Collectors.toList());
                    List organizationEo = this.organizationDas.selectByIds(orgIds);
                    List orgDtos = organizationEo.stream().map(e -> {
                        OrgOrgDto orgOrgDto = new OrgOrgDto();
                        orgOrgDto.setOrgGroupId(dto.getOrgGroupId());
                        orgOrgDto.setOrgId(e.getId());
                        orgOrgDto.setOrgName(e.getName());
                        return orgOrgDto;
                    }).collect(Collectors.toList());
                    dto.setOrgDtoList(orgDtos);
                }
            });
        }
        if (Boolean.TRUE.equals(reqDto.getWithPost())) {
            dtoList.forEach(e -> e.setPostDtoList(this.employeeDas.selectPost(e.getTenantId(), null, e.getId())));
        }
        if (Boolean.TRUE.equals(reqDto.getWithUserName()) && (userIds = dtoList.stream().filter(dto -> dto.getUserId() != null).map(EmployeeRespDto::getUserId).collect(Collectors.toSet())).size() > 0) {
            List userEoList = this.userDas.findByIds(userIds);
            if (!CollectionUtils.isEmpty((Collection)userEoList)) {
                Map<Long, String> userId2UserNameMap = userEoList.stream().collect(Collectors.toMap(BaseEo::getId, StdUserEo::getUserName));
                dtoList.forEach(dto -> {
                    if (dto.getUserId() != null) {
                        String userName = (String)userId2UserNameMap.get(dto.getUserId());
                        if (StrUtil.isNotBlank((CharSequence)userName)) {
                            dto.setUserName(userName);
                        } else {
                            dto.setUserId(null);
                        }
                    }
                });
            } else {
                dtoList.forEach(dto -> dto.setUserId(null));
            }
        }
        return new PageInfo(dtoList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addBatchEmployee(List<EmployeeAddReqDto> addReqDtoList) {
        if (CollectionUtil.isEmpty(addReqDtoList)) {
            throw new BizException("500", "\u5458\u5de5\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        Long tenantId = ServiceContext.getContext().getRequestTenantId();
        this.paramCheck(addReqDtoList, tenantId);
        Long orgGroupId = this.orgGroupService.queryDefaultHumanOrgGroup(tenantId);
        if (orgGroupId == null) {
            throw new BizException("500", "orgGroupId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList employeeEoList = new ArrayList(addReqDtoList.size());
        ArrayList employeeOrgEoList = new ArrayList();
        addReqDtoList.forEach(employeeAddReqDto -> {
            if (employeeAddReqDto.getStatus() == null) {
                employeeAddReqDto.setStatus(Integer.valueOf(1));
            }
            EmployeeEo employeeEo = new EmployeeEo();
            DtoHelper.dto2Eo((BaseVo)employeeAddReqDto, (BaseEo)employeeEo);
            employeeEo.setExtension("");
            employeeEo.setTenantId(tenantId);
            employeeEoList.add(employeeEo);
            if (!CollectionUtils.isEmpty((Collection)employeeAddReqDto.getOrgDtoList())) {
                List employeeOrgEos = employeeAddReqDto.getOrgDtoList().stream().map(e -> {
                    EmployeeOrgEo eo = new EmployeeOrgEo();
                    eo.setTenantId(tenantId);
                    eo.setEmployeeId(employeeEo.getId());
                    eo.setOrgGroupId(e.getOrgGroupId() == null ? orgGroupId : e.getOrgGroupId());
                    eo.setOrganizationId(e.getOrgId());
                    eo.setUserId(employeeAddReqDto.getUserId());
                    eo.setExtension("");
                    return eo;
                }).collect(Collectors.toList());
                employeeOrgEoList.addAll(employeeOrgEos);
            }
        });
        this.employeeDas.insertBatch(employeeEoList);
        this.employeeOrgDas.insertBatch(employeeOrgEoList);
    }

    @Override
    public EmployeeRespDto queryByEmployeeNo(String employeeNo) {
        EmployeeEo employeeEo = new EmployeeEo();
        employeeEo.setEmployeeNo(employeeNo);
        EmployeeEo oldEo = (EmployeeEo)this.employeeDas.selectOne((BaseEo)employeeEo);
        EmployeeRespDto employeeRespDto = new EmployeeRespDto();
        DtoHelper.eo2Dto((BaseEo)oldEo, (BaseVo)employeeRespDto);
        return employeeRespDto;
    }

    private void paramCheck(List<EmployeeAddReqDto> addReqDtoList, Long tenantId) {
        Set employeeNoSet = addReqDtoList.stream().filter(dto -> StrUtil.isNotBlank((CharSequence)dto.getEmployeeNo())).map(EmployeeAddReqDto::getEmployeeNo).collect(Collectors.toSet());
        if (employeeNoSet.size() < addReqDtoList.size()) {
            throw new BizException("500", "\u5458\u5de5\u7f16\u53f7\u91cd\u590d\uff01");
        }
        EmployeeEo record = new EmployeeEo();
        record.setTenantId(tenantId);
        record.setSqlFilters(Collections.singletonList(SqlFilter.in((String)"employee_no", employeeNoSet)));
        if (this.employeeDas.count((BaseEo)record) > 0) {
            throw new BizException("500", "\u5458\u5de5\u7f16\u53f7\u5df2\u5b58\u5728!");
        }
    }
}

