/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.enhance.CubeResource;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.user.api.constants.OrgUserConstants;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgPropOptionReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrganizationPropAddReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrganizationPropModifyReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrganizationPropQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgPropOptionRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrganizationPropRespDto;
import com.dtyunxi.yundt.cube.center.user.biz.service.IOrganizationPropService;
import com.dtyunxi.yundt.cube.center.user.conf.param.IOrgModelParam;
import com.dtyunxi.yundt.cube.center.user.dao.das.OrgPropOptionDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.OrganizationPropDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.OrgPropOptionEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.OrganizationPropEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdOrgPropOptionEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class OrganizationPropServiceImpl
implements IOrganizationPropService {
    @Resource
    private OrganizationPropDas organizationPropDas;
    @Resource
    private OrgPropOptionDas orgPropOptionDas;
    @CubeResource
    private IOrgModelParam orgModelParam;

    private Long getTenantId(Long tenantId) {
        return tenantId == null ? ServiceContext.getContext().getRequestTenantId() : tenantId;
    }

    private Long getInstanceId(Long instanceId) {
        return instanceId == null ? ServiceContext.getContext().getRequestInstanceId() : instanceId;
    }

    private boolean queryOrgModel() {
        Boolean orgModel = (Boolean)this.orgModelParam.getValue();
        return orgModel == null || orgModel != false;
    }

    @Override
    @Transactional
    public Long addOrganizationProp(OrganizationPropAddReqDto reqDto) {
        reqDto.setTenantId(this.getTenantId(reqDto.getTenantId()));
        reqDto.setInstanceId(this.getInstanceId(reqDto.getInstanceId()));
        OrganizationPropEo record = new OrganizationPropEo();
        record.setTenantId(reqDto.getTenantId());
        record.setCode(reqDto.getCode());
        if (this.organizationPropDas.count((BaseEo)record) > 0) {
            throw new BizException("500", "\u5c5e\u6027\u7f16\u7801\u5df2\u5b58\u5728");
        }
        OrganizationPropEo organizationPropEo = new OrganizationPropEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)organizationPropEo, (String[])new String[]{"options"});
        organizationPropEo.setExtension("");
        if (this.queryOrgModel()) {
            organizationPropEo.setFuncTypeCode("human_resource");
        }
        this.organizationPropDas.insert((BaseEo)organizationPropEo);
        Long id = organizationPropEo.getId();
        List options = reqDto.getOptions();
        if (!CollectionUtils.isEmpty((Collection)options) && (OrgUserConstants.PROP_EDIT_TYPE_RADIO.equals(reqDto.getEditType()) || OrgUserConstants.PROP_EDIT_TYPE_CHECKED.equals(reqDto.getEditType()))) {
            List optionEos = options.stream().map(optionDto -> {
                OrgPropOptionEo eo = new OrgPropOptionEo();
                CubeBeanUtils.copyProperties((Object)eo, (Object)optionDto, (String[])new String[0]);
                eo.setTenantId(reqDto.getTenantId());
                eo.setInstanceId(reqDto.getInstanceId());
                eo.setPropId(id);
                eo.setExtension("");
                return eo;
            }).collect(Collectors.toList());
            this.orgPropOptionDas.insertBatch(optionEos);
        }
        return id;
    }

    @Override
    @Transactional
    public void modifyOrganizationProp(OrganizationPropModifyReqDto reqDto) {
        reqDto.setTenantId(this.getTenantId(reqDto.getTenantId()));
        reqDto.setInstanceId(this.getInstanceId(reqDto.getInstanceId()));
        Long id = reqDto.getId();
        OrganizationPropEo organizationPropEo = new OrganizationPropEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)organizationPropEo);
        organizationPropEo.setTenantId(organizationPropEo.getTenantId());
        organizationPropEo.setInstanceId(organizationPropEo.getInstanceId());
        organizationPropEo.setCode(null);
        if (this.queryOrgModel()) {
            organizationPropEo.setFuncTypeCode(null);
        }
        this.organizationPropDas.updateSelective((BaseEo)organizationPropEo);
        List options = reqDto.getOptions();
        if (!CollectionUtils.isEmpty((Collection)options)) {
            this.updateOptions(reqDto, options);
        } else {
            OrgPropOptionEo record = new OrgPropOptionEo();
            record.setPropId(id);
            this.orgPropOptionDas.deleteByExample((BaseEo)record);
        }
    }

    private void updateOptions(OrganizationPropModifyReqDto reqDto, List<OrgPropOptionReqDto> options) {
        List<OrgPropOptionReqDto> inserts;
        Long id = reqDto.getId();
        OrgPropOptionEo record = new OrgPropOptionEo();
        record.setPropId(id);
        List orgPropOptionDbs = this.orgPropOptionDas.selectList((BaseEo)record, Integer.valueOf(1), Integer.valueOf(100));
        Map dbValueMap = orgPropOptionDbs.stream().collect(Collectors.toMap(StdOrgPropOptionEo::getValue, Function.identity()));
        Set valueDbs = orgPropOptionDbs.stream().map(StdOrgPropOptionEo::getValue).collect(Collectors.toSet());
        Map<String, List<OrgPropOptionReqDto>> reqOptionMap = options.stream().collect(Collectors.groupingBy(e -> valueDbs.contains(e.getValue()) ? "updates" : "inserts"));
        List<OrgPropOptionReqDto> updates = reqOptionMap.get("updates");
        if (!CollectionUtils.isEmpty(updates)) {
            updates.forEach(req -> {
                OrgPropOptionEo optionDb = (OrgPropOptionEo)dbValueMap.get(req.getValue());
                OrgPropOptionEo eo = new OrgPropOptionEo();
                CubeBeanUtils.copyProperties((Object)eo, (Object)req, (String[])new String[0]);
                eo.setId(optionDb.getId());
                eo.setTenantId(reqDto.getTenantId());
                eo.setInstanceId(reqDto.getInstanceId());
                eo.setPropId(id);
                this.orgPropOptionDas.updateSelective((BaseEo)eo);
            });
        }
        if (!CollectionUtils.isEmpty(inserts = reqOptionMap.get("inserts"))) {
            List optionReqs = inserts.stream().map(optionDto -> {
                OrgPropOptionEo eo = new OrgPropOptionEo();
                CubeBeanUtils.copyProperties((Object)eo, (Object)optionDto, (String[])new String[0]);
                eo.setTenantId(reqDto.getTenantId());
                eo.setInstanceId(reqDto.getInstanceId());
                eo.setPropId(id);
                eo.setExtension("");
                return eo;
            }).collect(Collectors.toList());
            this.orgPropOptionDas.insertBatch(optionReqs);
        }
        Set valueReqs = options.stream().map(OrgPropOptionReqDto::getValue).collect(Collectors.toSet());
        valueDbs.removeAll(valueReqs);
        if (!CollectionUtils.isEmpty(valueDbs)) {
            OrgPropOptionEo eo = new OrgPropOptionEo();
            eo.setPropId(id);
            eo.setSqlFilters(Collections.singletonList(SqlFilter.in((String)"value", valueDbs)));
            this.orgPropOptionDas.deleteByExample((BaseEo)eo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeOrganizationProp(String ids) {
        String[] removeIds;
        for (String idStr : removeIds = ids.split(",")) {
            Long id = Long.valueOf(idStr);
            this.organizationPropDas.logicDeleteById(id);
            OrgPropOptionEo optionEo = new OrgPropOptionEo();
            optionEo.setPropId(id);
            this.orgPropOptionDas.logicDeleteByExample((BaseEo)optionEo);
        }
    }

    @Override
    public OrganizationPropRespDto queryById(Long id) {
        OrganizationPropEo organizationPropEo = (OrganizationPropEo)this.organizationPropDas.selectByPrimaryKey(id);
        if (organizationPropEo == null) {
            return null;
        }
        OrganizationPropRespDto organizationPropRespDto = new OrganizationPropRespDto();
        DtoHelper.eo2Dto((BaseEo)organizationPropEo, (BaseVo)organizationPropRespDto);
        OrgPropOptionEo record = new OrgPropOptionEo();
        record.setPropId(id);
        record.setOrderBy("sort");
        List optionRespList = this.orgPropOptionDas.selectList((BaseEo)record, Integer.valueOf(1), Integer.valueOf(100)).stream().map(e -> {
            OrgPropOptionRespDto dto = new OrgPropOptionRespDto();
            CubeBeanUtils.copyProperties((Object)dto, (Object)e, (String[])new String[0]);
            return dto;
        }).collect(Collectors.toList());
        organizationPropRespDto.setOptions(optionRespList);
        return organizationPropRespDto;
    }

    @Override
    public PageInfo<OrganizationPropRespDto> queryByPage(OrganizationPropQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        String name;
        reqDto.setTenantId(this.getTenantId(reqDto.getTenantId()));
        OrganizationPropEo organizationPropEo = new OrganizationPropEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)organizationPropEo);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        String code = reqDto.getCode();
        if (StringUtils.hasText((String)code)) {
            organizationPropEo.setCode(null);
            sqlFilters.add(SqlFilter.like((String)"code", (Object)("%" + code.trim() + "%")));
        }
        if (StringUtils.hasText((String)(name = reqDto.getName()))) {
            organizationPropEo.setName(null);
            sqlFilters.add(SqlFilter.like((String)"name", (Object)("%" + name.trim() + "%")));
        }
        organizationPropEo.setSqlFilters(sqlFilters);
        organizationPropEo.setOrderByDesc("update_time");
        if (this.queryOrgModel()) {
            organizationPropEo.setFuncTypeCode("human_resource");
        }
        PageInfo eoPageInfo = this.organizationPropDas.selectPage((BaseEo)organizationPropEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, OrganizationPropRespDto.class);
        dtoPageInfo.setList(dtoList);
        if (Boolean.TRUE.equals(reqDto.getWithOption())) {
            dtoList.forEach(dto -> {
                if (OrgUserConstants.PROP_EDIT_TYPE_RADIO.equals(dto.getEditType()) || OrgUserConstants.PROP_EDIT_TYPE_CHECKED.equals(dto.getEditType())) {
                    OrgPropOptionEo propOptionEo = new OrgPropOptionEo();
                    propOptionEo.setPropId(dto.getId());
                    List result = this.orgPropOptionDas.select((BaseEo)propOptionEo, Integer.valueOf(1), Integer.valueOf(100));
                    ArrayList options = new ArrayList(result.size());
                    CubeBeanUtils.copyCollection(options, (Collection)result, OrgPropOptionRespDto.class);
                    dto.setOptions(options);
                }
            });
        }
        return dtoPageInfo;
    }

    @Override
    public List<OrganizationPropRespDto> queryEoByFuncType(List<String> funcTypeCodes, Long tenantId) {
        if (CollectionUtils.isEmpty(funcTypeCodes)) {
            return null;
        }
        funcTypeCodes = funcTypeCodes.stream().filter(StringUtils::hasText).collect(Collectors.toList());
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"func_type_code", (Object)StringUtils.collectionToCommaDelimitedString(funcTypeCodes)));
        OrganizationPropEo queryOrgPropEo = new OrganizationPropEo();
        queryOrgPropEo.setSqlFilters(sqlFilters);
        queryOrgPropEo.setTenantId(tenantId);
        List propEos = this.organizationPropDas.select((BaseEo)queryOrgPropEo, Integer.valueOf(1), Integer.valueOf(3000));
        if (CollectionUtils.isEmpty((Collection)propEos)) {
            return null;
        }
        Set propIdSet = propEos.stream().map(BaseEo::getId).collect(Collectors.toSet());
        List orgPropOptionEos = new ArrayList();
        if (!CollectionUtils.isEmpty(propIdSet)) {
            OrgPropOptionEo queryOrgPropOptionEo = new OrgPropOptionEo();
            queryOrgPropOptionEo.setSqlFilters(Collections.singletonList(SqlFilter.in((String)"prop_id", propIdSet)));
            orgPropOptionEos = this.orgPropOptionDas.select((BaseEo)queryOrgPropOptionEo, Integer.valueOf(1), Integer.valueOf(3000));
        }
        Map<Object, Object> propCode2Options = new HashMap();
        if (!CollectionUtils.isEmpty(orgPropOptionEos)) {
            propCode2Options = orgPropOptionEos.stream().collect(Collectors.groupingBy(StdOrgPropOptionEo::getPropId));
        }
        ArrayList<OrganizationPropRespDto> organizationPropRespDtos = new ArrayList<OrganizationPropRespDto>();
        for (OrganizationPropEo prop : propEos) {
            OrganizationPropRespDto organizationPropRespDto = new OrganizationPropRespDto();
            DtoHelper.eo2Dto((BaseEo)prop, (BaseVo)organizationPropRespDto);
            ArrayList options = new ArrayList();
            if (propCode2Options != null && !CollectionUtils.isEmpty((Collection)((Collection)propCode2Options.get(prop.getId())))) {
                List optionEos = (List)propCode2Options.get(prop.getId());
                DtoHelper.eoList2DtoList((Collection)optionEos, options, OrgPropOptionRespDto.class);
            }
            organizationPropRespDto.setOptions(options);
            organizationPropRespDtos.add(organizationPropRespDto);
        }
        return organizationPropRespDtos;
    }
}

