/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgOrgDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.PostAddReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.PostByOrgReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.PostModifyReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.PostQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgPostResDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.PostRespDto;
import com.dtyunxi.yundt.cube.center.user.biz.service.IEmployeeEventService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IOrgGroupService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IPostEventService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IPostExtService;
import com.dtyunxi.yundt.cube.center.user.dao.das.EmployeePostDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.OrgPostDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.OrganizationDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.PostDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.EmployeePostEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.OrgPostEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.PostEo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class PostExtServiceImpl
implements IPostExtService {
    @Resource
    private PostDas postDas;
    @Resource
    private OrgPostDas orgPostDas;
    @Resource
    private IOrgGroupService orgGroupService;
    @Resource
    private EmployeePostDas employeePostDas;
    @Resource
    private OrganizationDas organizationDas;
    @Resource
    private IEmployeeEventService employeeEventService;
    @Resource
    private IPostEventService postEventService;

    private Long getTenantId(Long tenantId) {
        Long l = tenantId = tenantId == null ? ServiceContext.getContext().getRequestTenantId() : tenantId;
        if (tenantId == null) {
            throw new BizException("500", "\u79df\u6237Id\u4e0d\u80fd\u4e3anull");
        }
        if (tenantId == 0L) {
            throw new BizException("500", "\u79df\u6237Id\u4e0d\u80fd\u4e3a0");
        }
        return tenantId;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addPost(PostAddReqDto reqDto) {
        reqDto.setTenantId(this.getTenantId(reqDto.getTenantId()));
        PostEo record = new PostEo();
        record.setTenantId(reqDto.getTenantId());
        record.setCode(reqDto.getCode());
        if (this.postDas.count((BaseEo)record) > 0) {
            throw new BizException("500", "\u5c97\u4f4d\u7f16\u7801\u5df2\u5b58\u5728");
        }
        final PostEo postEo = new PostEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)postEo);
        this.postDas.insert((BaseEo)postEo);
        List orgDtoList = reqDto.getOrgDtoList();
        if (!CollectionUtils.isEmpty((Collection)orgDtoList)) {
            this.batchInsertOrgPost(reqDto.getTenantId(), orgDtoList, postEo.getId());
        }
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

            public void afterCommit() {
                PostExtServiceImpl.this.postEventService.pushEvent(postEo, null, "ADD");
            }
        });
        return postEo.getId();
    }

    private void batchInsertOrgPost(Long tenantId, List<OrgOrgDto> orgDtoList, Long postId) {
        long existNull = orgDtoList.stream().filter(e -> e.getOrgGroupId() == null).count();
        Long orgGroupIdByTenant = null;
        if (existNull > 0L) {
            orgGroupIdByTenant = this.orgGroupService.queryDefaultHumanOrgGroup(tenantId);
        }
        Long finalOrgGroupIdByTenant = orgGroupIdByTenant;
        List orgPostEos = orgDtoList.stream().map(e -> {
            Long orgGroupId = e.getOrgGroupId();
            orgGroupId = orgGroupId == null ? finalOrgGroupIdByTenant : orgGroupId;
            Long orgId = e.getOrgId();
            if (orgGroupId == null || orgId == null) {
                throw new BizException("500", "\u7ec4\u7ec7Id\u6216\u7ec4\u7ec7\u5355\u5143Id\u4e0d\u80fd\u4e3a\u7a7a:orgGroupId=" + orgGroupId + ",orgId=" + orgId);
            }
            OrgPostEo orgPostEo = new OrgPostEo();
            orgPostEo.setTenantId(tenantId);
            orgPostEo.setPostId(postId);
            orgPostEo.setOrgGroupId(orgGroupId);
            orgPostEo.setOrgId(orgId);
            orgPostEo.setExtension("");
            return orgPostEo;
        }).collect(Collectors.toList());
        this.orgPostDas.insertBatch(orgPostEos);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyPost(final PostModifyReqDto reqDto) {
        reqDto.setTenantId(this.getTenantId(reqDto.getTenantId()));
        final PostEo postEo = new PostEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)postEo);
        postEo.setTenantId(null);
        postEo.setCode(null);
        this.postDas.updateSelective((BaseEo)postEo);
        List orgDtoList = reqDto.getOrgDtoList();
        if (orgDtoList != null) {
            OrgPostEo record = new OrgPostEo();
            record.setTenantId(reqDto.getTenantId());
            record.setPostId(reqDto.getId());
            this.orgPostDas.delete((BaseEo)record);
            if (orgDtoList.size() > 0) {
                this.batchInsertOrgPost(reqDto.getTenantId(), orgDtoList, reqDto.getId());
            }
        }
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

            public void afterCommit() {
                PostExtServiceImpl.this.employeeEventService.updateEmployeePostEvent(reqDto.getId());
                PostEo dbEo = (PostEo)PostExtServiceImpl.this.postDas.selectByPrimaryKey(postEo.getId());
                PostExtServiceImpl.this.postEventService.pushEvent(dbEo, null, "UPDATE");
            }
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void changePostStatus(String ids, Integer status) {
        if (!StringUtils.hasText((String)ids)) {
            throw new BizException("500", "ids\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (status == null || !Arrays.asList(0, 1).contains(status)) {
            throw new BizException("500", "\u72b6\u6001\u53ea\u4e3a\u7981\u75280,\u542f\u75281");
        }
        final ArrayList changePostEos = new ArrayList();
        Arrays.stream(ids.split(",")).forEach(idStr -> {
            PostEo postEo = (PostEo)this.postDas.selectByPrimaryKey(Long.valueOf(ids));
            if (postEo != null) {
                postEo.setStatus(status);
                this.postDas.updateSelective((BaseEo)postEo);
                changePostEos.add(postEo);
            }
        });
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

            public void afterCommit() {
                changePostEos.forEach(postEo -> PostExtServiceImpl.this.postEventService.pushEvent((PostEo)postEo, null, "UPDATE"));
            }
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removePost(String ids) {
        String[] removeIds;
        final ArrayList<PostEo> removePostEos = new ArrayList<PostEo>();
        for (String id : removeIds = ids.split(",")) {
            Long idLong = Long.valueOf(id);
            PostEo postEo = (PostEo)this.postDas.selectByPrimaryKey(idLong);
            this.postDas.logicDeleteById(idLong);
            if (postEo == null) continue;
            removePostEos.add(postEo);
            EmployeePostEo employeePostEo = new EmployeePostEo();
            employeePostEo.setTenantId(postEo.getTenantId());
            employeePostEo.setPostId(postEo.getId());
            this.employeePostDas.logicDelete((BaseEo)employeePostEo);
            OrgPostEo record = new OrgPostEo();
            record.setTenantId(postEo.getTenantId());
            record.setPostId(idLong);
            this.orgPostDas.logicDelete((BaseEo)record);
        }
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

            public void afterCommit() {
                removePostEos.forEach(postEo -> {
                    PostExtServiceImpl.this.employeeEventService.updateEmployeePostEvent(postEo.getId());
                    postEo.setDr(1);
                    PostExtServiceImpl.this.postEventService.pushEvent((PostEo)postEo, null, "DELETE");
                });
            }
        });
    }

    @Override
    public PostRespDto queryById(Long id) {
        PostEo postEo = (PostEo)this.postDas.selectByPrimaryKey(id);
        if (postEo == null) {
            return null;
        }
        Long tenantId = postEo.getTenantId();
        PostRespDto postRespDto = new PostRespDto();
        DtoHelper.eo2Dto((BaseEo)postEo, (BaseVo)postRespDto);
        List orgDtos = this.postDas.selectOrg(tenantId, null, postEo.getId());
        postRespDto.setOrgDtoList(orgDtos);
        return postRespDto;
    }

    @Override
    public PageInfo<PostRespDto> queryByPage(PostQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        reqDto.setTenantId(this.getTenantId(reqDto.getTenantId()));
        if (reqDto.getOrgGroupId() == null) {
            Long orgGroupId = this.orgGroupService.queryDefaultHumanOrgGroup(reqDto.getTenantId());
            if (orgGroupId == null) {
                throw new BizException("500", "orgGroupId\u4e0d\u80fd\u4e3a\u7a7a");
            }
            reqDto.setOrgGroupId(orgGroupId);
        }
        pageNum = pageNum == null ? 1 : pageNum;
        pageSize = pageSize == null ? 10 : pageSize;
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List dtoList = this.postDas.selectOrgGroupPost(reqDto);
        if (Boolean.TRUE.equals(reqDto.getWithOrg())) {
            dtoList.forEach(dto -> {
                String idsStr = dto.getOrgIds();
                if (StringUtils.hasText((String)idsStr)) {
                    List<Long> orgIdList = Arrays.stream(idsStr.split(",")).map(Long::parseLong).collect(Collectors.toList());
                    List<OrgOrgDto> orgPostDtos = this.getOrgOrgDtos((PostRespDto)dto, orgIdList);
                    dto.setOrgDtoList(orgPostDtos);
                }
            });
            dtoList.forEach(dto -> {
                EmployeePostEo employeePostEo = new EmployeePostEo();
                employeePostEo.setTenantId(dto.getTenantId());
                employeePostEo.setPostId(dto.getId());
                dto.setEmployeeCount(Integer.valueOf(this.employeePostDas.count((BaseEo)employeePostEo)));
            });
        }
        if (!CollectionUtils.isEmpty((Collection)dtoList)) {
            List parentIdList = dtoList.stream().filter(c -> !new Long(0L).equals(c.getParentId())).map(PostRespDto::getParentId).collect(Collectors.toList());
            Map<Long, PostEo> parentPostMap = this.postDas.selectByIdList(parentIdList).stream().collect(Collectors.toMap(BaseEo::getId, c -> c));
            dtoList.forEach(c -> {
                PostEo parentEo = (PostEo)parentPostMap.get(c.getParentId());
                if (parentEo != null) {
                    c.setParentCode(parentEo.getCode());
                    c.setParentName(parentEo.getName());
                }
            });
        }
        return new PageInfo(dtoList);
    }

    private List<OrgOrgDto> getOrgOrgDtos(PostRespDto dto, List<Long> orgIdList) {
        List organizationEo = this.organizationDas.selectByIds(orgIdList);
        Long orgGroupId = dto.getOrgGroupId();
        List<OrgOrgDto> orgPostDtos = organizationEo.stream().map(e -> {
            OrgOrgDto orgOrgDto = new OrgOrgDto();
            orgOrgDto.setOrgGroupId(orgGroupId);
            orgOrgDto.setOrgId(e.getId());
            orgOrgDto.setOrgName(e.getName());
            return orgOrgDto;
        }).collect(Collectors.toList());
        return orgPostDtos;
    }

    @Override
    public List<OrgPostResDto> filterByOrg(PostByOrgReqDto reqDto) {
        Long tenantId = this.getTenantId(reqDto.getTenantId());
        Long orgGroupIdByTenant = this.orgGroupService.queryDefaultHumanOrgGroup(tenantId);
        if (orgGroupIdByTenant == null) {
            throw new BizException("500", "orgGroupId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List orgDtos = reqDto.getOrgDtos();
        if (CollectionUtils.isEmpty((Collection)orgDtos)) {
            throw new BizException("500", "\u7ec4\u7ec7\u5355\u5143\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return orgDtos.stream().map(e -> {
            Long orgGroupId = e.getOrgGroupId() == null ? orgGroupIdByTenant : e.getOrgGroupId();
            List posts = this.postDas.selectByOrg(tenantId, orgGroupId, e.getOrgId());
            ArrayList postRespDtos = new ArrayList();
            CubeBeanUtils.copyCollection(postRespDtos, (Collection)posts, PostRespDto.class);
            OrgPostResDto orgPostResDto = new OrgPostResDto();
            orgPostResDto.setOrgGroupId(orgGroupId);
            orgPostResDto.setOrgId(e.getOrgId());
            orgPostResDto.setOrgName(e.getOrgName());
            orgPostResDto.setPosts(postRespDtos);
            return orgPostResDto;
        }).collect(Collectors.toList());
    }
}

