/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.commons.MyMapUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.bundle.org.center.user.api.dto.base.BatchDto;
import com.dtyunxi.yundt.cube.bundle.org.center.user.api.dto.base.PostBaseDto;
import com.dtyunxi.yundt.cube.bundle.org.center.user.api.dto.request.PostQueryReqDto;
import com.dtyunxi.yundt.cube.bundle.org.center.user.api.dto.request.PostReqDto;
import com.dtyunxi.yundt.cube.bundle.org.center.user.api.dto.response.PostPagerRespDto;
import com.dtyunxi.yundt.cube.center.user.api.exception.BundleExceptionCode;
import com.dtyunxi.yundt.cube.center.user.api.interfaces.IPostOrgInfo;
import com.dtyunxi.yundt.cube.center.user.biz.service.IPostService;
import com.dtyunxi.yundt.cube.center.user.biz.utils.SqlFilterBuilder;
import com.dtyunxi.yundt.cube.center.user.dao.das.EmployeeDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.EmployeeOrgDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.EmployeePostDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.OrganizationDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.PostDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.EmployeeOrgEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.EmployeePostEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.OrganizationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.PostEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdEmployeeOrgEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdEmployeePostEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdPostEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PostServiceImpl
implements IPostService {
    @Resource
    private PostDas postDas;
    @Resource
    private OrganizationDas organizationDas;
    @Resource
    private EmployeePostDas rEmployeePostDas;
    @Resource
    private EmployeeDas employeeDas;
    @Resource
    private EmployeeOrgDas employeeOrganizationRelationDas;

    @Override
    public Long add(PostReqDto addReqDto) {
        this.verify(addReqDto);
        PostEo postEo = new PostEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)postEo);
        if (postEo.getStatus() == null) {
            postEo.setStatus(Integer.valueOf(1));
        }
        this.postDas.insert((BaseEo)postEo);
        return postEo.getId();
    }

    private void verify(PostReqDto postReqDto) {
        if (StringUtils.isEmpty((CharSequence)postReqDto.getOrgCode())) {
            throw new BizException(BundleExceptionCode.POST_NOT_BIND_ORG.getMsg());
        }
        PostEo ex = new PostEo();
        ex.setCode(postReqDto.getCode());
        PostEo one = (PostEo)this.postDas.selectOne((BaseEo)ex);
        if (null != one) {
            if (one.getId().equals(postReqDto.getId())) {
                if (!one.getCode().equals(postReqDto.getCode())) {
                    throw new BizException(BundleExceptionCode.POST_CODE_CAN_NOT_MODIFY.getMsg());
                }
            } else {
                throw new BizException(BundleExceptionCode.POST_CODE_EXISTED.getMsg());
            }
        }
        OrganizationEo selectParam = new OrganizationEo();
        selectParam.setCode(postReqDto.getOrgCode());
        OrganizationEo organizationEo = (OrganizationEo)this.organizationDas.selectOne((BaseEo)selectParam);
        if (organizationEo == null) {
            throw new BizException(BundleExceptionCode.ORG_NOT_EXIST.getMsg());
        }
        if (one != null && !one.getOrgCode().equals(postReqDto.getOrgCode())) {
            EmployeePostEo rEmployeePostSelectParam = new EmployeePostEo();
            rEmployeePostSelectParam.setPostCode(postReqDto.getCode());
            List rEmployeePostEos = this.rEmployeePostDas.select((BaseEo)rEmployeePostSelectParam);
            if (CollectionUtils.isNotEmpty((Collection)rEmployeePostEos)) {
                EmployeeOrgEo employeeSelectParam = new EmployeeOrgEo();
                employeeSelectParam.setOrganizationId(organizationEo.getId());
                List employeeOrganizationRelationEos = this.employeeOrganizationRelationDas.select((BaseEo)employeeSelectParam);
                if (CollectionUtils.isEmpty((Collection)employeeOrganizationRelationEos)) {
                    throw new BizException(BundleExceptionCode.CAN_NOT_CHANGE_ORG.getMsg());
                }
                Map<Long, Long> orgEmployeeMap = employeeOrganizationRelationEos.stream().collect(Collectors.toMap(StdEmployeeOrgEo::getEmployeeId, StdEmployeeOrgEo::getEmployeeId, (e1, e2) -> e2));
                if (rEmployeePostEos.stream().allMatch(rEmployeePostEo -> orgEmployeeMap.containsKey(rEmployeePostEo.getId()))) {
                    throw new BizException(BundleExceptionCode.CAN_NOT_CHANGE_ORG.getMsg());
                }
            }
        }
    }

    @Override
    public void modify(PostReqDto modifyReqDto) {
        this.verify(modifyReqDto);
        PostEo postEo = new PostEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)postEo);
        this.postDas.updateSelective((BaseEo)postEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void remove(String ids, Long instanceId) {
        String[] removeIds = ids.split(",");
        this.verifyBeforeRemove(removeIds);
        for (String id : removeIds) {
            this.postDas.logicDeleteById(Long.valueOf(id));
        }
    }

    private void verifyBeforeRemove(String[] removeIds) {
        PostEo selectParam = new PostEo();
        selectParam.setSqlFilters(SqlFilterBuilder.newInstance().buildInSqlFilter("id", Arrays.asList(removeIds)).get());
        List postEos = this.postDas.select((BaseEo)selectParam);
        if (CollectionUtils.isNotEmpty((Collection)postEos)) {
            EmployeePostEo rEmployeePostSelectParam = new EmployeePostEo();
            rEmployeePostSelectParam.setSqlFilters(SqlFilterBuilder.newInstance().buildInSqlFilter("post_code", postEos.stream().map(StdPostEo::getCode).collect(Collectors.toList())).get());
            if (this.rEmployeePostDas.selectOne((BaseEo)rEmployeePostSelectParam) != null) {
                throw new BizException(BundleExceptionCode.POST_CAN_NOT_REMOVE_AS_EXISTS_EMPLOYEE.getMsg());
            }
        }
    }

    @Override
    public PostReqDto queryById(Long id) {
        PostEo postEo = (PostEo)this.postDas.selectByPrimaryKey(id);
        PostReqDto postReqDto = new PostReqDto();
        DtoHelper.eo2Dto((BaseEo)postEo, (BaseVo)postReqDto);
        return postReqDto;
    }

    private String fuzzyProperty(String property) {
        return "%" + property + "%";
    }

    @Override
    public PageInfo<PostPagerRespDto> queryByPage(PostQueryReqDto postQueryReqDto, Integer pageNum, Integer pageSize) {
        PostEo selectParam = new PostEo();
        selectParam.setStatus(postQueryReqDto.getStatus());
        List<SqlFilter> sqlFilterList = SqlFilterBuilder.newInstance().get();
        if (StringUtils.isNotEmpty((CharSequence)postQueryReqDto.getCode())) {
            sqlFilterList.add(SqlFilter.like((String)"code", (Object)this.fuzzyProperty(postQueryReqDto.getCode())));
        }
        if (StringUtils.isNotEmpty((CharSequence)postQueryReqDto.getName())) {
            sqlFilterList.add(SqlFilter.like((String)"name", (Object)this.fuzzyProperty(postQueryReqDto.getName())));
        }
        if (StringUtils.isNotEmpty((CharSequence)postQueryReqDto.getOrgCode())) {
            sqlFilterList.add(SqlFilter.like((String)"orgCode", (Object)this.fuzzyProperty(postQueryReqDto.getOrgCode())));
        }
        selectParam.setSqlFilters(sqlFilterList);
        selectParam.setOrderByDesc("create_time");
        PageInfo eoPageInfo = this.postDas.selectPage((BaseEo)selectParam, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        if (eoPageInfo == null || CollectionUtils.isEmpty((Collection)eoPageInfo.getList())) {
            return dtoPageInfo;
        }
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List dtoList = this.assemblePostInfo(eoPageInfo.getList());
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List assemblePostInfo(List<PostEo> list) {
        HashMap postCode2DtoMap = Maps.newHashMap();
        HashMap orgCode2DtoMap = Maps.newHashMap();
        List dtoList = list.stream().map(postEo -> {
            PostPagerRespDto postPagerRespDto = new PostPagerRespDto();
            DtoHelper.eo2Dto((BaseEo)postEo, (BaseVo)postPagerRespDto);
            MyMapUtils.appendElement2ListMap((Map)postCode2DtoMap, (Object)postEo.getCode(), (Object)postPagerRespDto);
            MyMapUtils.appendElement2ListMap((Map)orgCode2DtoMap, (Object)postEo.getOrgCode(), (Object)postPagerRespDto);
            return postPagerRespDto;
        }).collect(Collectors.toList());
        this.bindEmployeeCount(postCode2DtoMap);
        this.bindOrgInfo(orgCode2DtoMap);
        return dtoList;
    }

    @Override
    public void bindOrgInfo(Map<String, List<IPostOrgInfo>> orgCode2DtoMap) {
        OrganizationEo organizationSelectParam = new OrganizationEo();
        organizationSelectParam.setSqlFilters(SqlFilterBuilder.newInstance().buildInSqlFilter("code", orgCode2DtoMap.keySet()).get());
        List organizationEoList = this.organizationDas.select((BaseEo)organizationSelectParam);
        if (CollectionUtils.isNotEmpty((Collection)organizationEoList)) {
            organizationEoList.forEach(organizationEo -> {
                List postOrgInfos = (List)orgCode2DtoMap.get(organizationEo.getCode());
                if (CollectionUtils.isNotEmpty((Collection)postOrgInfos)) {
                    postOrgInfos.forEach(postOrgInfo -> postOrgInfo.setOrgName(organizationEo.getName()));
                }
            });
        }
    }

    private void bindEmployeeCount(Map<String, List<PostPagerRespDto>> postCode2DtoMap) {
        EmployeePostEo rEmployeePostSelectParam = new EmployeePostEo();
        rEmployeePostSelectParam.setSqlFilters(SqlFilterBuilder.newInstance().buildInSqlFilter("post_code", postCode2DtoMap.keySet()).get());
        List rEmployeePostEoList = this.rEmployeePostDas.select((BaseEo)rEmployeePostSelectParam);
        if (CollectionUtils.isNotEmpty((Collection)rEmployeePostEoList)) {
            rEmployeePostEoList.stream().collect(Collectors.groupingBy(StdEmployeePostEo::getPostCode, Collectors.counting())).forEach((postCode, empCount) -> {
                List postPagerResps = (List)postCode2DtoMap.get(postCode);
                if (CollectionUtils.isNotEmpty((Collection)postPagerResps)) {
                    postPagerResps.forEach(postPagerRespDto -> postPagerRespDto.setEmployeeCount(Integer.valueOf(empCount.intValue())));
                }
            });
        }
    }

    @Override
    public void enable(Long id) {
        this.update(Lists.newArrayList((Object[])new Long[]{id}), 1);
    }

    private void update(List<Long> ids, Integer status) {
        PostEo postEo = new PostEo();
        postEo.setStatus(status);
        LinkedList<SqlFilter> sqlFilters = new LinkedList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"id", ids));
        postEo.setSqlFilters(sqlFilters);
        this.postDas.updateSelectiveSqlFilter((BaseEo)postEo);
    }

    @Override
    public void disable(Long id) {
        this.update(Lists.newArrayList((Object[])new Long[]{id}), 0);
    }

    @Override
    public void batchEnable(BatchDto batchDto) {
        this.update(batchDto.getIds(), 1);
    }

    @Override
    public void batchDisable(BatchDto batchDto) {
        this.update(batchDto.getIds(), 0);
    }

    @Override
    public List<PostBaseDto> comboBox(List<String> orgCodes) {
        PostEo selectParam = new PostEo();
        selectParam.setSqlFilters(SqlFilterBuilder.newInstance().buildInSqlFilter("org_code", orgCodes).get());
        List list = this.postDas.select((BaseEo)selectParam);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        return list.stream().map(postEo -> {
            PostBaseDto postBaseDto = new PostBaseDto();
            DtoHelper.eo2Dto((BaseEo)postEo, (BaseVo)postBaseDto);
            return postBaseDto;
        }).collect(Collectors.toList());
    }
}

