/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.utils;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DataLimitCacheUtil {
    private Logger logger = LoggerFactory.getLogger(DataLimitCacheUtil.class);
    @Resource
    private ICacheService cacheService;

    public void cleanDataLimitOrgCache() {
        String userId = ServiceContext.getContext().getRequestUserIdString();
        String requestId = ServiceContext.getContext().getRequestId();
        this.logger.debug("clear data limit cache userId:{} requestId:{}", (Object)userId, (Object)requestId);
        if (StringUtils.isEmpty((CharSequence)requestId)) {
            this.logger.warn("requestId is null, can not clear data limit cache");
        }
        this.cacheService.delCacheByPattern(null, this.getRuleCacheKeyPrefix(userId, requestId));
    }

    private String getRuleCacheKeyPrefix(String userId, String requestId) {
        StringBuilder ruleCacheKey = new StringBuilder("DataLimitRule:");
        ruleCacheKey.append(requestId).append(":").append(userId).append(":*");
        return ruleCacheKey.toString();
    }
}

