/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgOrgDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.PostDto;
import com.dtyunxi.yundt.cube.center.user.biz.mq.event.EmployeeEventPublisher;
import com.dtyunxi.yundt.cube.center.user.biz.service.IEmployeeEventService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IOrganizationExtService;
import com.dtyunxi.yundt.cube.center.user.dao.das.EmployeeDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.EmployeePostDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.EmployeeEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.EmployeePostEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdEmployeePostEo;
import com.dtyunxi.yundt.cube.center.user.event.EmployeeEventDto;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class EmployeeEventServiceImpl
implements IEmployeeEventService {
    private static Logger logger = LoggerFactory.getLogger(EmployeeEventServiceImpl.class);
    @Resource
    private EmployeeEventPublisher employeeEventPublisher;
    @Resource
    private EmployeeDas employeeDas;
    @Resource
    private IOrganizationExtService organizationExtService;
    @Resource
    private EmployeePostDas employeePostDas;

    @Override
    public void addEvent(EmployeeEo employeeEo) {
        this.pushEvent(employeeEo, "ADD");
    }

    private void pushEvent(EmployeeEo employeeEo, String opType) {
        List postDots;
        if (employeeEo == null) {
            return;
        }
        EmployeeEventDto employeeEventDto = new EmployeeEventDto();
        CubeBeanUtils.copyProperties((Object)employeeEventDto, (Object)employeeEo, (String[])new String[0]);
        List orgOrgDots = this.employeeDas.selectOrg(employeeEo.getTenantId(), null, employeeEo.getId());
        if (CollectionUtil.isNotEmpty((Collection)orgOrgDots)) {
            List orgIds = orgOrgDots.stream().filter(dto -> this.organizationExtService.isHumanResourceOrg(dto.getOrgId())).map(OrgOrgDto::getOrgId).collect(Collectors.toList());
            employeeEventDto.setOrgIds(orgIds);
        }
        if (CollectionUtil.isNotEmpty((Collection)(postDots = this.employeeDas.selectPost(employeeEo.getTenantId(), null, employeeEo.getId())))) {
            List postNames = postDots.stream().map(PostDto::getPostName).collect(Collectors.toList());
            employeeEventDto.setPostNames(postNames);
        }
        employeeEventDto.setOpType(opType);
        this.employeeEventPublisher.pushEvent(employeeEventDto);
    }

    @Override
    public void updateEvent(EmployeeEo employeeEo) {
        EmployeeEo dbEmployeeEo = (EmployeeEo)this.employeeDas.selectByPrimaryKey(employeeEo.getId());
        this.pushEvent(dbEmployeeEo, "UPDATE");
    }

    @Override
    public void deleteEvent(EmployeeEo employeeEo) {
        if (employeeEo == null) {
            return;
        }
        EmployeeEventDto employeeEventDto = new EmployeeEventDto();
        CubeBeanUtils.copyProperties((Object)employeeEventDto, (Object)employeeEo, (String[])new String[0]);
        employeeEventDto.setEmployIds(Collections.singletonList(employeeEo.getId()));
        employeeEventDto.setOpType("DELETE");
        this.employeeEventPublisher.pushEvent(employeeEventDto);
    }

    @Override
    public void deleteEvent(List<Long> employIds) {
        if (CollectionUtil.isEmpty(employIds)) {
            return;
        }
        EmployeeEventDto employeeEventDto = new EmployeeEventDto();
        employeeEventDto.setEmployIds(employIds);
        employeeEventDto.setOpType("DELETE");
        this.employeeEventPublisher.pushEvent(employeeEventDto);
    }

    @Override
    public void updateEmployeePostEvent(Long postId) {
        EmployeePostEo employeePostEo = new EmployeePostEo();
        employeePostEo.setPostId(postId);
        List employeePostEoList = this.employeePostDas.select((BaseEo)employeePostEo, Integer.valueOf(1), Integer.valueOf(1000));
        if (CollectionUtil.isEmpty((Collection)employeePostEoList)) {
            logger.info("\u5c97\u4f4d\u672a\u5173\u8054\u5458\u5de5\uff0c\u5c97\u4f4did\u4e3a{}", (Object)postId);
            return;
        }
        List employeeIds = employeePostEoList.parallelStream().map(StdEmployeePostEo::getEmployeeId).collect(Collectors.toList());
        EmployeeEventDto employeeEventDto = new EmployeeEventDto();
        employeeEventDto.setEmployIds(employeeIds);
        employeeEventDto.setOpType("POST_UPDATE");
        this.employeeEventPublisher.pushEvent(employeeEventDto);
    }

    @Override
    public void updateEmployeeStatusEvent(List<Long> employIds, Integer status) {
        if (CollectionUtil.isEmpty(employIds)) {
            return;
        }
        EmployeeEventDto employeeEventDto = new EmployeeEventDto();
        employeeEventDto.setEmployIds(employIds);
        employeeEventDto.setStatus(status);
        employeeEventDto.setOpType("STATUS_UPDATE");
        this.employeeEventPublisher.pushEvent(employeeEventDto);
    }
}

