/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeThirdReqDto;
import com.dtyunxi.yundt.cube.center.user.biz.service.IEmployeeThirdService;
import com.dtyunxi.yundt.cube.center.user.dao.das.EmployeeThirdDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.EmployeeThirdEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdEmployeeThirdEo;
import com.dtyunxi.yundt.cube.center.user.dao.mapper.EmployeeThirdMapper;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class EmployeeThirdServiceImpl
implements IEmployeeThirdService {
    @Resource
    private EmployeeThirdDas employeeThirdDas;
    @Resource
    private EmployeeThirdMapper employeeThirdMapper;

    @Override
    public Long addUserThird(EmployeeThirdReqDto addReqDto) {
        Assert.hasText((String)addReqDto.getThirdEmployeeId(), (String)"\u7b2c\u4e09\u65b9\u5458\u5de5id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.paramCheck(addReqDto.getEmployeeId(), addReqDto.getType());
        EmployeeThirdEo employeeThirdEo = new EmployeeThirdEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)employeeThirdEo);
        this.employeeThirdDas.insert((BaseEo)employeeThirdEo);
        return employeeThirdEo.getId();
    }

    @Override
    public void removeUserThird(Long employeeId, Integer type) {
        this.paramCheck(employeeId, type);
        EmployeeThirdEo employeeThirdEo = new EmployeeThirdEo();
        employeeThirdEo.setEmployeeId(employeeId);
        employeeThirdEo.setType(type);
        this.employeeThirdDas.delete((BaseEo)employeeThirdEo);
    }

    private void paramCheck(Long employeeId, Integer type) {
        Assert.notNull((Object)employeeId, (String)"\u5458\u5de5id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)type, (String)"\u7b2c\u4e09\u65b9\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
    }

    @Override
    public EmployeeThirdReqDto queryById(Long employeeId, Integer type) {
        this.paramCheck(employeeId, type);
        EmployeeThirdEo employeeThirdEo = new EmployeeThirdEo();
        employeeThirdEo.setEmployeeId(employeeId);
        employeeThirdEo.setType(type);
        List dbEoList = this.employeeThirdDas.selectList((BaseEo)employeeThirdEo, Integer.valueOf(1), Integer.valueOf(1));
        if (CollectionUtil.isEmpty((Collection)dbEoList)) {
            return null;
        }
        EmployeeThirdEo dbEo = (EmployeeThirdEo)dbEoList.get(0);
        EmployeeThirdReqDto dto = new EmployeeThirdReqDto();
        DtoHelper.eo2Dto((BaseEo)dbEo, (BaseVo)dto);
        return dto;
    }

    @Override
    public List<EmployeeThirdEo> queryByIdList(List<Long> employeeIds, Integer type) {
        if (CollectionUtil.isEmpty(employeeIds)) {
            return null;
        }
        EmployeeThirdEo employeeThirdEo = this.getEmployeeThirdEo(employeeIds, type);
        return this.employeeThirdDas.select((BaseEo)employeeThirdEo);
    }

    private EmployeeThirdEo getEmployeeThirdEo(List<Long> employeeIds, Integer type) {
        EmployeeThirdEo employeeThirdEo = new EmployeeThirdEo();
        employeeThirdEo.setType(type);
        LinkedList<SqlFilter> sqlFilters = new LinkedList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"employee_id", employeeIds));
        employeeThirdEo.setSqlFilters(sqlFilters);
        return employeeThirdEo;
    }

    private EmployeeThirdEo getByThirdEmployeeIds(List<String> thirdEmployeeIds, Integer type) {
        EmployeeThirdEo employeeThirdEo = new EmployeeThirdEo();
        employeeThirdEo.setType(type);
        LinkedList<SqlFilter> sqlFilters = new LinkedList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"third_employee_id", thirdEmployeeIds));
        employeeThirdEo.setSqlFilters(sqlFilters);
        return employeeThirdEo;
    }

    @Override
    public void deleteByIdList(List<Long> employeeIds, Integer type) {
        if (CollectionUtil.isEmpty(employeeIds)) {
            return;
        }
        EmployeeThirdEo employeeThirdEo = this.getEmployeeThirdEo(employeeIds, type);
        this.employeeThirdDas.delete((BaseEo)employeeThirdEo);
    }

    @Override
    public void deleteByThirdEmployeeIdList(List<String> thirdEmployeeIds, Integer type) {
        if (CollectionUtil.isEmpty(thirdEmployeeIds)) {
            return;
        }
        EmployeeThirdEo employeeThirdEo = this.getByThirdEmployeeIds(thirdEmployeeIds, type);
        this.employeeThirdDas.delete((BaseEo)employeeThirdEo);
    }

    @Override
    public List<EmployeeThirdEo> queryNotInIdList(List<Long> employeeIds, Integer type) {
        if (CollectionUtil.isEmpty(employeeIds)) {
            return null;
        }
        return this.employeeThirdDas.queryNotInIdList(employeeIds, type);
    }

    @Override
    public List<EmployeeThirdEo> queryByThirdIdList(List<String> thirdEmployeeIds, Integer type) {
        if (CollectionUtil.isEmpty(thirdEmployeeIds)) {
            return null;
        }
        Wrapper queryWrapper = (Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().in(StdEmployeeThirdEo::getThirdEmployeeId, thirdEmployeeIds)).eq(StdEmployeeThirdEo::getType, (Object)type);
        return this.employeeThirdMapper.selectList(queryWrapper);
    }
}

