/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.enhance.CubeResource;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.tree.TreeBuilder;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.bundle.org.center.user.api.constant.SubjectTypeEnum;
import com.dtyunxi.yundt.cube.center.user.api.constants.OrgUserConstants;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvAddReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvEnableReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvInfoReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvModifyReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvPropReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvTreeReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgInfoAdvReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.VirtualRelateBusinessReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvDetailRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvInfoRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvOpRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvPropRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvTreeRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgEntityPropertyRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgFuncTypeRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgInfoAdvRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgPropOptionRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrganizationPropRespDto;
import com.dtyunxi.yundt.cube.center.user.api.enums.OrgTypeEnum;
import com.dtyunxi.yundt.cube.center.user.biz.service.IOrgGroupService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IOrganizationEventService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IOrganizationExtService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IOrganizationPropService;
import com.dtyunxi.yundt.cube.center.user.biz.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.biz.utils.DataLimitCacheUtil;
import com.dtyunxi.yundt.cube.center.user.biz.vo.OrgValidCompanyVo;
import com.dtyunxi.yundt.cube.center.user.biz.vo.SyncEmployeeVo;
import com.dtyunxi.yundt.cube.center.user.biz.vo.SyncOrgAndEmployeeReqVo;
import com.dtyunxi.yundt.cube.center.user.biz.vo.SyncOrgAndEmployeeVo;
import com.dtyunxi.yundt.cube.center.user.biz.vo.SyncOrgVo;
import com.dtyunxi.yundt.cube.center.user.conf.param.IOrgEntityPropertyParam;
import com.dtyunxi.yundt.cube.center.user.conf.param.IOrgFuncTypeParam;
import com.dtyunxi.yundt.cube.center.user.conf.param.IOrgModelParam;
import com.dtyunxi.yundt.cube.center.user.dao.das.EmployeeDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.EmployeeOrgDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.EmployeePostDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.OrgFuncTypeRelationDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.OrgGroupDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.OrgOrgDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.OrgPostDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.OrgPropValueDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.OrganizationDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.OrganizationInfoDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.PostDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.EmployeeEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.EmployeeOrgEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.EmployeePostEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.OrgFuncTypeRelationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.OrgGroupEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.OrgOrgEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.OrgPostEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.OrgPropValueEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.OrganizationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.OrganizationInfoEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.PostEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdEmployeeEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdEmployeeOrgEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdEmployeePostEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdOrgFuncTypeRelationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdOrgPostEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdOrgPropValueEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdOrganizationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdOrganizationInfoEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdPostEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

@Service
public class OrganizationExtServiceImpl
implements IOrganizationExtService {
    private static final Logger logger = LoggerFactory.getLogger(OrganizationExtServiceImpl.class);
    @Resource
    private OrganizationDas organizationDas;
    @Resource
    private OrgFuncTypeRelationDas orgFuncTypeRelationDas;
    @Resource
    private OrgPropValueDas orgPropValueDas;
    @Resource
    private IOrganizationEventService organizationEventService;
    @Resource
    private OrganizationInfoDas organizationInfoDas;
    @Resource
    private IOrganizationPropService organizationPropService;
    @Resource
    private OrgOrgDas orgOrgDas;
    @Resource
    private OrgGroupDas orgGroupDas;
    @Resource
    private EmployeeOrgDas employeeOrgDas;
    @Resource
    private OrgPostDas orgPostDas;
    @Resource
    private PostDas postDas;
    @Resource
    private EmployeePostDas employeePostDas;
    @Resource
    private EmployeeDas employeeDas;
    @CubeResource
    private IOrgEntityPropertyParam orgEntityPropertyParam;
    @CubeResource
    private IOrgFuncTypeParam orgFuncTypeParam;
    @CubeResource
    private IOrgModelParam orgModelParam;
    @Resource
    private IOrgGroupService orgGroupService;
    @Resource
    private DataLimitCacheUtil dataLimitCacheUtil;
    private static final String UP = "UP";
    private static final String DOWN = "DOWN";
    private static final String COMPANY_CODE_UNIQUE = "code";
    private static final String COMPANY_NAME_UNIQUE = "name";
    private static final String COMPANY_CODE_NAME_UNIQUE = "code&name";

    private Long getTenantId(Long tenantId) {
        return tenantId == null ? ServiceContext.getContext().getRequestTenantId() : tenantId;
    }

    private Long getInstanceId(Long instanceId) {
        return instanceId == null ? ServiceContext.getContext().getRequestInstanceId() : instanceId;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public OrgAdvOpRespDto addOrgAdv(OrgAdvAddReqDto orgAdvAddReqDto) {
        Long tenantId = this.getTenantId(orgAdvAddReqDto.getTenantId());
        Long instanceId = this.getInstanceId(orgAdvAddReqDto.getInstanceId());
        String orgCode = orgAdvAddReqDto.getCode();
        OrganizationEo queryEo = this.organizationDas.queryByCode(orgCode, tenantId);
        AssertUtil.isTrue((queryEo == null ? 1 : 0) != 0, (String)"\u7ec4\u7ec7\u5355\u5143\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u91cd\u8f93");
        OrgAdvOpRespDto resultDto = this.validCompanyCodeAndNameUNIQUE(orgAdvAddReqDto.getUpdateOrgCompanyMsg(), orgAdvAddReqDto.getCompanyOrgCode(), orgAdvAddReqDto.getCompanyOrgName(), tenantId);
        if (resultDto.getResultCode() == 1) {
            OrgGroupEo parent;
            final OrganizationEo organizationEo = new OrganizationEo();
            DtoHelper.dto2Eo((BaseVo)orgAdvAddReqDto, (BaseEo)organizationEo);
            AssertUtil.isTrue((boolean)Arrays.asList("2", "3").contains(orgAdvAddReqDto.getType()), (String)"500", (String)"\u4e0d\u5728\u53ef\u64cd\u4f5c\u7684\u7684\u7c7b\u578b\u8303\u56f4\u5185:[type=%s]", (Object[])new Object[]{orgAdvAddReqDto.getType()});
            Long parentId = orgAdvAddReqDto.getParentId();
            if (parentId == null) {
                parentId = OrgUserConstants.ORG_ROOT_ID;
            } else if (parentId.equals(orgAdvAddReqDto.getOrgGroupId())) {
                parent = (OrgGroupEo)this.orgGroupDas.selectByPrimaryKey(parentId);
                if (parent == null) {
                    throw new BizException("\u7236\u7ea7\u7ec4\u7ec7[parentId=" + parentId + "]\u4e0d\u5b58\u5728");
                }
            } else if (!OrgUserConstants.ORG_ROOT_ID.equals(parentId) && (parent = (OrganizationEo)this.organizationDas.selectByPrimaryKey(parentId)) == null) {
                throw new BizException("\u7236\u7ea7\u7ec4\u7ec7\u5355\u5143[parentId=" + parentId + "]\u4e0d\u5b58\u5728");
            }
            organizationEo.setParentId(parentId);
            organizationEo.setTenantId(tenantId);
            organizationEo.setInstanceId(instanceId);
            if (StringUtils.isBlank((CharSequence)organizationEo.getExtension())) {
                organizationEo.setExtension("");
            }
            this.organizationDas.insert((BaseEo)organizationEo);
            Long id = organizationEo.getId();
            resultDto.setOrgId(id);
            if ("2".equals(orgAdvAddReqDto.getType())) {
                this.processOrgFuncTypeRelation(id, orgAdvAddReqDto.getFuncTypeCodes(), tenantId);
                this.processOrgPropValue(id, orgAdvAddReqDto.getOrgAdvPropReqDtos(), tenantId);
            } else if ("3".equals(orgAdvAddReqDto.getType())) {
                Long orgGroupId = orgAdvAddReqDto.getOrgGroupId();
                if (orgGroupId == null) {
                    throw new BizException("500", "\u65b0\u589e\u865a\u62df\u5355\u5143\u65f6,\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a");
                }
                OrgOrgEo orgOrgEo = new OrgOrgEo();
                orgOrgEo.setOrgGroupId(orgGroupId);
                orgOrgEo.setParentOrgId(parentId);
                orgOrgEo.setOrgId(id);
                orgOrgEo.setExtension("");
                this.orgOrgDas.insert((BaseEo)orgOrgEo);
            }
            if ("company".equals(orgAdvAddReqDto.getEntityPropCode())) {
                Long aLong = this.addOrgAdvInfo(orgAdvAddReqDto.getOrgAdvInfoReqDto(), organizationEo.getCode(), organizationEo.getName());
                resultDto.setOrgInfoId(aLong);
            }
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                public void afterCommit() {
                    try {
                        OrganizationExtServiceImpl.this.organizationEventService.pushEvent(organizationEo, null, "ADD");
                    }
                    catch (Exception e) {
                        logger.info("\u65b0\u589e\u7ec4\u7ec7\u4fe1\u606f\u53d1\u9001\u9886\u57df\u4e8b\u4ef6\u5931\u8d25!\u7ec4\u7ec7\u7f16\u7801: {},\u9519\u8bef\u4fe1\u606f: {}", (Object)organizationEo.getCode(), (Object)e.getMessage());
                    }
                }
            });
            this.dataLimitCacheUtil.cleanDataLimitOrgCache();
        }
        return resultDto;
    }

    private Long addOrgAdvInfo(OrgAdvInfoReqDto orgAdvInfoReqDto, String orgCode, String orgName) {
        if (orgAdvInfoReqDto == null) {
            throw new BizException("500", "\u65b0\u589e\u516c\u53f8\u7ec4\u7ec7\u5355\u5143\u65f6,\u516c\u53f8\u76f8\u5173\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!SubjectTypeEnum.ZOOID.getType().equals(orgAdvInfoReqDto.getSubjectType()) && StringUtils.isBlank((CharSequence)orgAdvInfoReqDto.getCreditCode())) {
            throw new BizException("500", "\u65b0\u589e\u516c\u53f8\u7ec4\u7ec7\u5355\u5143\u65f6,\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)orgAdvInfoReqDto.getLegalName())) {
            throw new BizException("500", "\u65b0\u589e\u516c\u53f8\u7ec4\u7ec7\u5355\u5143\u65f6,\u6cd5\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OrganizationInfoEo organizationInfoEo = new OrganizationInfoEo();
        DtoHelper.dto2Eo((BaseVo)orgAdvInfoReqDto, (BaseEo)organizationInfoEo);
        organizationInfoEo.setOrgCode(orgCode);
        organizationInfoEo.setOrgName(orgName);
        this.organizationInfoDas.insert((BaseEo)organizationInfoEo);
        return organizationInfoEo.getId();
    }

    @Override
    public Long virtualRelateBusiness(VirtualRelateBusinessReqDto reqDto) {
        Long tenantId = this.getTenantId(reqDto.getTenantId());
        Long id = reqDto.getId();
        Long parentId = reqDto.getParentId();
        Long orgGroupId = reqDto.getOrgGroupId();
        this.checkVirRelateBiz(tenantId, id, parentId, orgGroupId);
        OrganizationEo bizOrg = (OrganizationEo)this.organizationDas.selectByPrimaryKey(id);
        if (bizOrg == null) {
            throw new BizException("500", "\u627e\u4e0d\u5230\u5173\u8054\u7684\u4e1a\u52a1\u5355\u5143[Id=" + id + "]");
        }
        if (!"2".equals(bizOrg.getType())) {
            throw new BizException("500", "\u5173\u8054\u7684\u7ec4\u7ec7\u5355\u5143\u4e0d\u662f\u4e1a\u52a1\u5355\u5143");
        }
        OrgOrgEo orgOrgEo = new OrgOrgEo();
        orgOrgEo.setOrgGroupId(orgGroupId);
        orgOrgEo.setParentOrgId(parentId);
        orgOrgEo.setOrgId(id);
        orgOrgEo.setExtension("");
        orgOrgEo.setTenantId(tenantId);
        this.orgOrgDas.insert((BaseEo)orgOrgEo);
        return orgOrgEo.getId();
    }

    @Override
    public void virtualUnRelateBusiness(VirtualRelateBusinessReqDto reqDto) {
        Long tenantId = this.getTenantId(reqDto.getTenantId());
        OrgOrgEo orgOrgEo = new OrgOrgEo();
        Long orgGroupId = reqDto.getOrgGroupId();
        Long parentId = reqDto.getParentId();
        Long id = reqDto.getId();
        if (orgGroupId == null || parentId == null || id == null) {
            throw new BizException("orgGroupId[orgGroupId=" + orgGroupId + "],parentId[parentId=" + parentId + "],id[id=" + id + "]\u90fd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        orgOrgEo.setOrgGroupId(orgGroupId);
        orgOrgEo.setParentOrgId(parentId);
        orgOrgEo.setOrgId(id);
        orgOrgEo.setExtension("");
        orgOrgEo.setTenantId(tenantId);
        List select = this.orgOrgDas.select((BaseEo)orgOrgEo, Integer.valueOf(1), Integer.valueOf(100));
        if (CollectionUtils.isEmpty((Collection)select)) {
            throw new BizException("\u627e\u4e0d\u5230\u8fd9\u6837\u7684\u865a\u62df\u5355\u5143\u548c\u4e1a\u52a1\u5355\u5143\u7684\u5173\u8054\u5173\u7cfb");
        }
        select.forEach(e -> this.orgOrgDas.deleteById(e.getId()));
    }

    private void checkVirRelateBiz(Long tenantId, Long orgId, Long parentId, Long orgGroupId) {
        OrgGroupEo orgGroupEo = (OrgGroupEo)this.orgGroupDas.selectByPrimaryKey(orgGroupId);
        if (orgGroupEo == null) {
            throw new BizException("500", "\u627e\u4e0d\u5230\u7ec4\u7ec7[orgGroupId=" + orgGroupId + "]");
        }
        if (parentId.equals(orgGroupId)) {
            throw new BizException("500", "\u7ec4\u7ec7\u4e0b\u4e0d\u80fd\u76f4\u63a5\u5173\u8054\u4e1a\u52a1\u5355\u5143");
        }
        OrganizationEo parent = (OrganizationEo)this.organizationDas.selectByPrimaryKey(parentId);
        if (parent == null) {
            throw new BizException("500", "\u627e\u4e0d\u5230\u7236\u8282\u70b9[parentId=" + parentId + "]");
        }
        if (!"3".equals(parent.getType())) {
            throw new BizException("500", "\u7236\u7ea7\u4e0d\u662f\u865a\u62df\u5355\u5143");
        }
        OrgOrgEo orgOrgEo = new OrgOrgEo();
        orgOrgEo.setOrgGroupId(orgGroupId);
        orgOrgEo.setParentOrgId(parentId);
        orgOrgEo.setOrgId(orgId);
        orgOrgEo.setTenantId(tenantId);
        if (this.orgOrgDas.count((BaseEo)orgOrgEo) > 0) {
            throw new BizException("500", "\u540c\u7ea7\u4e0b\u5df2\u6709\u91cd\u590d\u4e1a\u52a1\u5355\u5143[Id = " + orgId + "]");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public OrgAdvOpRespDto modifyOrgAdv(OrgAdvModifyReqDto orgAdvModifyReqDto) {
        Long tenantId = this.getTenantId(orgAdvModifyReqDto.getTenantId());
        Long id = orgAdvModifyReqDto.getId();
        OrganizationEo queryEo = (OrganizationEo)this.organizationDas.selectByPrimaryKey(id);
        if (queryEo == null) {
            throw new BizException("\u7ec4\u7ec7id\u4e3a" + id + "\u7684\u7ec4\u7ec7\u5355\u5143\u4e0d\u5b58\u5728");
        }
        String code = queryEo.getCode();
        OrgAdvOpRespDto resultDto = this.validCompanyCodeAndNameUNIQUE(orgAdvModifyReqDto.getUpdateOrgCompanyMsg(), orgAdvModifyReqDto.getCompanyOrgCode(), orgAdvModifyReqDto.getCompanyOrgName(), tenantId);
        if (resultDto.getResultCode() == 1) {
            final OrganizationEo organizationEo = new OrganizationEo();
            DtoHelper.dto2Eo((BaseVo)orgAdvModifyReqDto, (BaseEo)organizationEo);
            organizationEo.setCode(null);
            organizationEo.setId(queryEo.getId());
            if ("2".equals(orgAdvModifyReqDto.getType())) {
                this.processOrgFuncTypeRelation(id, orgAdvModifyReqDto.getFuncTypeCodes(), tenantId);
                this.processOrgPropValue(id, orgAdvModifyReqDto.getOrgAdvPropReqDtos(), tenantId);
            }
            if ("company".equals(orgAdvModifyReqDto.getEntityPropCode()) && orgAdvModifyReqDto.getOrgAdvInfoReqDto() != null) {
                OrganizationInfoEo dbEo = this.organizationInfoDas.queryByCode(code, tenantId);
                if (dbEo == null) {
                    String orgName = StringUtils.isNotBlank((CharSequence)orgAdvModifyReqDto.getName()) ? orgAdvModifyReqDto.getName() : queryEo.getName();
                    this.addOrgAdvInfo(orgAdvModifyReqDto.getOrgAdvInfoReqDto(), code, orgName);
                } else {
                    OrganizationInfoEo organizationInfoEo = new OrganizationInfoEo();
                    DtoHelper.dto2Eo((BaseVo)orgAdvModifyReqDto.getOrgAdvInfoReqDto(), (BaseEo)organizationInfoEo);
                    organizationInfoEo.setId(dbEo.getId());
                    organizationInfoEo.setOrgName(orgAdvModifyReqDto.getName());
                    this.organizationInfoDas.updateSelective((BaseEo)organizationInfoEo);
                }
            }
            this.organizationDas.updateSelective((BaseEo)organizationEo);
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                public void afterCommit() {
                    try {
                        OrganizationEo dbEo = (OrganizationEo)OrganizationExtServiceImpl.this.organizationDas.selectByPrimaryKey(organizationEo.getId());
                        OrganizationExtServiceImpl.this.organizationEventService.pushEvent(dbEo, null, "UPDATE");
                    }
                    catch (Exception e) {
                        logger.info("\u4fee\u6539\u7ec4\u7ec7\u4fe1\u606f\u53d1\u9001\u9886\u57df\u4e8b\u4ef6\u5931\u8d25!\u7ec4\u7ec7\u7f16\u7801: {},\u9519\u8bef\u4fe1\u606f: {}", (Object)organizationEo.getCode(), (Object)e.getMessage());
                    }
                }
            });
        }
        return resultDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeOrgAdvById(Long id) {
        final OrganizationEo eo = (OrganizationEo)this.organizationDas.selectByPrimaryKey(id);
        if (eo == null) {
            return;
        }
        Long tenantId = eo.getTenantId();
        this.deleteCheck(tenantId, id, eo.getType());
        if ("2".equals(eo.getType())) {
            this.processOrgFuncTypeRelation(id, null, tenantId);
            this.processOrgPropValue(id, null, tenantId);
            OrgOrgEo orgOrgEo = new OrgOrgEo();
            orgOrgEo.setTenantId(tenantId);
            orgOrgEo.setOrgId(id);
            this.orgOrgDas.logicDelete((BaseEo)orgOrgEo);
            this.organizationDas.logicDeleteById(eo.getId());
        } else if ("3".equals(eo.getType())) {
            Long orgGroupId;
            List<OrgAdvTreeRespDto> orgTree;
            OrgAdvTreeRespDto currentVirtualNode;
            OrgOrgEo queryOrgGroupIdEo = new OrgOrgEo();
            queryOrgGroupIdEo.setOrgId(id);
            List resultOrgGroupId = this.orgOrgDas.select((BaseEo)queryOrgGroupIdEo, Integer.valueOf(1), Integer.valueOf(1));
            if (CollectionUtils.isNotEmpty((Collection)resultOrgGroupId) && (currentVirtualNode = this.getDeleteVirtualOrgNode(orgTree = this.orgGroupService.queryOrgTree(orgGroupId = ((OrgOrgEo)resultOrgGroupId.get(0)).getOrgGroupId()), id)) != null) {
                this.deleteVirtualOrgNode(currentVirtualNode, tenantId);
            }
        }
        if ("company".equals(eo.getEntityPropCode())) {
            OrganizationInfoEo organizationInfoEo = new OrganizationInfoEo();
            organizationInfoEo.setOrgCode(eo.getCode());
            this.organizationInfoDas.logicDelete((BaseEo)organizationInfoEo);
        }
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

            public void afterCommit() {
                try {
                    eo.setDr(1);
                    OrganizationExtServiceImpl.this.organizationEventService.pushEvent(eo, null, "DELETE");
                }
                catch (Exception e) {
                    logger.info("\u5220\u9664\u7ec4\u7ec7\u4fe1\u606f\u53d1\u9001\u9886\u57df\u4e8b\u4ef6\u5931\u8d25!\u7ec4\u7ec7\u7f16\u7801: {},\u9519\u8bef\u4fe1\u606f: {}", (Object)eo.getCode(), (Object)e.getMessage());
                }
            }
        });
        this.dataLimitCacheUtil.cleanDataLimitOrgCache();
    }

    private OrgAdvTreeRespDto getDeleteVirtualOrgNode(List<OrgAdvTreeRespDto> orgTree, Long id) {
        OrgAdvTreeRespDto currentVirtualNode = null;
        for (OrgAdvTreeRespDto node : orgTree) {
            if (node.getId().equals(id)) {
                currentVirtualNode = node;
                break;
            }
            if (!CollectionUtils.isNotEmpty((Collection)node.getChildren()) || (currentVirtualNode = this.getDeleteVirtualOrgNode(node.getChildren(), id)) == null) continue;
            break;
        }
        return currentVirtualNode;
    }

    private void deleteVirtualOrgNode(OrgAdvTreeRespDto currentVirtualNode, Long tenantId) {
        if ("3".equals(currentVirtualNode.getType())) {
            Long id = currentVirtualNode.getId();
            EmployeeOrgEo employeeOrgEo = new EmployeeOrgEo();
            employeeOrgEo.setTenantId(tenantId);
            employeeOrgEo.setOrganizationId(id);
            List employeeOrgEos = this.employeeOrgDas.selectList((BaseEo)employeeOrgEo, Integer.valueOf(1), Integer.valueOf(100));
            if (employeeOrgEos.size() > 0) {
                throw new BizException("500", "\u8be5\u7ec4\u7ec7\u5355\u5143\u5df2\u5173\u8054\u5458\u5de5[employeeIds=" + employeeOrgEos.stream().map(e -> e.getEmployeeId().toString()).collect(Collectors.joining(",")) + "]\uff0c\u8bf7\u89e3\u9664\u5173\u8054\u5173\u7cfb\u540e\u518d\u5220\u9664");
            }
            OrgPostEo orgPostEo = new OrgPostEo();
            orgPostEo.setTenantId(tenantId);
            orgPostEo.setOrgId(id);
            List orgPostEos = this.orgPostDas.selectList((BaseEo)orgPostEo, Integer.valueOf(1), Integer.valueOf(100));
            if (orgPostEos.size() > 0) {
                throw new BizException("500", "\u8be5\u7ec4\u7ec7\u5355\u5143\u5df2\u5173\u8054\u5c97\u4f4d[postIds=" + orgPostEos.stream().map(e -> e.getPostId().toString()).collect(Collectors.joining(",")) + "]\uff0c\u8bf7\u89e3\u9664\u5173\u8054\u5173\u7cfb\u540e\u518d\u5220\u9664");
            }
            this.organizationDas.logicDeleteById(id);
            OrgOrgEo orgOrgEoByOrgId = new OrgOrgEo();
            orgOrgEoByOrgId.setTenantId(tenantId);
            orgOrgEoByOrgId.setOrgId(id);
            this.orgOrgDas.logicDelete((BaseEo)orgOrgEoByOrgId);
            OrgOrgEo orgOrgEoByParentOrgId = new OrgOrgEo();
            orgOrgEoByParentOrgId.setTenantId(tenantId);
            orgOrgEoByParentOrgId.setParentOrgId(id);
            this.orgOrgDas.logicDelete((BaseEo)orgOrgEoByParentOrgId);
        }
        if (CollectionUtils.isNotEmpty((Collection)currentVirtualNode.getChildren())) {
            for (OrgAdvTreeRespDto childNode : currentVirtualNode.getChildren()) {
                this.deleteVirtualOrgNode(childNode, tenantId);
            }
        }
    }

    private void deleteCheck(Long tenantId, Long orgId, String type) {
        if (!type.equals("3")) {
            OrganizationEo child = new OrganizationEo();
            child.setTenantId(tenantId);
            child.setParentId(orgId);
            if (this.organizationDas.count((BaseEo)child) > 0) {
                throw new BizException("500", "\u5b58\u5728\u5b50\u7ec4\u7ec7\u5355\u5143,\u4e0d\u5141\u8bb8\u5220\u9664");
            }
        }
        EmployeeOrgEo employeeOrgEo = new EmployeeOrgEo();
        employeeOrgEo.setTenantId(tenantId);
        employeeOrgEo.setOrganizationId(orgId);
        List employeeOrgEos = this.employeeOrgDas.selectList((BaseEo)employeeOrgEo, Integer.valueOf(1), Integer.valueOf(100));
        if (employeeOrgEos.size() > 0) {
            throw new BizException("500", "\u8be5\u7ec4\u7ec7\u5355\u5143\u5df2\u5173\u8054\u5458\u5de5[employeeIds=" + employeeOrgEos.stream().map(e -> e.getEmployeeId().toString()).collect(Collectors.joining(",")) + "]\uff0c\u8bf7\u89e3\u9664\u5173\u8054\u5173\u7cfb\u540e\u518d\u5220\u9664");
        }
        OrgPostEo orgPostEo = new OrgPostEo();
        orgPostEo.setTenantId(tenantId);
        orgPostEo.setOrgId(orgId);
        List orgPostEos = this.orgPostDas.selectList((BaseEo)orgPostEo, Integer.valueOf(1), Integer.valueOf(100));
        if (orgPostEos.size() > 0) {
            throw new BizException("500", "\u8be5\u7ec4\u7ec7\u5355\u5143\u5df2\u5173\u8054\u5c97\u4f4d[postIds=" + orgPostEos.stream().map(e -> e.getPostId().toString()).collect(Collectors.joining(",")) + "]\uff0c\u8bf7\u89e3\u9664\u5173\u8054\u5173\u7cfb\u540e\u518d\u5220\u9664");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeOrgAdvBatch(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.removeOrgAdvById(Long.valueOf(id));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableOrg(OrgAdvEnableReqDto orgAdvEnableReqDto) {
        String status = orgAdvEnableReqDto.getStatus();
        if (CollectionUtils.isNotEmpty((Collection)orgAdvEnableReqDto.getIds())) {
            for (Long id : orgAdvEnableReqDto.getIds()) {
                OrganizationEo updateEo = new OrganizationEo();
                updateEo.setId(id);
                updateEo.setStatus(status);
                this.organizationDas.updateSelective((BaseEo)updateEo);
            }
        } else {
            Long tenantId = this.getTenantId(orgAdvEnableReqDto.getTenantId());
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)COMPANY_CODE_UNIQUE, (Object)StringUtils.join((Iterable)orgAdvEnableReqDto.getCodes(), (String)",")));
            OrganizationEo organizationEo = new OrganizationEo();
            organizationEo.setSqlFilters(sqlFilters);
            organizationEo.setTenantId(tenantId);
            List organizationEos = this.organizationDas.select((BaseEo)organizationEo);
            for (OrganizationEo o : organizationEos) {
                if (!StringUtils.isBlank((CharSequence)o.getStatus()) && o.getStatus().equals(status)) continue;
                o.setStatus(status);
                this.organizationDas.updateSelective((BaseEo)o);
            }
        }
    }

    @Override
    public void upOrg(Long id) {
        Long tenantId = this.getTenantId(null);
        OrganizationEo currentEo = (OrganizationEo)this.organizationDas.selectByPrimaryKey(id);
        this.processSort(currentEo, tenantId, UP);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void upOrg(String orgCode) {
        Long tenantId = this.getTenantId(null);
        OrganizationEo organizationEo = new OrganizationEo();
        organizationEo.setCode(orgCode);
        organizationEo.setTenantId(tenantId);
        List results = this.organizationDas.select((BaseEo)organizationEo, Integer.valueOf(1), Integer.valueOf(1));
        if (CollectionUtils.isEmpty((Collection)results)) {
            return;
        }
        OrganizationEo currentEo = (OrganizationEo)results.get(0);
        this.processSort(currentEo, tenantId, UP);
    }

    @Override
    public void downOrg(Long id) {
        Long tenantId = this.getTenantId(null);
        OrganizationEo currentEo = (OrganizationEo)this.organizationDas.selectByPrimaryKey(id);
        this.processSort(currentEo, tenantId, DOWN);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void downOrg(String orgCode) {
        Long tenantId = this.getTenantId(null);
        OrganizationEo organizationEo = new OrganizationEo();
        organizationEo.setCode(orgCode);
        organizationEo.setTenantId(tenantId);
        List results = this.organizationDas.select((BaseEo)organizationEo, Integer.valueOf(1), Integer.valueOf(1));
        if (CollectionUtils.isEmpty((Collection)results)) {
            return;
        }
        OrganizationEo currentEo = (OrganizationEo)results.get(0);
        this.processSort(currentEo, tenantId, DOWN);
    }

    @Override
    public void migrateOldOrgData(Long tenantId, Long instanceId) {
        OrganizationEo queryOrgEo = new OrganizationEo();
        queryOrgEo.setTenantId(tenantId);
        queryOrgEo.setInstanceId(instanceId);
        int organizationCount = this.organizationDas.count((BaseEo)queryOrgEo);
        if (organizationCount <= 0) {
            logger.error("\u672a\u627e\u5230\u79df\u6237\u4e3a[{}]\u7684\u7ec4\u7ec7\u6570\u636e\uff0c\u4e0d\u505a\u8fc1\u79fb\u6570\u636e\u5904\u7406", (Object)tenantId);
            return;
        }
        List oldOrgEos = this.organizationDas.select((BaseEo)queryOrgEo, Integer.valueOf(1), Integer.valueOf(organizationCount));
        List<OrganizationEo> rootEos = this.getRootEo(oldOrgEos);
        if (CollectionUtils.isEmpty(rootEos)) {
            logger.error("\u672a\u627e\u5230\u79df\u6237\u4e3a[{}]\u7684\u6839\u7ec4\u7ec7\u8282\u70b9\u6570\u636e\uff0c\u4e0d\u505a\u8fc1\u79fb\u6570\u636e\u5904\u7406", (Object)tenantId);
            return;
        }
        OrganizationEo rootOrg = rootEos.get(0);
        OrgGroupEo orgGroupEo = new OrgGroupEo();
        orgGroupEo.setCode(rootOrg.getCode() + "HUMAN");
        orgGroupEo.setTenantId(tenantId);
        List dbOrgGroupEos = this.orgGroupDas.select((BaseEo)orgGroupEo, Integer.valueOf(1), Integer.valueOf(1));
        if (CollectionUtils.isNotEmpty((Collection)dbOrgGroupEos)) {
            orgGroupEo.setId(((OrgGroupEo)dbOrgGroupEos.get(0)).getId());
        }
        orgGroupEo.setInstanceId(rootOrg.getInstanceId());
        orgGroupEo.setName(rootOrg.getName());
        orgGroupEo.setFuncTypeCode("human_resource");
        orgGroupEo.setExtension("");
        if (orgGroupEo.getId() != null) {
            this.orgGroupDas.updateSelective((BaseEo)orgGroupEo);
        } else {
            this.orgGroupDas.insert((BaseEo)orgGroupEo);
        }
        Set rootIds = rootEos.stream().map(StdOrganizationEo::getId).collect(Collectors.toSet());
        Long orgGroupId = orgGroupEo.getId();
        for (OrganizationEo oldEo : oldOrgEos) {
            if (!Arrays.asList("2", "3").contains(oldEo.getType())) {
                if (StringUtils.isNotBlank((CharSequence)oldEo.getType()) && oldEo.getType().equals(Integer.toString(OrgTypeEnum.COMPANY.getKey()))) {
                    oldEo.setEntityPropCode("company");
                } else {
                    oldEo.setEntityPropCode("department");
                }
                if (oldEo.getId().equals(rootOrg.getId())) {
                    oldEo.setParentId(OrgUserConstants.ORG_ROOT_ID);
                } else if (rootIds.contains(oldEo.getId())) {
                    oldEo.setParentId(rootOrg.getId());
                }
                if (StringUtils.isBlank((CharSequence)oldEo.getStatus())) {
                    oldEo.setStatus("1");
                }
                oldEo.setType("2");
                this.organizationDas.updateSelective((BaseEo)oldEo);
                OrgFuncTypeRelationEo orgFuncTypeRelationEo = new OrgFuncTypeRelationEo();
                orgFuncTypeRelationEo.setOrgId(oldEo.getId());
                List dbOrgFuncTypeRelationEos = this.orgFuncTypeRelationDas.select((BaseEo)orgFuncTypeRelationEo, Integer.valueOf(1), Integer.valueOf(1));
                if (CollectionUtils.isNotEmpty((Collection)dbOrgFuncTypeRelationEos)) {
                    orgFuncTypeRelationEo.setId(((OrgFuncTypeRelationEo)dbOrgFuncTypeRelationEos.get(0)).getId());
                }
                orgFuncTypeRelationEo.setFuncTypeCode("human_resource");
                orgFuncTypeRelationEo.setTenantId(tenantId);
                orgFuncTypeRelationEo.setInstanceId(oldEo.getInstanceId());
                orgFuncTypeRelationEo.setExtension("");
                if (orgFuncTypeRelationEo.getId() != null) {
                    this.orgFuncTypeRelationDas.updateSelective((BaseEo)orgFuncTypeRelationEo);
                } else {
                    this.orgFuncTypeRelationDas.insert((BaseEo)orgFuncTypeRelationEo);
                }
                PostEo queryPostEo = new PostEo();
                queryPostEo.setOrgCode(oldEo.getCode());
                queryPostEo.setTenantId(tenantId);
                queryPostEo.setInstanceId(oldEo.getInstanceId());
                int postCount = this.postDas.count((BaseEo)queryPostEo);
                if (postCount > 0) {
                    List dbPostEos = this.postDas.select((BaseEo)queryPostEo, Integer.valueOf(1), Integer.valueOf(postCount));
                    Set postIds = dbPostEos.stream().map(BaseEo::getId).collect(Collectors.toSet());
                    OrgPostEo queryEo = new OrgPostEo();
                    ArrayList sqlFilters = new ArrayList();
                    sqlFilters.add(SqlFilter.in((String)"post_id", (Object)StringUtils.join(postIds, (String)",")));
                    queryEo.setSqlFilters((List)sqlFilters);
                    List dbOrgPostEos = this.orgPostDas.select((BaseEo)queryEo, Integer.valueOf(1), Integer.valueOf(postIds.size()));
                    Map<Object, Object> dbPostId2OrgPostId = new HashMap();
                    if (CollectionUtils.isNotEmpty((Collection)dbOrgPostEos)) {
                        dbPostId2OrgPostId = dbOrgPostEos.stream().collect(Collectors.toMap(StdOrgPostEo::getPostId, BaseEo::getId));
                    }
                    ArrayList<OrgPostEo> orgPostEos = new ArrayList<OrgPostEo>();
                    for (PostEo postEo : dbPostEos) {
                        OrgPostEo orgPostEo = new OrgPostEo();
                        orgPostEo.setOrgGroupId(orgGroupId);
                        orgPostEo.setOrgId(oldEo.getId());
                        orgPostEo.setPostId(postEo.getId());
                        orgPostEo.setTenantId(tenantId);
                        orgPostEo.setInstanceId(oldEo.getInstanceId());
                        orgPostEo.setExtension("");
                        if (dbPostId2OrgPostId.get(postEo.getId()) != null) {
                            orgPostEo.setId((Long)dbPostId2OrgPostId.get(postEo.getId()));
                            this.orgPostDas.updateSelective((BaseEo)orgPostEo);
                            continue;
                        }
                        orgPostEos.add(orgPostEo);
                    }
                    this.orgPostDas.insertBatch(orgPostEos);
                }
            }
            EmployeeOrgEo queryEmployeeOrgEo = new EmployeeOrgEo();
            queryEmployeeOrgEo.setOrganizationId(oldEo.getId());
            int employOrgCount = this.employeeOrgDas.count((BaseEo)queryEmployeeOrgEo);
            if (employOrgCount <= 0) continue;
            List dbEmployeeOrgEos = this.employeeOrgDas.select((BaseEo)queryEmployeeOrgEo, Integer.valueOf(1), Integer.valueOf(employOrgCount));
            for (EmployeeOrgEo employeeOrgEo : dbEmployeeOrgEos) {
                employeeOrgEo.setOrgGroupId(orgGroupId);
                this.employeeOrgDas.updateSelective((BaseEo)employeeOrgEo);
            }
        }
        EmployeePostEo queryEmployeePostEo = new EmployeePostEo();
        queryEmployeePostEo.setTenantId(tenantId);
        queryEmployeePostEo.setInstanceId(instanceId);
        int employeePostEoCount = this.employeePostDas.count((BaseEo)queryEmployeePostEo);
        if (employeePostEoCount > 0) {
            List dbEmployeePostEos = this.employeePostDas.select((BaseEo)queryEmployeePostEo, Integer.valueOf(1), Integer.valueOf(employeePostEoCount));
            Map<Long, List<EmployeePostEo>> instance2EmployeePostEoMap = dbEmployeePostEos.stream().collect(Collectors.groupingBy(BaseEo::getInstanceId));
            for (Long instanceIdDb : instance2EmployeePostEoMap.keySet()) {
                List<EmployeePostEo> dbEmployeePostValue = instance2EmployeePostEoMap.get(instanceIdDb);
                HashSet<String> employNoSet = new HashSet<String>();
                HashSet<String> postCodeSet = new HashSet<String>();
                for (EmployeePostEo employeePostEo : dbEmployeePostValue) {
                    employNoSet.add(employeePostEo.getEmployeeNo());
                    postCodeSet.add(employeePostEo.getPostCode());
                }
                EmployeeEo queryEmployeeEo = new EmployeeEo();
                queryEmployeeEo.setTenantId(tenantId);
                queryEmployeeEo.setInstanceId(instanceIdDb);
                ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
                sqlFilters.add(SqlFilter.in((String)"employee_no", (Object)StringUtils.join(employNoSet, (String)",")));
                queryEmployeeEo.setSqlFilters(sqlFilters);
                List dbEmployeeList = this.employeeDas.select((BaseEo)queryEmployeeEo, Integer.valueOf(1), Integer.valueOf(employNoSet.size()));
                Map<Object, Object> employeeNoToIdMap = new HashMap();
                if (CollectionUtils.isNotEmpty((Collection)dbEmployeeList)) {
                    employeeNoToIdMap = dbEmployeeList.stream().collect(Collectors.toMap(StdEmployeeEo::getEmployeeNo, BaseEo::getId, (k1, k2) -> k1));
                }
                PostEo queryPostEo2 = new PostEo();
                queryPostEo2.setTenantId(tenantId);
                queryPostEo2.setInstanceId(instanceIdDb);
                sqlFilters = new ArrayList();
                sqlFilters.add(SqlFilter.in((String)COMPANY_CODE_UNIQUE, (Object)StringUtils.join(postCodeSet, (String)",")));
                queryPostEo2.setSqlFilters(sqlFilters);
                List dbPostList = this.postDas.select((BaseEo)queryPostEo2, Integer.valueOf(1), Integer.valueOf(postCodeSet.size()));
                Map<Object, Object> postCodeToIdMap = new HashMap();
                if (CollectionUtils.isNotEmpty((Collection)dbEmployeeList)) {
                    postCodeToIdMap = dbPostList.stream().collect(Collectors.toMap(StdPostEo::getCode, BaseEo::getId, (k1, k2) -> k1));
                }
                for (EmployeePostEo dbEo : dbEmployeePostValue) {
                    String employeeNo = dbEo.getEmployeeNo();
                    String postCode = dbEo.getPostCode();
                    Long employeeId = (Long)employeeNoToIdMap.get(employeeNo);
                    Long postId = (Long)postCodeToIdMap.get(postCode);
                    dbEo.setPostId(postId);
                    dbEo.setEmployeeId(employeeId);
                    this.employeePostDas.updateSelective((BaseEo)dbEo);
                }
            }
        }
    }

    private List<OrganizationEo> getRootEo(List<OrganizationEo> oldEoValues) {
        Map id2OrgMap = oldEoValues.stream().collect(Collectors.toMap(StdOrganizationEo::getId, Function.identity(), (k1, k2) -> k1));
        ArrayList<OrganizationEo> rootEos = new ArrayList<OrganizationEo>();
        for (OrganizationEo orgEo : oldEoValues) {
            Long parentId = orgEo.getParentId();
            if (id2OrgMap.get(parentId) != null) continue;
            rootEos.add(orgEo);
        }
        return rootEos;
    }

    private void processSort(OrganizationEo currentEo, Long tenantId, String sortType) {
        OrganizationEo selectEo = new OrganizationEo();
        selectEo.setParentId(currentEo.getParentId());
        selectEo.setOrderBy("sortno");
        selectEo.setTenantId(tenantId);
        List eoList = this.organizationDas.select((BaseEo)selectEo);
        if (CollectionUtils.isEmpty((Collection)eoList) || eoList.size() == 1) {
            return;
        }
        ArrayList newSortEoList = new ArrayList();
        int size = eoList.size();
        for (int i = 0; i < size; ++i) {
            int relatedIndex;
            OrganizationEo eo = (OrganizationEo)eoList.get(i);
            if (!eo.getId().equals(currentEo.getId())) continue;
            if (UP.equals(sortType)) {
                if (i == 0) break;
                relatedIndex = i - 1;
                eoList.set(i, eoList.get(relatedIndex));
                eoList.set(relatedIndex, eo);
                newSortEoList.addAll(eoList);
                break;
            }
            if (!DOWN.equals(sortType)) continue;
            if (i == size - 1) break;
            relatedIndex = i + 1;
            eoList.set(i, eoList.get(relatedIndex));
            eoList.set(relatedIndex, eo);
            newSortEoList.addAll(eoList);
            break;
        }
        if (CollectionUtils.isNotEmpty(newSortEoList)) {
            int sortno = 1;
            for (OrganizationEo eo : newSortEoList) {
                eo.setSortNO(Integer.valueOf(sortno++));
                this.organizationDas.updateSelective((BaseEo)eo);
            }
        }
    }

    private void setOrgAdvInfo(Long tenantId, OrganizationEo eo, OrgAdvDetailRespDto orgAdvDetailRespDto) {
        OrganizationInfoEo dbEo = this.organizationInfoDas.queryByCode(eo.getCode(), tenantId);
        OrgAdvInfoRespDto orgAdvInfoRespDto = new OrgAdvInfoRespDto();
        if (dbEo != null) {
            DtoHelper.eo2Dto((BaseEo)dbEo, (BaseVo)orgAdvInfoRespDto);
            orgAdvInfoRespDto.setOrgCode(eo.getCode());
        }
        orgAdvDetailRespDto.setOrgAdvInfoRespDto(orgAdvInfoRespDto);
    }

    @Override
    public OrgAdvDetailRespDto queryById(Long id) {
        OrganizationEo eo = (OrganizationEo)this.organizationDas.selectByPrimaryKey(id);
        Assert.isTrue((eo != null ? 1 : 0) != 0, (String)("\u7ec4\u7ec7\u5355\u5143\u4e0d\u5b58\u5728: [" + id + "]"));
        OrgAdvDetailRespDto orgAdvDetailRespDto = new OrgAdvDetailRespDto();
        DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)orgAdvDetailRespDto);
        List<String> orgfuncTypeCodes = this.getOrgFuncTypeCodeList(id, eo.getTenantId());
        if (CollectionUtils.isEmpty(orgfuncTypeCodes)) {
            orgfuncTypeCodes = new ArrayList<String>();
        }
        orgAdvDetailRespDto.setFuncTypeCodes(orgfuncTypeCodes);
        orgAdvDetailRespDto.setParentName(this.getParentOrgName(eo.getParentId()));
        orgAdvDetailRespDto.setEntityPropName(this.getOrgEntityName(eo.getEntityPropCode()));
        List<OrgAdvPropRespDto> orgAdvPropRespDtos = this.getOrgPropValueDto(eo.getId(), orgfuncTypeCodes, eo.getTenantId());
        orgAdvDetailRespDto.setOrgAdvPropRespDtos(orgAdvPropRespDtos);
        this.setOrgAdvInfo(eo.getTenantId(), eo, orgAdvDetailRespDto);
        return orgAdvDetailRespDto;
    }

    @Override
    public PageInfo<OrgAdvRespDto> queryOrgAdvPage(OrgAdvQueryReqDto orgAdvQueryReqDto, Integer pageNum, Integer pageSize) {
        OrganizationEo organizationEo = new OrganizationEo();
        DtoHelper.dto2Eo((BaseVo)orgAdvQueryReqDto, (BaseEo)organizationEo);
        Long tenantId = this.getTenantId(orgAdvQueryReqDto.getTenantId());
        organizationEo.setTenantId(tenantId);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (StringUtils.isNotBlank((CharSequence)orgAdvQueryReqDto.getCode())) {
            organizationEo.setCode(null);
            sqlFilters.add(SqlFilter.eq((String)COMPANY_CODE_UNIQUE, (Object)orgAdvQueryReqDto.getCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)orgAdvQueryReqDto.getName())) {
            organizationEo.setName(null);
            sqlFilters.add(SqlFilter.like((String)COMPANY_NAME_UNIQUE, (Object)("%" + orgAdvQueryReqDto.getName() + "%")));
        }
        organizationEo.setSqlFilters(sqlFilters);
        if (StringUtils.isNotBlank((CharSequence)orgAdvQueryReqDto.getCompanyOrgName())) {
            Set<String> companyOrgCodeSet = this.getCompanyOrgCodesByName(orgAdvQueryReqDto.getCompanyOrgName(), tenantId);
            if (CollectionUtils.isEmpty(companyOrgCodeSet)) {
                companyOrgCodeSet = new HashSet<String>();
            }
            if (StringUtils.isNotBlank((CharSequence)orgAdvQueryReqDto.getCode())) {
                companyOrgCodeSet.add(orgAdvQueryReqDto.getCode());
            }
            if (CollectionUtils.isNotEmpty(companyOrgCodeSet)) {
                organizationEo.setCompanyOrgCode(null);
                sqlFilters.add(SqlFilter.in((String)"company_org_code", (Object)StringUtils.join(companyOrgCodeSet, (String)",")));
            }
        }
        PageInfo eoPageInfo = this.organizationDas.selectPage((BaseEo)organizationEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        ArrayList<OrgAdvRespDto> orgAdvRespDtos = new ArrayList<OrgAdvRespDto>();
        if (eoPageInfo != null && CollectionUtils.isNotEmpty((Collection)eoPageInfo.getList())) {
            CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            Set<Long> parentIds = eoPageInfo.getList().stream().filter(eo -> eo.getParentId() != null).map(StdOrganizationEo::getParentId).collect(Collectors.toSet());
            Map<Long, String> parentId2Name = this.getParentOrgId2Name(parentIds, tenantId);
            Map<String, String> entityCode2Name = this.getOrgEntityName();
            for (OrganizationEo eo2 : eoPageInfo.getList()) {
                OrgAdvRespDto dto = new OrgAdvRespDto();
                DtoHelper.eo2Dto((BaseEo)eo2, (BaseVo)dto);
                dto.setParentName(parentId2Name.get(eo2.getParentId()));
                dto.setEntityPropName(entityCode2Name.get(eo2.getEntityPropCode()));
                orgAdvRespDtos.add(dto);
            }
        }
        dtoPageInfo.setList(orgAdvRespDtos);
        return dtoPageInfo;
    }

    @Override
    public OrgAdvTreeRespDto queryTree(OrgAdvTreeReqDto orgAdvTreeReqDto) {
        Long tenantId = this.getTenantId(orgAdvTreeReqDto.getTenantId());
        OrganizationEo queryEo = new OrganizationEo();
        DtoHelper.dto2Eo((BaseVo)orgAdvTreeReqDto, (BaseEo)queryEo);
        queryEo.setTenantId(tenantId);
        List organizationEos = this.organizationDas.select((BaseEo)queryEo, Integer.valueOf(1), Integer.valueOf(5000));
        ArrayList<OrgAdvTreeRespDto> orgAdvTreeRespDtos = new ArrayList<OrgAdvTreeRespDto>();
        for (OrganizationEo eo : organizationEos) {
            OrgAdvTreeRespDto dto = new OrgAdvTreeRespDto();
            DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)dto);
            orgAdvTreeRespDtos.add(dto);
        }
        TreeBuilder treeBuilder = new TreeBuilder();
        Comparator<OrgAdvTreeRespDto> bySortASC = Comparator.comparing(OrgAdvTreeRespDto::getSortNO, Comparator.nullsLast(Integer::compareTo));
        List results = treeBuilder.buildByParentKey(orgAdvTreeRespDtos, Boolean.valueOf(false), bySortASC);
        if (CollectionUtils.isEmpty((Collection)results)) {
            return null;
        }
        return (OrgAdvTreeRespDto)results.get(0);
    }

    @Override
    public PageInfo<OrgInfoAdvRespDto> queryOrgInfo(OrgInfoAdvReqDto orgInfoAdvReqDto, Integer pageNum, Integer pageSize) {
        OrganizationEo queryEo = new OrganizationEo();
        Long tenantId = this.getTenantId(null);
        if (null != orgInfoAdvReqDto.getTenantId()) {
            tenantId = orgInfoAdvReqDto.getTenantId();
        }
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (StringUtils.isNotBlank((CharSequence)orgInfoAdvReqDto.getCompanyOrgCode())) {
            queryEo.setCompanyOrgCode(null);
            sqlFilters.add(SqlFilter.like((String)"company_org_code", (Object)("%" + orgInfoAdvReqDto.getCompanyOrgCode() + "%")));
        }
        if (StringUtils.isNotBlank((CharSequence)orgInfoAdvReqDto.getCompanyOrgName())) {
            queryEo.setCompanyOrgName(null);
            sqlFilters.add(SqlFilter.like((String)"company_org_name", (Object)("%" + orgInfoAdvReqDto.getCompanyOrgName() + "%")));
        }
        sqlFilters.add(SqlFilter.in((String)"type", Arrays.asList("2", "3")));
        queryEo.setSqlFilters(sqlFilters);
        queryEo.setTenantId(tenantId);
        PageInfo eoPageInfo = this.organizationDas.selectPage((BaseEo)queryEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        ArrayList<OrgInfoAdvRespDto> dtoList = new ArrayList<OrgInfoAdvRespDto>();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        if (null != eoPageInfo && CollectionUtils.isNotEmpty((Collection)eoPageInfo.getList())) {
            Map<String, String> name2Code = eoPageInfo.getList().stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getCompanyOrgName())).collect(Collectors.toMap(StdOrganizationEo::getCompanyOrgName, StdOrganizationEo::getCompanyOrgCode, (k1, k2) -> k1));
            for (String name : name2Code.keySet()) {
                OrgInfoAdvRespDto dto = new OrgInfoAdvRespDto();
                dto.setCompanyOrgName(name);
                dto.setCompanyOrgCode(name2Code.get(name));
                dtoList.add(dto);
            }
        }
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public PageInfo<String> queryOrgName(String orgName, Integer pageNum, Integer pageSize) {
        OrganizationEo organizationEo = new OrganizationEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (StringUtils.isNotBlank((CharSequence)orgName)) {
            organizationEo.setName(null);
            sqlFilters.add(SqlFilter.like((String)COMPANY_NAME_UNIQUE, (Object)("%" + orgName + "%")));
        }
        sqlFilters.add(SqlFilter.in((String)"type", Arrays.asList("2", "3")));
        organizationEo.setSqlFilters(sqlFilters);
        organizationEo.setTenantId(this.getTenantId(null));
        List results = this.organizationDas.select((BaseEo)organizationEo, pageNum, pageSize);
        if (CollectionUtils.isEmpty((Collection)results)) {
            return new PageInfo();
        }
        return new PageInfo(results.stream().map(StdOrganizationEo::getName).distinct().filter(StringUtils::isNotBlank).collect(Collectors.toList()));
    }

    @Override
    public PageInfo<String> queryOrgCode(String orgCode, Integer pageNum, Integer pageSize) {
        OrganizationEo organizationEo = new OrganizationEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (StringUtils.isNotBlank((CharSequence)orgCode)) {
            organizationEo.setName(null);
            sqlFilters.add(SqlFilter.like((String)COMPANY_CODE_UNIQUE, (Object)("%" + orgCode + "%")));
        }
        sqlFilters.add(SqlFilter.in((String)"type", Arrays.asList("2", "3")));
        organizationEo.setSqlFilters(sqlFilters);
        organizationEo.setTenantId(this.getTenantId(null));
        List results = this.organizationDas.select((BaseEo)organizationEo, pageNum, pageSize);
        if (CollectionUtils.isEmpty((Collection)results)) {
            return new PageInfo();
        }
        return new PageInfo(results.stream().map(StdOrganizationEo::getCode).distinct().filter(StringUtils::isNotBlank).collect(Collectors.toList()));
    }

    @Override
    public PageInfo<OrgEntityPropertyRespDto> queryOrgEntityProperty() {
        String value = (String)this.orgEntityPropertyParam.getValue();
        if (StringUtils.isBlank((CharSequence)value)) {
            return new PageInfo();
        }
        JSONObject jsonObject = JSONObject.parseObject((String)value);
        if (jsonObject == null) {
            return new PageInfo();
        }
        JSONArray rows = (JSONArray)jsonObject.get((Object)"rows");
        if (CollectionUtils.isEmpty((Collection)rows)) {
            return new PageInfo();
        }
        List orgEntityPropertyRespDtos = rows.toJavaList(OrgEntityPropertyRespDto.class);
        return new PageInfo(orgEntityPropertyRespDtos);
    }

    @Override
    public PageInfo<OrgFuncTypeRespDto> queryOrgFuncType() {
        if (this.queryOrgModel().booleanValue()) {
            OrgFuncTypeRespDto orgFuncType = new OrgFuncTypeRespDto();
            orgFuncType.setCode("human_resource");
            orgFuncType.setValue("\u4eba\u529b");
            return new PageInfo(Collections.singletonList(orgFuncType));
        }
        String value = (String)this.orgFuncTypeParam.getValue();
        if (StringUtils.isBlank((CharSequence)value)) {
            return new PageInfo();
        }
        JSONObject jsonObject = JSONObject.parseObject((String)value);
        if (jsonObject == null) {
            return new PageInfo();
        }
        JSONArray rows = (JSONArray)jsonObject.get((Object)"rows");
        if (CollectionUtils.isEmpty((Collection)rows)) {
            return new PageInfo();
        }
        List orgFuncTypeDtos = rows.toJavaList(OrgFuncTypeRespDto.class);
        return new PageInfo(orgFuncTypeDtos);
    }

    @Override
    public Boolean queryOrgModel() {
        Boolean orgModel = (Boolean)this.orgModelParam.getValue();
        return orgModel == null || orgModel != false;
    }

    @Override
    public Boolean isHumanResourceOrg(Long id) {
        OrganizationEo organizationEo = (OrganizationEo)this.organizationDas.selectByPrimaryKey(id);
        return this.isHumanResourceOrg(organizationEo);
    }

    private boolean isHumanResourceOrg(OrganizationEo organizationEo) {
        if (organizationEo == null) {
            return false;
        }
        if (organizationEo.getType() == null) {
            logger.info("\u7ec4\u7ec7\u7c7b\u578b\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u7ec4\u7ec7\u6570\u636e\u540c\u6b65\uff01");
            return false;
        }
        if (!"2".equals(organizationEo.getType())) {
            logger.info("\u865a\u62df\u7ec4\u7ec7\u8282\u70b9\uff0c\u4e0d\u8fdb\u884c\u7ec4\u7ec7\u6570\u636e\u540c\u6b65\uff01");
            return false;
        }
        OrgFuncTypeRelationEo orgFuncTypeRelationEo = new OrgFuncTypeRelationEo();
        orgFuncTypeRelationEo.setOrgId(organizationEo.getId());
        orgFuncTypeRelationEo.setTenantId(organizationEo.getTenantId());
        orgFuncTypeRelationEo.setFuncTypeCode("human_resource");
        if (this.orgFuncTypeRelationDas.count((BaseEo)orgFuncTypeRelationEo) == 0) {
            logger.info("\u975e\u4eba\u529b\u7ec4\u7ec7\uff0c\u4e0d\u8fdb\u884c\u7ec4\u7ec7\u6570\u636e\u540c\u6b65\uff01");
            return false;
        }
        return true;
    }

    @Override
    public Long getHumanResourceParentOrgId(Long id) {
        OrganizationEo organizationEo = (OrganizationEo)this.organizationDas.selectByPrimaryKey(id);
        if (!this.isHumanResourceOrg(organizationEo)) {
            return null;
        }
        if (organizationEo.getParentId() == null || organizationEo.getParentId() == 0L || organizationEo.getParentId() == -1L) {
            logger.info("\u5f53\u524d\u8282\u70b9\u4e3a\u4eba\u529b\u7ec4\u7ec7\u7236\u8282\u70b9\uff0c\u8fd4\u56de-1L");
            return -1L;
        }
        return this.getHumanResourceParentOrgId(organizationEo.getParentId(), 0);
    }

    private Long getHumanResourceParentOrgId(Long id, int num) {
        if (id == null || id == 0L || id == -1L) {
            logger.info("\u672a\u67e5\u8be2\u5230\u4eba\u529b\u7ec4\u7ec7\u7236\u8282\u70b9\uff0c\u8fd4\u56de-1L");
            return -1L;
        }
        OrganizationEo parentEo = (OrganizationEo)this.organizationDas.selectByPrimaryKey(id);
        if (this.isHumanResourceOrg(parentEo)) {
            return parentEo.getId();
        }
        if (parentEo != null && num < 10) {
            return this.getHumanResourceParentOrgId(parentEo.getId(), ++num);
        }
        return null;
    }

    @Override
    public SyncOrgAndEmployeeVo getOrgAndEmployeeVo(SyncOrgAndEmployeeReqVo reqVo) {
        Long tenantId = reqVo.getTenantId() == null ? ServiceContext.getContext().getRequestTenantId() : reqVo.getTenantId();
        OrgFuncTypeRelationEo orgFuncTypeRelationEo = new OrgFuncTypeRelationEo();
        orgFuncTypeRelationEo.setTenantId(tenantId);
        orgFuncTypeRelationEo.setFuncTypeCode("human_resource");
        List relationEoList = this.orgFuncTypeRelationDas.select((BaseEo)orgFuncTypeRelationEo, Integer.valueOf(1), Integer.valueOf(1000));
        if (CollectionUtil.isEmpty((Collection)relationEoList)) {
            logger.info("\u672a\u67e5\u8be2\u5230\u4eba\u529b\u7ec4\u7ec7");
            return null;
        }
        Set queryOrgIds = relationEoList.parallelStream().map(StdOrgFuncTypeRelationEo::getOrgId).collect(Collectors.toSet());
        OrganizationEo queryOrgEo = new OrganizationEo();
        queryOrgEo.setTenantId(tenantId);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"id", (Object)StringUtils.join(queryOrgIds, (String)",")));
        queryOrgEo.setSqlFilters(sqlFilters);
        List organizationEoList = this.organizationDas.select((BaseEo)queryOrgEo, Integer.valueOf(1), Integer.valueOf(1000));
        if (CollectionUtil.isEmpty((Collection)organizationEoList)) {
            logger.info("\u672a\u67e5\u8be2\u5230\u4eba\u529b\u7ec4\u7ec7");
            return null;
        }
        SyncOrgAndEmployeeVo syncVo = new SyncOrgAndEmployeeVo();
        this.setOrgVoList(organizationEoList, syncVo);
        this.setEmployeeVoList(tenantId, organizationEoList, syncVo);
        return syncVo;
    }

    private void setEmployeeVoList(Long tenantId, List<OrganizationEo> organizationEoList, SyncOrgAndEmployeeVo syncVo) {
        List allOrgIdList = organizationEoList.stream().map(StdOrganizationEo::getId).collect(Collectors.toList());
        EmployeeOrgEo employeeOrgEo = new EmployeeOrgEo();
        employeeOrgEo.setTenantId(tenantId);
        ArrayList<SqlFilter> filters = new ArrayList<SqlFilter>();
        filters.add(SqlFilter.in((String)"organization_id", (Object)StringUtils.join(allOrgIdList, (String)",")));
        employeeOrgEo.setSqlFilters(filters);
        List employeeOrgEoList = this.employeeOrgDas.select((BaseEo)employeeOrgEo, Integer.valueOf(1), Integer.valueOf(20000));
        if (CollectionUtil.isEmpty((Collection)employeeOrgEoList)) {
            return;
        }
        Set employeeIds = employeeOrgEoList.parallelStream().map(StdEmployeeOrgEo::getEmployeeId).collect(Collectors.toSet());
        EmployeeEo employeeEo = new EmployeeEo();
        employeeEo.setTenantId(tenantId);
        ArrayList<SqlFilter> employeeFilters = new ArrayList<SqlFilter>();
        employeeFilters.add(SqlFilter.in((String)"id", (Object)StringUtils.join(employeeIds, (String)",")));
        employeeEo.setSqlFilters(employeeFilters);
        List employeeEoList = this.employeeDas.select((BaseEo)employeeEo, Integer.valueOf(1), Integer.valueOf(10000));
        if (CollectionUtil.isEmpty((Collection)employeeEoList)) {
            return;
        }
        Map<Long, List<EmployeeOrgEo>> employeeId2EmployeeOrgEoMap = employeeOrgEoList.parallelStream().collect(Collectors.groupingBy(StdEmployeeOrgEo::getEmployeeId));
        EmployeePostEo employeePostEo = new EmployeePostEo();
        employeePostEo.setTenantId(tenantId);
        ArrayList<SqlFilter> employeePostFilters = new ArrayList<SqlFilter>();
        employeePostFilters.add(SqlFilter.in((String)"employee_id", (Object)StringUtils.join(employeeIds, (String)",")));
        employeePostEo.setSqlFilters(employeePostFilters);
        List employeePostEoList = this.employeePostDas.select((BaseEo)employeePostEo, Integer.valueOf(1), Integer.valueOf(20000));
        Map<Long, List<EmployeePostEo>> employeeId2EmployeePostEoMap = employeePostEoList.parallelStream().collect(Collectors.groupingBy(StdEmployeePostEo::getEmployeeId));
        PostEo queryPostEo = new PostEo();
        queryPostEo.setTenantId(tenantId);
        List postEoList = this.postDas.select((BaseEo)queryPostEo, Integer.valueOf(1), Integer.valueOf(1000));
        Map<Long, String> postId2PostNameMap = postEoList.parallelStream().collect(Collectors.toMap(BaseEo::getId, StdPostEo::getName));
        ArrayList<SyncEmployeeVo> employeeVoList = new ArrayList<SyncEmployeeVo>();
        employeeEoList.forEach(eo -> {
            List postEos;
            SyncEmployeeVo syncEmployeeVo = new SyncEmployeeVo();
            CubeBeanUtils.copyProperties((Object)((Object)syncEmployeeVo), (Object)eo, (String[])new String[0]);
            List orgEos = (List)employeeId2EmployeeOrgEoMap.get(eo.getId());
            if (CollectionUtil.isNotEmpty((Collection)orgEos)) {
                ArrayList<Long> orgIds = new ArrayList<Long>();
                orgEos.forEach(orgEo -> {
                    Long orgId = orgEo.getOrganizationId();
                    if (orgId != null) {
                        orgIds.add(orgId);
                    }
                });
                syncEmployeeVo.setOrgIds(orgIds);
            }
            if (CollectionUtil.isNotEmpty((Collection)(postEos = (List)employeeId2EmployeePostEoMap.get(eo.getId())))) {
                ArrayList<String> postNames = new ArrayList<String>();
                postEos.forEach(postEo -> {
                    String postName = (String)postId2PostNameMap.get(postEo.getPostId());
                    if (postName != null) {
                        postNames.add(postName);
                    }
                });
                syncEmployeeVo.setPostNames(postNames);
            }
            employeeVoList.add(syncEmployeeVo);
        });
        syncVo.setEmployeeVoList(employeeVoList);
    }

    private void setOrgVoList(List<OrganizationEo> organizationEoList, SyncOrgAndEmployeeVo syncVo) {
        ArrayList orgVoList = new ArrayList();
        CubeBeanUtils.copyCollection(orgVoList, organizationEoList, SyncOrgVo.class);
        List<Long> allOrgIdList = organizationEoList.stream().map(StdOrganizationEo::getId).collect(Collectors.toList());
        orgVoList.forEach(orgVo -> {
            if (orgVo.getParentId() == null || orgVo.getParentId() == 0L || orgVo.getParentId() == -1L || !allOrgIdList.contains(orgVo.getParentId())) {
                orgVo.setParentId(-1L);
            } else {
                orgVo.setParentId(this.getHumanResourceParentOrgId(orgVo.getId()));
            }
        });
        Map<Long, List<SyncOrgVo>> childrenMap = orgVoList.stream().filter(dto -> dto.getParentId() != null && dto.getParentId() > 0L).collect(Collectors.groupingBy(SyncOrgVo::getParentId));
        ArrayList orgVos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(orgVoList)) {
            for (SyncOrgVo dto2 : orgVoList) {
                if (dto2.getParentId() != null && dto2.getParentId() != 0L && dto2.getParentId() != -1L && allOrgIdList.contains(dto2.getParentId())) continue;
                this.buildDtoTreeRespDto(dto2, childrenMap);
                orgVos.add(dto2);
            }
        }
        syncVo.setOrgVoList(orgVos);
        syncVo.setOrgIdList(allOrgIdList);
    }

    private void buildDtoTreeRespDto(SyncOrgVo syncOrgVo, Map<Long, List<SyncOrgVo>> childrenMap) {
        List<SyncOrgVo> children = childrenMap.get(syncOrgVo.getId());
        if (CollectionUtils.isNotEmpty(children)) {
            syncOrgVo.setChildren(children);
            for (SyncOrgVo dto : children) {
                this.buildDtoTreeRespDto(dto, childrenMap);
            }
        }
    }

    private void processOrgFuncTypeRelation(Long orgId, List<String> funcTypeCodes, Long tenantId) {
        OrgFuncTypeRelationEo orgFuncTypeRelationEo;
        if (orgId == null) {
            return;
        }
        if (this.queryOrgModel().booleanValue()) {
            funcTypeCodes = new ArrayList<String>(1);
            funcTypeCodes.add("human_resource");
        } else {
            orgFuncTypeRelationEo = new OrgFuncTypeRelationEo();
            orgFuncTypeRelationEo.setOrgId(orgId);
            orgFuncTypeRelationEo.setTenantId(tenantId);
            orgFuncTypeRelationEo.setFuncTypeCode("human_resource");
            if (this.orgFuncTypeRelationDas.count((BaseEo)orgFuncTypeRelationEo) > 0) {
                logger.info("\u591a\u7ec4\u7ec7\u5305\u542b\u4eba\u529b\u804c\u80fd\uff0c\u4fee\u6539\u804c\u80fd\u7c7b\u578b\u5224\u65ad");
                if (CollectionUtil.isEmpty(funcTypeCodes) || !funcTypeCodes.contains("human_resource")) {
                    this.humanResourceDeleteCheck(tenantId, orgId);
                }
            }
        }
        orgFuncTypeRelationEo = new OrgFuncTypeRelationEo();
        orgFuncTypeRelationEo.setOrgId(orgId);
        orgFuncTypeRelationEo.setTenantId(tenantId);
        this.orgFuncTypeRelationDas.delete((BaseEo)orgFuncTypeRelationEo);
        if (CollectionUtils.isNotEmpty(funcTypeCodes)) {
            ArrayList<OrgFuncTypeRelationEo> insertEos = new ArrayList<OrgFuncTypeRelationEo>();
            for (String funcTypeCode : funcTypeCodes) {
                OrgFuncTypeRelationEo insertEo = new OrgFuncTypeRelationEo();
                insertEo.setOrgId(orgId);
                insertEo.setFuncTypeCode(funcTypeCode);
                insertEo.setExtension("");
                insertEo.setTenantId(tenantId);
                insertEos.add(insertEo);
            }
            this.orgFuncTypeRelationDas.insertBatch(insertEos);
        }
    }

    private void humanResourceDeleteCheck(Long tenantId, Long orgId) {
        OrganizationEo child = new OrganizationEo();
        child.setTenantId(tenantId);
        child.setParentId(orgId);
        if (this.organizationDas.count((BaseEo)child) > 0) {
            throw new BizException("500", "\u8be5\u4e1a\u52a1\u5355\u5143\u5b58\u5728\u5b50\u7ec4\u7ec7\u5355\u5143\uff0c\u4e0d\u53ef\u5220\u9664\u201c\u4eba\u529b\u201d\u804c\u80fd\u3002");
        }
        EmployeeOrgEo employeeOrgEo = new EmployeeOrgEo();
        employeeOrgEo.setTenantId(tenantId);
        employeeOrgEo.setOrganizationId(orgId);
        if (this.employeeOrgDas.count((BaseEo)employeeOrgEo) > 0) {
            throw new BizException("500", "\u8be5\u4e1a\u52a1\u5355\u5143\u5df2\u5173\u8054\u5458\u5de5\uff0c\u4e0d\u53ef\u5220\u9664\u201c\u4eba\u529b\u201d\u804c\u80fd\u3002");
        }
        OrgPostEo orgPostEo = new OrgPostEo();
        orgPostEo.setTenantId(tenantId);
        orgPostEo.setOrgId(orgId);
        if (this.orgPostDas.count((BaseEo)orgPostEo) > 0) {
            throw new BizException("500", "\u8be5\u4e1a\u52a1\u5355\u5143\u5df2\u5173\u8054\u5c97\u4f4d\uff0c\u4e0d\u53ef\u5220\u9664\u201c\u4eba\u529b\u201d\u804c\u80fd\u3002");
        }
    }

    private void processOrgPropValue(Long orgId, List<OrgAdvPropReqDto> orgAdvPropReqDtos, Long tenantId) {
        OrgPropValueEo deleteEo = new OrgPropValueEo();
        deleteEo.setOrgId(orgId);
        deleteEo.setTenantId(tenantId);
        this.orgPropValueDas.logicDelete((BaseEo)deleteEo);
        if (CollectionUtils.isEmpty(orgAdvPropReqDtos)) {
            return;
        }
        ArrayList<OrgPropValueEo> insertEos = new ArrayList<OrgPropValueEo>();
        for (OrgAdvPropReqDto orgAdvPropReqDto : orgAdvPropReqDtos) {
            if (orgAdvPropReqDto.getPropId() == null || CollectionUtils.isEmpty((Collection)orgAdvPropReqDto.getValue())) continue;
            for (String propValue : orgAdvPropReqDto.getValue()) {
                OrgPropValueEo insertEo = new OrgPropValueEo();
                insertEo.setOrgId(orgId);
                insertEo.setPropId(orgAdvPropReqDto.getPropId());
                insertEo.setValue(propValue);
                insertEo.setFuncTypeCode(orgAdvPropReqDto.getFuncTypeCode());
                insertEo.setExtension("");
                insertEo.setTenantId(tenantId);
                insertEos.add(insertEo);
            }
        }
        this.orgPropValueDas.insertBatch(insertEos);
    }

    private void removeOrgFuncTypeRelation(String orgCodes, Long tenantId) {
        if (StringUtils.isBlank((CharSequence)orgCodes)) {
            return;
        }
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)COMPANY_CODE_UNIQUE, (Object)orgCodes));
        OrgFuncTypeRelationEo orgFuncTypeRelationEo = new OrgFuncTypeRelationEo();
        orgFuncTypeRelationEo.setSqlFilters(sqlFilters);
        orgFuncTypeRelationEo.setTenantId(tenantId);
        this.orgFuncTypeRelationDas.delete((BaseEo)orgFuncTypeRelationEo);
    }

    private void removeOrgPropValue(String orgCodes, Long tenantId) {
        if (StringUtils.isBlank((CharSequence)orgCodes)) {
            return;
        }
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)COMPANY_CODE_UNIQUE, (Object)orgCodes));
        OrgPropValueEo deleteEo = new OrgPropValueEo();
        deleteEo.setSqlFilters(sqlFilters);
        deleteEo.setTenantId(tenantId);
        this.orgPropValueDas.logicDelete((BaseEo)deleteEo);
    }

    private List<String> getOrgFuncTypeCodeList(Long orgId, Long tenantId) {
        if (orgId == null) {
            return null;
        }
        OrgFuncTypeRelationEo queryEo = new OrgFuncTypeRelationEo();
        queryEo.setOrgId(orgId);
        queryEo.setTenantId(tenantId);
        List results = this.orgFuncTypeRelationDas.select((BaseEo)queryEo, Integer.valueOf(1), Integer.valueOf(1000));
        if (CollectionUtils.isEmpty((Collection)results)) {
            return null;
        }
        return results.stream().map(StdOrgFuncTypeRelationEo::getFuncTypeCode).distinct().collect(Collectors.toList());
    }

    private String getParentOrgName(Long parentOrgId) {
        if (parentOrgId == null) {
            return null;
        }
        OrganizationEo parentEo = (OrganizationEo)this.organizationDas.selectByPrimaryKey(parentOrgId);
        if (parentEo == null) {
            return null;
        }
        return parentEo.getName();
    }

    private String getOrgEntityName(String entityPropCode) {
        if (StringUtils.isBlank((CharSequence)entityPropCode)) {
            return null;
        }
        Map<String, String> entityCode2Name = this.getOrgEntityName();
        return entityCode2Name.get(entityPropCode);
    }

    private Map<String, String> getOrgEntityName() {
        Map<String, String> entityCode2Name = new HashMap<String, String>();
        PageInfo<OrgEntityPropertyRespDto> pageInfo = this.queryOrgEntityProperty();
        if (null != pageInfo && CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            List entityPropertyRespDtos = pageInfo.getList();
            entityCode2Name = entityPropertyRespDtos.stream().collect(Collectors.toMap(OrgEntityPropertyRespDto::getCode, OrgEntityPropertyRespDto::getValue, (k1, k2) -> k1));
        }
        return entityCode2Name;
    }

    private List<OrgAdvPropRespDto> getOrgPropValueDto(Long orgId, List<String> funcTypeCodes, Long tenantId) {
        List<OrganizationPropRespDto> orgPropDtos = this.organizationPropService.queryEoByFuncType(funcTypeCodes, tenantId);
        if (CollectionUtils.isEmpty(orgPropDtos)) {
            return new ArrayList<OrgAdvPropRespDto>();
        }
        List<OrgPropValueEo> orgPropValueEos = this.getOrgPropValue(orgId, tenantId);
        Map<Object, Object> propCode2Values = new HashMap();
        if (!CollectionUtils.isEmpty(orgPropValueEos)) {
            propCode2Values = orgPropValueEos.stream().collect(Collectors.groupingBy(StdOrgPropValueEo::getPropId, Collectors.mapping(StdOrgPropValueEo::getValue, Collectors.toList())));
        }
        ArrayList<OrgAdvPropRespDto> orgAdvPropRespDtos = new ArrayList<OrgAdvPropRespDto>();
        for (OrganizationPropRespDto propDto : orgPropDtos) {
            OrgAdvPropRespDto propResult = new OrgAdvPropRespDto();
            CubeBeanUtils.copyProperties((Object)propResult, (Object)propDto, (String[])new String[0]);
            List valueResults = new ArrayList();
            if (propCode2Values != null && CollectionUtils.isNotEmpty((Collection)((Collection)propCode2Values.get(propDto.getId())))) {
                valueResults = (List)propCode2Values.get(propDto.getId());
            }
            if (propDto.getEditType().equals(OrgUserConstants.PROP_EDIT_TYPE_FILL) && CollectionUtils.isNotEmpty(valueResults)) {
                propResult.setValue((String)valueResults.get(0));
            } else {
                ArrayList<OrgAdvPropRespDto.OrgAdvPropOption> optionResults = new ArrayList<OrgAdvPropRespDto.OrgAdvPropOption>();
                List options = propDto.getOptions();
                for (OrgPropOptionRespDto option : options) {
                    OrgAdvPropRespDto.OrgAdvPropOption optionResult = new OrgAdvPropRespDto.OrgAdvPropOption();
                    optionResult.setValue(option.getValue());
                    if (CollectionUtils.isNotEmpty(valueResults) && valueResults.contains(option.getValue())) {
                        optionResult.setIsSelected(Integer.valueOf(1));
                    } else {
                        optionResult.setIsSelected(Integer.valueOf(0));
                    }
                    optionResults.add(optionResult);
                }
                propResult.setOrgAdvPropOptions(optionResults);
            }
            orgAdvPropRespDtos.add(propResult);
        }
        return orgAdvPropRespDtos;
    }

    private List<OrgPropValueEo> getOrgPropValue(Long orgId, Long tenantId) {
        if (orgId == null) {
            return null;
        }
        OrgPropValueEo queryEo = new OrgPropValueEo();
        queryEo.setOrgId(orgId);
        queryEo.setTenantId(tenantId);
        return this.orgPropValueDas.select((BaseEo)queryEo, Integer.valueOf(1), Integer.valueOf(3000));
    }

    private Map<String, String> getCompanyOrgCode2Name(Set<String> companyOrgCodes) {
        if (CollectionUtils.isEmpty(companyOrgCodes)) {
            return new HashMap<String, String>();
        }
        companyOrgCodes = companyOrgCodes.stream().filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"org_code", (Object)StringUtils.join(companyOrgCodes, (String)",")));
        OrganizationInfoEo organizationInfoEo = new OrganizationInfoEo();
        organizationInfoEo.setSqlFilters(sqlFilters);
        List results = this.organizationInfoDas.select((BaseEo)organizationInfoEo, Integer.valueOf(1), Integer.valueOf(companyOrgCodes.size()));
        if (CollectionUtils.isEmpty((Collection)results)) {
            return new HashMap<String, String>();
        }
        return results.stream().collect(Collectors.toMap(StdOrganizationInfoEo::getOrgCode, StdOrganizationInfoEo::getOrgName, (k1, k2) -> k1));
    }

    private Map<Long, String> getParentOrgId2Name(Set<Long> orgIds, Long tenantId) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return new HashMap<Long, String>();
        }
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"id", (Object)StringUtils.join(orgIds, (String)",")));
        OrganizationEo organizationEo = new OrganizationEo();
        organizationEo.setSqlFilters(sqlFilters);
        organizationEo.setTenantId(tenantId);
        List results = this.organizationDas.select((BaseEo)organizationEo, Integer.valueOf(1), Integer.valueOf(orgIds.size()));
        if (CollectionUtils.isEmpty((Collection)results)) {
            return new HashMap<Long, String>();
        }
        return results.stream().collect(Collectors.toMap(StdOrganizationEo::getId, StdOrganizationEo::getName, (k1, k2) -> k1));
    }

    private Set<String> getCompanyOrgCodesByName(String companyOrgName, Long tenantId) {
        OrgInfoAdvReqDto orgInfoAdvReqDto = new OrgInfoAdvReqDto();
        orgInfoAdvReqDto.setCompanyOrgName(companyOrgName);
        orgInfoAdvReqDto.setTenantId(tenantId);
        PageInfo<OrgInfoAdvRespDto> dtoPageInfo = this.queryOrgInfo(orgInfoAdvReqDto, 1, 1000);
        if (dtoPageInfo != null && CollectionUtils.isNotEmpty((Collection)dtoPageInfo.getList())) {
            return dtoPageInfo.getList().stream().map(OrgInfoAdvRespDto::getCompanyOrgCode).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        }
        return null;
    }

    private OrgAdvOpRespDto validCompanyCodeAndNameUNIQUE(Integer updateOrgCompanyMsg, String companyCode, String companyName, Long tenantId) {
        if (StringUtils.isBlank((CharSequence)companyCode) && StringUtils.isBlank((CharSequence)companyName)) {
            return new OrgAdvOpRespDto(Integer.valueOf(1), "\u4fdd\u5b58\u6210\u529f");
        }
        boolean codeUnique = true;
        boolean nameUnique = true;
        if (null == updateOrgCompanyMsg || updateOrgCompanyMsg == 0) {
            OrgAdvOpRespDto resultByNameDto;
            int resultCodeByName;
            OrgValidCompanyVo vo;
            OrgAdvOpRespDto resultByCodeDto;
            int resultCodeByCode;
            if (StringUtils.isNotBlank((CharSequence)companyCode) && (resultCodeByCode = (resultByCodeDto = (vo = this.validCompanyMsg(companyCode, companyName, tenantId, COMPANY_CODE_UNIQUE)).getOrgAdvOpRespDto()).getResultCode().intValue()) == 0) {
                nameUnique = false;
            }
            if (StringUtils.isNotBlank((CharSequence)companyName) && (resultCodeByName = (resultByNameDto = (vo = this.validCompanyMsg(companyName, companyCode, tenantId, COMPANY_NAME_UNIQUE)).getOrgAdvOpRespDto()).getResultCode().intValue()) == 0) {
                codeUnique = false;
            }
            int resultCode = 1;
            String resultMsg = "";
            if (!codeUnique && !nameUnique) {
                resultCode = 0;
                resultMsg = this.getResultMsgByCompanySign(COMPANY_CODE_NAME_UNIQUE, companyCode, companyName);
            } else if (codeUnique && !nameUnique) {
                resultCode = 0;
                resultMsg = this.getResultMsgByCompanySign(COMPANY_CODE_UNIQUE, companyCode, companyName);
            } else if (!codeUnique) {
                resultCode = 0;
                resultMsg = this.getResultMsgByCompanySign(COMPANY_NAME_UNIQUE, companyName, companyCode);
            }
            if (resultCode == 0) {
                return new OrgAdvOpRespDto(Integer.valueOf(resultCode), resultMsg);
            }
        } else if (updateOrgCompanyMsg == 1) {
            OrgAdvOpRespDto resultByNameDto;
            OrgValidCompanyVo vo;
            OrgAdvOpRespDto resultByCodeDto;
            Integer resultCode;
            HashSet<Long> orgIdByNameUniqueSet = new HashSet<Long>();
            HashSet<Long> orgIdByCodeUniqueSet = new HashSet<Long>();
            if (StringUtils.isNotBlank((CharSequence)companyCode) && (resultCode = (resultByCodeDto = (vo = this.validCompanyMsg(companyCode, companyName, tenantId, COMPANY_CODE_UNIQUE)).getOrgAdvOpRespDto()).getResultCode()) == 0) {
                nameUnique = false;
                orgIdByNameUniqueSet.addAll(vo.getOrgIdSet());
            }
            if (StringUtils.isNotBlank((CharSequence)companyName) && (resultCode = (resultByNameDto = (vo = this.validCompanyMsg(companyName, companyCode, tenantId, COMPANY_NAME_UNIQUE)).getOrgAdvOpRespDto()).getResultCode()) == 0) {
                codeUnique = false;
                orgIdByCodeUniqueSet.addAll(vo.getOrgIdSet());
            }
            if (!codeUnique && !nameUnique) {
                this.updateCompanyName(orgIdByNameUniqueSet, companyName);
                this.updateCompanyCode(orgIdByCodeUniqueSet, companyCode);
            } else if (codeUnique && !nameUnique) {
                this.updateCompanyName(orgIdByNameUniqueSet, companyName);
            } else if (!codeUnique) {
                this.updateCompanyCode(orgIdByCodeUniqueSet, companyCode);
            }
        }
        return new OrgAdvOpRespDto(Integer.valueOf(1), "\u4fdd\u5b58\u6210\u529f");
    }

    private OrgValidCompanyVo validCompanyMsg(String signName, String comparedSign, Long tenantId, String signType) {
        int resultCode = 1;
        OrgAdvOpRespDto orgAdvOpRespDto = new OrgAdvOpRespDto(Integer.valueOf(resultCode), "");
        if (StringUtils.isBlank((CharSequence)signName) && StringUtils.isBlank((CharSequence)comparedSign)) {
            return new OrgValidCompanyVo(orgAdvOpRespDto, null, null);
        }
        if (StringUtils.isBlank((CharSequence)signName)) {
            throw new BizException("\u4e1a\u52a1\u903b\u8f91\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5");
        }
        boolean resultUnique = true;
        OrgValidCompanyVo vo = this.getByCompanySign(signName, signType, tenantId);
        Set<String> signSet = vo.getSignSet();
        if (CollectionUtils.isNotEmpty(signSet)) {
            if (signSet.size() > 1) {
                resultUnique = false;
            } else if (StringUtils.isBlank((CharSequence)comparedSign)) {
                resultUnique = false;
            } else if (!signSet.contains(comparedSign)) {
                resultUnique = false;
            }
        }
        if (!resultUnique) {
            resultCode = 0;
        }
        orgAdvOpRespDto.setResultCode(Integer.valueOf(resultCode));
        return new OrgValidCompanyVo(orgAdvOpRespDto, signSet, vo.getOrgIdSet());
    }

    private OrgValidCompanyVo getByCompanySign(String signName, String signType, Long tenantId) {
        List results;
        HashSet<String> signSet = new HashSet<String>();
        HashSet<Long> signIdSet = new HashSet<Long>();
        if (COMPANY_CODE_UNIQUE.equals(signType)) {
            results = this.organizationDas.selectOrgCompanyNameUnique(signName, tenantId);
            if (CollectionUtils.isNotEmpty((Collection)results)) {
                for (OrganizationEo eo : results) {
                    signIdSet.add(eo.getId());
                    signSet.add(eo.getCompanyOrgName());
                }
            }
        } else if (COMPANY_NAME_UNIQUE.equals(signType) && CollectionUtils.isNotEmpty((Collection)(results = this.organizationDas.selectOrgCompanyCodeUnique(signName, tenantId)))) {
            for (OrganizationEo eo : results) {
                signIdSet.add(eo.getId());
                signSet.add(eo.getCompanyOrgCode());
            }
        }
        OrgValidCompanyVo orgValidCompanyVo = new OrgValidCompanyVo();
        orgValidCompanyVo.setOrgIdSet(signIdSet);
        orgValidCompanyVo.setSignSet(signSet);
        return orgValidCompanyVo;
    }

    private String getResultMsgByCompanySign(String signType, String signName, String comparedSign) {
        if (COMPANY_CODE_UNIQUE.equals(signType)) {
            return "\u60a8\u66f4\u6539\u4e86\u7ec4\u7ec7\u673a\u6784\u7801[" + signName + "]\u7684\u516c\u53f8\u540d\u79f0\u4e3a[" + comparedSign + "],\u662f\u5426\u5c06\u8fd9\u4e00\u66f4\u6539\u5e94\u7528\u5230\u6240\u6709\u4e1a\u52a1\u5355\u5143\uff1f";
        }
        if (COMPANY_NAME_UNIQUE.equals(signType)) {
            return "\u60a8\u66f4\u6539\u4e86\u516c\u53f8\u540d\u79f0[" + signName + "]\u7684\u7ec4\u7ec7\u673a\u6784\u7801\u4e3a[" + comparedSign + "],\u662f\u5426\u5c06\u8fd9\u4e00\u66f4\u6539\u5e94\u7528\u5230\u6240\u6709\u4e1a\u52a1\u5355\u5143\uff1f";
        }
        if (COMPANY_CODE_NAME_UNIQUE.equals(signType)) {
            return "\u60a8\u66f4\u6539\u4e86\u7ec4\u7ec7\u673a\u6784\u7801[" + signName + "]\u7684\u516c\u53f8\u540d\u79f0\u4e3a[" + comparedSign + "],\u662f\u5426\u5c06\u8fd9\u4e00\u66f4\u6539\u5e94\u7528\u5230\u6240\u6709\u4e1a\u52a1\u5355\u5143\uff1f";
        }
        return "";
    }

    private void updateCompanyName(Set<Long> orgIdSet, String updateNameStr) {
        if (CollectionUtils.isEmpty(orgIdSet)) {
            return;
        }
        for (Long id : orgIdSet) {
            if (id == null) continue;
            OrganizationEo updateEo = new OrganizationEo();
            updateEo.setId(id);
            updateEo.setCompanyOrgName(updateNameStr);
            this.organizationDas.updateSelective((BaseEo)updateEo);
        }
    }

    private void updateCompanyCode(Set<Long> orgIdSet, String updateCodeStr) {
        if (CollectionUtils.isEmpty(orgIdSet)) {
            return;
        }
        for (Long id : orgIdSet) {
            if (id == null) continue;
            OrganizationEo updateEo = new OrganizationEo();
            updateEo.setId(id);
            updateEo.setCompanyOrgCode(updateCodeStr);
            this.organizationDas.updateSelective((BaseEo)updateEo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addBatchOrg(List<OrganizationEo> organizationEoList) {
        if (CollectionUtil.isEmpty(organizationEoList)) {
            throw new BizException("500", "\u7ec4\u7ec7\u5355\u5143\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        Long tenantId = ServiceContext.getContext().getRequestTenantId();
        this.paramCheck(organizationEoList, tenantId);
        ArrayList orgFuncTypeRelationEoList = new ArrayList();
        organizationEoList.forEach(organizationEo -> {
            if (organizationEo.getParentId() == null) {
                organizationEo.setParentId(OrgUserConstants.ORG_ROOT_ID);
            }
            organizationEo.setType("2");
            organizationEo.setEntityPropCode("department");
            organizationEo.setTenantId(tenantId);
            organizationEo.setExtension("");
            OrgFuncTypeRelationEo insertEo = new OrgFuncTypeRelationEo();
            insertEo.setOrgId(organizationEo.getId());
            insertEo.setFuncTypeCode("human_resource");
            insertEo.setExtension("");
            insertEo.setTenantId(tenantId);
            orgFuncTypeRelationEoList.add(insertEo);
        });
        this.organizationDas.insertBatch(organizationEoList);
        this.orgFuncTypeRelationDas.insertBatch(orgFuncTypeRelationEoList);
    }

    @Override
    public List<OrgAdvDetailRespDto> queryUserId(Long userId) {
        return null;
    }

    @Override
    public OrgAdvInfoRespDto queryOrgAdvInfoByCreditCode(String creditCode, Long tenantId, Long instanceId) {
        Long newInstanceId;
        Long newTenantId = this.getTenantId(tenantId);
        OrganizationInfoEo organizationInfoEo = this.organizationInfoDas.queryByCreditCode(creditCode, newTenantId, newInstanceId = this.getInstanceId(instanceId));
        if (Objects.isNull(organizationInfoEo)) {
            return null;
        }
        OrgAdvInfoRespDto orgAdvInfoRespDto = new OrgAdvInfoRespDto();
        DtoHelper.eo2Dto((BaseEo)organizationInfoEo, (BaseVo)orgAdvInfoRespDto);
        OrganizationEo organizationEo = this.organizationDas.queryByCode(organizationInfoEo.getOrgCode(), newTenantId);
        if (Objects.nonNull(organizationEo)) {
            orgAdvInfoRespDto.setOrgId(organizationEo.getId());
        }
        return orgAdvInfoRespDto;
    }

    private void paramCheck(List<OrganizationEo> organizationEoList, Long tenantId) {
        Set codeSet = organizationEoList.stream().filter(e -> StrUtil.isNotBlank((CharSequence)e.getCode())).map(StdOrganizationEo::getCode).collect(Collectors.toSet());
        Set nameSet = organizationEoList.stream().filter(e -> StrUtil.isNotBlank((CharSequence)e.getName())).map(StdOrganizationEo::getName).collect(Collectors.toSet());
        if (codeSet.size() < organizationEoList.size()) {
            throw new BizException("500", "\u7ec4\u7ec7\u5355\u5143\u7f16\u7801\u91cd\u590d\uff01");
        }
        OrganizationEo codeQueryEo = new OrganizationEo();
        codeQueryEo.setTenantId(tenantId);
        codeQueryEo.setSqlFilters(Collections.singletonList(SqlFilter.in((String)COMPANY_CODE_UNIQUE, codeSet)));
        if (this.organizationDas.count((BaseEo)codeQueryEo) > 0) {
            throw new BizException("500", "\u7ec4\u7ec7\u5355\u5143\u7f16\u7801\u5df2\u5b58\u5728\uff01");
        }
        if (nameSet.size() < organizationEoList.size()) {
            throw new BizException("500", "\u7ec4\u7ec7\u5355\u5143\u540d\u79f0\u91cd\u590d\uff01");
        }
        OrganizationEo nameQueryEo = new OrganizationEo();
        nameQueryEo.setTenantId(tenantId);
        nameQueryEo.setSqlFilters(Collections.singletonList(SqlFilter.in((String)COMPANY_NAME_UNIQUE, (Object)nameQueryEo)));
        if (this.organizationDas.count((BaseEo)nameQueryEo) > 0) {
            throw new BizException("500", "\u7ec4\u7ec7\u5355\u5143\u540d\u79f0\u5df2\u5b58\u5728\uff01");
        }
    }
}

