/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.user.api.dto.CustomerOrgInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.CustomerOrgInfoQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.exception.UserExceptionCode;
import com.dtyunxi.yundt.cube.center.user.biz.service.IOrganizationEventService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IOrganizationInfoService;
import com.dtyunxi.yundt.cube.center.user.biz.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.dao.das.OrganizationInfoDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.UserDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.OrganizationInfoEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.UserEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrganizationInfoServiceImpl
implements IOrganizationInfoService {
    private Logger logger = LoggerFactory.getLogger(OrganizationInfoServiceImpl.class);
    @Resource
    private IContext context;
    @Resource
    private UserDas userDas;
    @Resource
    private OrganizationInfoDas organizationInfoDao;
    @Resource
    private IOrganizationEventService organizationEventService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addOrgInfo(Long userId, OrganizationInfoDto organizationInfoDto) {
        UserEo user = (UserEo)this.userDas.selectByPrimaryKey(userId);
        if (user != null) {
            OrganizationInfoEo organizationInfoEo = this.organizationInfoDao.findByUserId(userId);
            if (organizationInfoEo == null) {
                organizationInfoEo = new OrganizationInfoEo();
                DtoHelper.dto2Eo((BaseVo)organizationInfoDto, (BaseEo)organizationInfoEo);
                organizationInfoEo.setUserId(userId);
                this.organizationInfoDao.insert((BaseEo)organizationInfoEo);
                this.organizationEventService.pushEvent(null, organizationInfoEo, "ADD");
                return organizationInfoEo.getId();
            }
            this.logger.error("\u7528\u6237\u5bf9\u5e94\u7684\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\u5df2\u5b58\u5728");
            throw new BizException(UserExceptionCode.ORGANIZATIONINFO_EXIST_FAIL.getCode(), UserExceptionCode.ORGANIZATIONINFO_EXIST_FAIL.getMsg());
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long updateOrgInfo(Long userId, OrganizationInfoDto organizationInfoDto) {
        UserEo user = (UserEo)this.userDas.selectByPrimaryKey(userId);
        AssertUtil.isTrue((user != null ? 1 : 0) != 0, (String)"\u7528\u6237\u4e0d\u5b58\u5728");
        if (user != null) {
            AssertUtil.isTrue((organizationInfoDto.getId() != null ? 1 : 0) != 0, (String)"organizationInfoDto \u7684 id\u4e0d\u80fd\u4e3a\u7a7a");
            OrganizationInfoEo organizationInfoEo = (OrganizationInfoEo)this.organizationInfoDao.selectByPrimaryKey(organizationInfoDto.getId());
            if (organizationInfoEo == null) {
                this.logger.error("\u7528\u6237\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u5b58\u5728");
                throw new BizException(UserExceptionCode.ORGANIZATIONINFO_NON_EXIST_FAIL.getCode(), UserExceptionCode.ORGANIZATIONINFO_NON_EXIST_FAIL.getMsg());
            }
            DtoHelper.dto2Eo((BaseVo)organizationInfoDto, (BaseEo)organizationInfoEo, (String[])new String[]{"tenantId", "instanceId"});
            this.organizationInfoDao.update((BaseEo)organizationInfoEo);
            this.organizationEventService.pushEvent(null, organizationInfoEo, "UPDATE");
            return organizationInfoDto.getId();
        }
        return null;
    }

    @Override
    public OrganizationInfoDto queryByOrgInfoId(Long orgInfoId) {
        OrganizationInfoEo organizationInfoEo = (OrganizationInfoEo)this.organizationInfoDao.selectByPrimaryKey(orgInfoId);
        OrganizationInfoDto organizationInfoDto = null;
        if (organizationInfoEo != null) {
            organizationInfoDto = new OrganizationInfoDto();
            organizationInfoDto.setUserId(organizationInfoEo.getUserId());
            DtoHelper.eo2Dto((BaseEo)organizationInfoEo, (BaseVo)organizationInfoDto);
        }
        return organizationInfoDto;
    }

    @Override
    public PageInfo<OrganizationInfoDto> queryByOrgInfoExample(OrganizationInfoDto organizationInfoDto, Integer pageNumber, Integer pageSize) {
        AssertUtil.isTrue((null != organizationInfoDto ? 1 : 0) != 0, (String)"organizationInfoDto \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        OrganizationInfoEo organizationInfoEo = new OrganizationInfoEo();
        DtoHelper.dto2Eo((BaseVo)organizationInfoDto, (BaseEo)organizationInfoEo);
        PageInfo page = this.organizationInfoDao.selectPage((BaseEo)organizationInfoEo, pageNumber, pageSize);
        ArrayList list = Lists.newArrayList();
        PageInfo pageInfo = new PageInfo((List)list);
        DtoHelper.eoList2DtoList((Collection)page.getList(), (Collection)list, OrganizationInfoDto.class);
        return pageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addCustomerOrgInfo(CustomerOrgInfoDto customerOrgInfoDto) {
        OrganizationInfoEo organizationInfoEo = new OrganizationInfoEo();
        DtoHelper.dto2Eo((BaseVo)customerOrgInfoDto, (BaseEo)organizationInfoEo);
        this.organizationInfoDao.insert((BaseEo)organizationInfoEo);
        try {
            this.organizationEventService.pushEvent(null, organizationInfoEo, "ADD");
        }
        catch (Exception e) {
            this.logger.info("\u65b0\u589e\u7ec4\u7ec7\u4fe1\u606f\u53d1\u9001\u9886\u57df\u4e8b\u4ef6\u5931\u8d25!\u7ec4\u7ec7\u7f16\u7801: {},\u9519\u8bef\u4fe1\u606f: {}", (Object)organizationInfoEo.getOrgCode(), (Object)e.getMessage());
        }
        return organizationInfoEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int updateCustomerOrgInfo(CustomerOrgInfoDto customerOrgInfoDto) {
        OrganizationInfoEo organizationInfoEo = (OrganizationInfoEo)this.organizationInfoDao.selectByPrimaryKey(customerOrgInfoDto.getId());
        if (organizationInfoEo == null) {
            throw new BizException("\u5ba2\u6237\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        DtoHelper.dto2Eo((BaseVo)customerOrgInfoDto, (BaseEo)organizationInfoEo);
        int rows = this.organizationInfoDao.update((BaseEo)organizationInfoEo);
        try {
            this.organizationEventService.pushEvent(null, organizationInfoEo, "UPDATE");
        }
        catch (Exception e) {
            this.logger.info("\u66f4\u65b0\u7ec4\u7ec7\u4fe1\u606f\u53d1\u9001\u9886\u57df\u4e8b\u4ef6\u5931\u8d25!\u7ec4\u7ec7\u7f16\u7801: {},\u9519\u8bef\u4fe1\u606f: {}", (Object)organizationInfoEo.getOrgCode(), (Object)e.getMessage());
        }
        return rows;
    }

    @Override
    public CustomerOrgInfoDto queryCustomerOrgInfoById(Long id) {
        OrganizationInfoEo organizationInfoEo = (OrganizationInfoEo)this.organizationInfoDao.selectByPrimaryKey(id);
        CustomerOrgInfoDto customerOrgInfoDto = null;
        if (organizationInfoEo != null) {
            customerOrgInfoDto = new CustomerOrgInfoDto();
            customerOrgInfoDto.setUserId(organizationInfoEo.getUserId());
            DtoHelper.eo2Dto((BaseEo)organizationInfoEo, (BaseVo)customerOrgInfoDto);
        }
        return customerOrgInfoDto;
    }

    @Override
    public PageInfo<CustomerOrgInfoDto> queryCustomerOrgInfoPage(CustomerOrgInfoQueryReqDto customerOrgInfoQueryReqDto, Integer pageNum, Integer pageSize) {
        OrganizationInfoEo organizationInfoEo = new OrganizationInfoEo();
        DtoHelper.dto2Eo((BaseVo)customerOrgInfoQueryReqDto, (BaseEo)organizationInfoEo);
        Long tenantId = this.getTenantId(customerOrgInfoQueryReqDto.getTenantId());
        organizationInfoEo.setTenantId(tenantId);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (StringUtils.isNotBlank((CharSequence)customerOrgInfoQueryReqDto.getOrgCode())) {
            organizationInfoEo.setOrgCode(null);
            sqlFilters.add(SqlFilter.like((String)"org_code", (Object)("%" + customerOrgInfoQueryReqDto.getOrgCode() + "%")));
        }
        if (StringUtils.isNotBlank((CharSequence)customerOrgInfoQueryReqDto.getOrgName())) {
            organizationInfoEo.setOrgName(null);
            sqlFilters.add(SqlFilter.like((String)"org_name", (Object)("%" + customerOrgInfoQueryReqDto.getOrgName() + "%")));
        }
        organizationInfoEo.setSqlFilters(sqlFilters);
        if (CollectionUtils.isNotEmpty((Collection)customerOrgInfoQueryReqDto.getIdList())) {
            organizationInfoEo.setId(null);
            sqlFilters.add(SqlFilter.in((String)"id", (Object)StringUtils.join((Iterable)customerOrgInfoQueryReqDto.getIdList(), (String)",")));
        }
        if (CollectionUtils.isNotEmpty((Collection)customerOrgInfoQueryReqDto.getUserIdList())) {
            organizationInfoEo.setUserId(null);
            sqlFilters.add(SqlFilter.in((String)"user_id", (Object)StringUtils.join((Iterable)customerOrgInfoQueryReqDto.getUserIdList(), (String)",")));
        }
        PageInfo eoPageInfo = this.organizationInfoDao.selectPage((BaseEo)organizationInfoEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        ArrayList<CustomerOrgInfoDto> customerOrgInfoDtos = new ArrayList<CustomerOrgInfoDto>();
        if (eoPageInfo != null && CollectionUtils.isNotEmpty((Collection)eoPageInfo.getList())) {
            CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            for (OrganizationInfoEo eo : eoPageInfo.getList()) {
                CustomerOrgInfoDto dto = new CustomerOrgInfoDto();
                DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)dto);
                customerOrgInfoDtos.add(dto);
            }
        }
        dtoPageInfo.setList(customerOrgInfoDtos);
        return dtoPageInfo;
    }

    private Long getTenantId(Long tenantId) {
        return tenantId == null ? this.context.tenantId() : tenantId;
    }
}

