/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.dao.das;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.user.dao.das.base.AbstractBaseDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.OrganizationEo;
import com.dtyunxi.yundt.cube.center.user.dao.mapper.OrganizationMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@Repository
public class OrganizationDas
extends AbstractBaseDas<OrganizationEo, Long> {
    @Resource
    private OrganizationMapper organizationMapper;

    public OrganizationEo findRootByInstanceId(Long instanceId) {
        OrganizationMapper organizationMapper = (OrganizationMapper)this.getMapper();
        return organizationMapper.findRootByInstanceId(instanceId);
    }

    public OrganizationEo findRoot() {
        OrganizationMapper organizationMapper = (OrganizationMapper)this.getMapper();
        return organizationMapper.findRoot();
    }

    public List<OrganizationEo> findByParentId(Long organizationId) {
        OrganizationEo organizationEo = new OrganizationEo();
        organizationEo.setParentId(organizationId);
        return this.select((BaseEo)organizationEo);
    }

    public List<OrganizationEo> findByEmployeeId(Long employeeId) {
        OrganizationMapper organizationMapper = (OrganizationMapper)this.getMapper();
        return organizationMapper.findByEmployeeId(employeeId);
    }

    public List<OrganizationEo> findOrganizationTreeByParentId(Long parentId) {
        OrganizationMapper organizationMapper = (OrganizationMapper)this.getMapper();
        return organizationMapper.findOrganizationTreeByParentId(parentId);
    }

    public List<OrganizationEo> findRootByTenantId(Long tenantId) {
        OrganizationMapper organizationMapper = (OrganizationMapper)this.getMapper();
        return organizationMapper.findRootByTenantId(tenantId);
    }

    public List<OrganizationEo> findByParentIds(List<Long> ids) {
        if (CollectionUtils.isNotEmpty(ids)) {
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"parent_id", (Object)StringUtils.join(ids, (String)",")));
            OrganizationEo eo = new OrganizationEo();
            eo.setSqlFilters(sqlFilters);
            return this.select((BaseEo)eo);
        }
        return null;
    }

    public List<OrganizationEo> findByIds(List<Long> ids) {
        if (CollectionUtils.isNotEmpty(ids)) {
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"id", (Object)StringUtils.join(ids, (String)",")));
            OrganizationEo eo = new OrganizationEo();
            eo.setSqlFilters(sqlFilters);
            return this.select((BaseEo)eo);
        }
        return null;
    }

    public OrganizationEo queryByCode(String orgCode, Long tenantId) {
        OrganizationEo queryEo = new OrganizationEo();
        queryEo.setCode(orgCode);
        queryEo.setTenantId(tenantId);
        List results = this.select((BaseEo)queryEo, 1, 1);
        if (CollectionUtils.isEmpty((Collection)results)) {
            return null;
        }
        return (OrganizationEo)results.get(0);
    }

    public OrganizationEo queryByCodeAndInstanceId(String orgCode, Long instanceId) {
        List results;
        OrganizationEo queryEo = new OrganizationEo();
        queryEo.setCode(orgCode);
        if (instanceId != null) {
            queryEo.setInstanceId(instanceId);
        }
        if (CollectionUtils.isEmpty((Collection)(results = this.select((BaseEo)queryEo, 1, 1)))) {
            return null;
        }
        return (OrganizationEo)results.get(0);
    }

    public List<OrganizationEo> queryByCodes(List<String> orgCodes, Long tenantId) {
        OrganizationEo queryEo = new OrganizationEo();
        queryEo.setTenantId(tenantId);
        queryEo.setSqlFilters(Collections.singletonList(SqlFilter.in((String)"code", orgCodes)));
        return this.select((BaseEo)queryEo, 1, 100);
    }

    public List<OrganizationEo> queryByCodeList(List<String> orgCodes, Long instanceId) {
        OrganizationEo queryEo = new OrganizationEo();
        if (instanceId != null) {
            queryEo.setInstanceId(instanceId);
        }
        queryEo.setSqlFilters(Collections.singletonList(SqlFilter.in((String)"code", orgCodes)));
        return this.select((BaseEo)queryEo, 1, 100);
    }

    public List<OrganizationEo> selectOrgCompanyNameUnique(String companyOrgCode, Long tenantId) {
        OrganizationEo queryEo = new OrganizationEo();
        queryEo.setCompanyOrgCode(companyOrgCode);
        queryEo.setTenantId(tenantId);
        return this.select((BaseEo)queryEo, 1, 5000);
    }

    public List<OrganizationEo> selectOrgCompanyCodeUnique(String companyOrgName, Long tenantId) {
        OrganizationEo queryEo = new OrganizationEo();
        queryEo.setCompanyOrgName(companyOrgName);
        queryEo.setTenantId(tenantId);
        return this.select((BaseEo)queryEo, 1, 5000);
    }

    public OrganizationEo queryByName(String name, Long tenantId) {
        OrganizationEo queryEo = new OrganizationEo();
        queryEo.setName(name);
        queryEo.setTenantId(tenantId);
        List results = this.select((BaseEo)queryEo, 1, 1);
        if (CollectionUtils.isEmpty((Collection)results)) {
            return null;
        }
        return (OrganizationEo)results.get(0);
    }

    public int queryByNameI1(String nameI1, Long tenantId) {
        OrganizationEo queryEo = new OrganizationEo();
        queryEo.setNameI1(nameI1);
        queryEo.setTenantId(tenantId);
        return this.count((BaseEo)queryEo);
    }

    public boolean existByName(String code, String name, Long tenantId) {
        OrganizationEo queryEo = new OrganizationEo();
        queryEo.setName(name);
        queryEo.setTenantId(tenantId);
        queryEo.setSqlFilters(Collections.singletonList(SqlFilter.ne((String)"code", (Object)code)));
        return this.count((BaseEo)queryEo) > 0;
    }

    public boolean existByNameI1(Long id, String nameI1, Long tenantId) {
        OrganizationEo queryEo = new OrganizationEo();
        queryEo.setNameI1(nameI1);
        queryEo.setTenantId(tenantId);
        queryEo.setSqlFilters(Collections.singletonList(SqlFilter.ne((String)"id", (Object)id)));
        return this.count((BaseEo)queryEo) > 0;
    }

    public List<OrganizationEo> queryBizOrg(String funcTypeCode, Long tenantId) {
        return this.organizationMapper.queryBizOrg(funcTypeCode, tenantId);
    }

    public List<OrganizationEo> queryAdditionOrgs(Long orgGroupId, Long tenantId) {
        return this.organizationMapper.queryAdditionOrgs(orgGroupId, tenantId);
    }

    public List<OrganizationEo> queryAllForTree(Long tenantId) {
        return this.organizationMapper.queryAllForTree(tenantId);
    }

    public List<OrganizationEo> selectByIds(List<Long> orgIdList) {
        OrganizationEo organizationEo = new OrganizationEo();
        organizationEo.setSqlFilters(Collections.singletonList(SqlFilter.in((String)"id", orgIdList)));
        return this.selectList((BaseEo)organizationEo, 1, orgIdList.size());
    }
}

