package com.dtyunxi.yundt.cube.center.func.api;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.dto.ApiBatchDto;
import com.dtyunxi.yundt.cube.center.data.dto.ErrorCodeDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BindApiReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.ShelfStatusReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.UnBindApiReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@Api(tags = {"基础数据中心：功能包能力地图：API服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-data-api-IApi",
        name = "${yundt.cube.center.data.api.name:yundt-cube-center-data}", path = "/v1/api", url = "${yundt.cube.center.data.api:}")
public interface IApi {

    /**
     * 上下架 API
     *
     * @param statusReqDto
     * @return
     */
    @PutMapping("/shelf")
    @ApiOperation(value = "上下架API", notes = "上下架API")
    @Capability(capabilityCode = "basicdata.api.on-shelf")
    RestResponse<Void> onShelf(@RequestBody ShelfStatusReqDto statusReqDto);

    /**
     * 新增场景关联API
     *
     * @param bindApReqDto
     * @return
     */
    @PutMapping("/bind")
    @ApiOperation(value = "新增场景关联API", notes = "新增场景关联API")
    @Capability(capabilityCode = "basicdata.api.bind")
    RestResponse<Void> bind(@RequestBody BindApiReqDto bindApReqDto);

    /**
     * 删除场景关联API
     *
     * @param unBindApiReqDto
     * @return
     */
    @PutMapping("/unbind")
    @ApiOperation(value = "删除场景关联API", notes = "删除场景关联API")
    @Capability(capabilityCode = "basicdata.api.un-bind")
    RestResponse<Void> unBind(@RequestBody UnBindApiReqDto unBindApiReqDto);

    /**
     * 批量导入api信息 废弃，建议使用功能包上报扫描
     *
     * @param apiBatchDto
     * @return
     */
    @Deprecated
    @PostMapping("/api/batch")
    @ApiOperation(value = "批量导入api信息 废弃，建议使用功能包上报扫描", notes = "批量导入api信息 废弃，建议使用功能包上报扫描")
    @Capability(capabilityCode = "basicdata.api.add-api-batch")
    RestResponse<Void> addApiBatch(@RequestBody ApiBatchDto apiBatchDto);

    /**
     * 批量导入错误码信息
     *
     * @param errorCodeDtos
     * @return
     */
    @PostMapping("/error-code/batch")
    @ApiOperation(value = "批量导入错误码信息", notes = "批量导入错误码信息")
    @Capability(capabilityCode = "basicdata.api.add-error-code-batch")
    RestResponse<Void> addErrorCodeBatch(@RequestBody List<ErrorCodeDto> errorCodeDtos);

}
