package com.dtyunxi.yundt.cube.center.func.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.AppInstApiReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
* 应用模板和API关联关系服务接口
*
* @author 代码生成器
*/
@Api(tags = {"基础数据中心：应用模板和API关联关系"})
@FeignClient( contextId = "com-dtyunxi-yundt-cube-center-data-func-api-IAppInstApiApi",
        name = "${yundt.cube.center.data.api.name:yundt-cube-center-data}", path = "/v1/app-inst-api",
        url = "${yundt.cube.center.data.api:}")

public interface IAppInstApiApi {

    /**
    * 新增应用模板和API关联关系
    *
    * @param addReqDto 应用模板和API关联关系表请求对象
    * @return 处理结果
    */
    @PostMapping("")
    @ApiOperation(value = "新增应用模板和API关联关系", notes = "新增应用模板和API关联关系")
    RestResponse<Long> addAppInstApi(@RequestBody AppInstApiReqDto addReqDto);

    /**
     * 批量新增应用模板和API关联关系，如果数据库中存在了与插入数据相同的appCode,path,method,domain的记录，则先将数据库中的数据删除后
     * 再进行插入
     * @param appInstApiReqDtoList  应用模板和API关联关系
     * @return 无
     */
    @PostMapping("/add-batch")
    @ApiOperation(value = "批量新增应用模板和API关联关系，如果数据库中存在了与插入数据相同的appCode,path,method,domain，" +
            "则先将数据库中的数据删除后，再进行插入",
            notes = "批量新增应用模板和API关联关系，如果数据库中存在了与插入数据相同的appCode,path,method,domain，" +
                    "则先将数据库中的数据删除后，再进行插入")
    RestResponse<Void> addBatchAppInstApi(@RequestBody List<AppInstApiReqDto> appInstApiReqDtoList);

    /**
    * 修改应用模板和API关联关系
    *
    * @param modifyReqDto 应用模板和API关联关系表请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改应用模板和API关联关系", notes = "修改应用模板和API关联关系")
    RestResponse<Void> modifyAppInstApi(@RequestBody AppInstApiReqDto modifyReqDto);

    /**
    * 删除应用模板和API关联关系
    *
    * @param id        应用模板和API关联关系表删除数据ID
    * @return 处理结果
    */
    @DeleteMapping("/{id}")
    @ApiOperation(value = "删除应用模板和API关联关系", notes = "删除应用模板和API关联关系")
    RestResponse<Void> removeAppInstApi(@PathVariable("id") Long id);
}
