package com.dtyunxi.yundt.cube.center.func.api;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.CapabilityCreateReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.CapabilityModifyReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.CapabilityRemoveReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
 * 能力信息服务接口
 *
 * @author shuangqing
 */
@Api(tags = {"基础数据中心：功能包能力地图：能力信息服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-func-api-ICapabilityApi",
        name = "${yundt.cube.center.data.api.name:yundt-cube-center-data}", path = "/v1/capability", url = "${yundt.cube.center.data.api:}")
public interface ICapabilityApi {

    /**
     * 新增能力信息
     *
     * @param capabilityCreateReqDto 新增能力请求参数
     * @return 能力编码
     */
    @PostMapping("")
    @ApiOperation(value = "新增能力信息", notes = "新增能力信息")
    @Capability(capabilityCode = "basicdata.capability.create-capability")
    RestResponse<String> createCapability(@RequestBody @Valid CapabilityCreateReqDto capabilityCreateReqDto);

    /**
     * 修改能力信息
     *
     * @param capabilityModifyReqDto 修改能力请求参数
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改能力信息", notes = "修改能力信息")
    @Capability(capabilityCode = "basicdata.capability.modify-capability")
    RestResponse<Void> modifyCapability(@RequestBody @Valid CapabilityModifyReqDto capabilityModifyReqDto);

    /**
     * 删除能力信息
     *
     * @param capabilityRemoveReqDto 删除能力请求参数
     * @return 处理结果
     */
    @DeleteMapping("")
    @ApiOperation(value = "删除能力信息", notes = "删除能力信息")
    @Capability(capabilityCode = "basicdata.capability.remove-capability")
    RestResponse<Void> removeCapability(@SpringQueryMap CapabilityRemoveReqDto capabilityRemoveReqDto);
}
