package com.dtyunxi.yundt.cube.center.func.api;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

/**
 * 通用服务接口
 *
 * @author : 萧玄
 * @GENERIC P 主键类型
 * @GENERIC EDIT_REQ 对象新增/编辑类型
 * @GENERIC DETAIL 对象详情返回类型
 * @Date : 14:50 2019/6/19
 */
public interface ICommonApi<P, EDIT_REQ> {

    @PostMapping
    @ResponseBody
    @ApiOperation(value = "新增", notes = "新增")
    @Capability(capabilityCode = "basicdata.common.add")
    RestResponse<P> add(@RequestBody EDIT_REQ event);

    @PutMapping("/{id}/enable")
    @ResponseBody
    @ApiOperation(value = "启用", notes = "启用")
    @Capability(capabilityCode = "basicdata.common.enable")
    RestResponse<Void> enable(@PathVariable(value = "id") P id);

    @PutMapping("/{id}/disable")
    @ResponseBody
    @ApiOperation(value = "禁用", notes = "禁用")
    @Capability(capabilityCode = "basicdata.common.disable")
    RestResponse<Void> disable(@PathVariable(value = "id") P id);

    @DeleteMapping("/{id}")
    @ResponseBody
    @ApiOperation(value = "删除", notes = "删除")
    @Capability(capabilityCode = "basicdata.common.delete")
    RestResponse<Void> delete(@PathVariable(value = "id") P id);


    @PutMapping("/{id}")
    @ResponseBody
    @ApiOperation(value = "编辑", notes = "编辑")
    @Capability(capabilityCode = "basicdata.common.edit")
    RestResponse<Void> edit(@PathVariable(value = "id") P id, @RequestBody EDIT_REQ dto);
}
