package com.dtyunxi.yundt.cube.center.func.api.constants;

import java.util.HashMap;
import java.util.Map;

public enum ExtensionSelectType {

    /**
     * 单实现生效
     */
    SINGLE_SELECT(0),

    /**
     * 链式实现生效
     */
    MULTI_PARALLEL(1),
    /**
     * 并行实现生效
     */
    Multi_SERIAL(2);

    private static final Map<Integer, ExtensionSelectType> codeMapping = new HashMap<>();

    static {
        for (ExtensionSelectType type : values()) {
            codeMapping.put(type.code, type);
        }
    }

    private final int code;

    ExtensionSelectType(int code) {
        this.code = code;
    }

    public static ExtensionSelectType fromCode(int code) {
        return codeMapping.get(code);
    }

    public int getCode() {
        return code;
    }

}