/**
 * @(#) SysParamConstants.java 1.0 2019-10-31
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.constants;

import java.util.HashMap;
import java.util.Map;

/**
 * @author 黑马
 * @since 1.0.0
 */


public enum ParamValueType {


    /**
     * 文本
     */
    TEXT(0),

    /**
     * 整型
     */
    INTEGER(1),

    /**
     * 布尔
     */
    BOOLEAN(2),

    /**
     * 日期时间
     */
    DATE(3),

    /**
     * 浮点
     */
    DECIMAL(4);

    private static final Map<Integer, ParamValueType> codeMapping = new HashMap<>();

    static {
        for (ParamValueType type : values()) {
            codeMapping.put(type.code, type);
        }
    }

    private final int code;

    ParamValueType(int code) {
        this.code = code;
    }

    public static ParamValueType fromCode(int code) {
        return codeMapping.get(code);
    }

    public int getCode() {
        return code;
    }

}


