/**
 * @(#) SysParamConstants.java 1.0 2019-10-31
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.constants;

import java.util.HashMap;
import java.util.Map;

/**
 * 配置项级别
 *
 * @author shuangqing
 * @since 1.0.0
 */
public enum SettingDisplayLevel {


    /**
     * 全局
     */
    GLOBAL(0),

    /**
     * 租户
     */
    TENANT(1),

    /**
     * 业务空间
     */
    BIZSPACE(2),

    /**
     * 业务身份
     */
    BIZID(3);


    private static final Map<Integer, SettingDisplayLevel> codeMapping = new HashMap<>();

    static {
        for (SettingDisplayLevel type : values()) {
            codeMapping.put(type.code, type);
        }
    }

    private final int code;

    SettingDisplayLevel(int code) {
        this.code = code;
    }

    public static SettingDisplayLevel fromCode(int code) {
        return codeMapping.get(code);
    }

    public int getCode() {
        return code;
    }

}


