/**
 * @(#)SettingOptionBaseDto 1.0 2020/3/5
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.dto.base;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.Max;
import javax.validation.constraints.Size;

/**
 * @author shuangqing  2020/3/5
 */
@ApiModel(value = "SettingOptionBaseDto", description = "配置项选项基本参数")
public class SettingOptionBaseDto extends BaseReqDto {
    /**
     * 配置项选项编码，唯一标识当前配置项选项；保存 配置项 选用的option时, 存储本字段的值, 这样name和value的修改不影响已经选定的选项
     */
    @Max(value = 512, message = "选项编码长度不能超过512个字符")
    @ApiModelProperty(value = "配置项选项编码，唯一标识当前配置项选项；保存 配置项 选用的option时, 存储本字段的值, 这样name和value的修改不影响已经选定的选项")
    private String code;

    /**
     * 显示值
     */
    @Size(max = 50, message = "显示值长度不能超过50个字符")
    @ApiModelProperty(value = "显示值")
    private String name;

    /**
     * 存储值
     */
    @Max(value = 512, message = "存储值长度不能超过512个字符")
    @ApiModelProperty(value = "存储值")
    private String optionValue;

    /**
     * 表示当前选项的存储值是否是默认值，0 表示否 ；1 表示 是
     */
    @ApiModelProperty(value = "表示当前选项的存储值是否是默认值，0 表示否 ；1 表示 是")
    private Integer isDefault;

    /**
     * 简介
     */
    @Size(max = 200, message = "简介长度不能超过200个字符")
    @ApiModelProperty(value = "简介")
    private String descr;

    /**
     * 来源功能包编码
     */
    @ApiModelProperty(value = "来源功能包编码")
    private String bundleCode;

    /**
     * 排序号
     */
    @ApiModelProperty(value = "排序号")
    private Integer sort;

    /**
     * 记录当前配置项来源的版本
     */
    @ApiModelProperty(value = "记录当前配置项来源的版本")
    private String version;

    /**
     * 记录当前配置项来源的jar包
     */
    @ApiModelProperty(value = "记录当前配置项来源的jar包")
    private String source;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOptionValue() {
        return optionValue;
    }

    public void setOptionValue(String optionValue) {
        this.optionValue = optionValue;
    }

    public Integer getIsDefault() {
        return isDefault;
    }

    public void setIsDefault(Integer isDefault) {
        this.isDefault = isDefault;
    }

    public String getDescr() {
        return descr;
    }

    public void setDescr(String descr) {
        this.descr = descr;
    }

    public String getBundleCode() {
        return bundleCode;
    }

    public void setBundleCode(String bundleCode) {
        this.bundleCode = bundleCode;
    }

    public Integer getSort() {
        return sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }
}
