package com.dtyunxi.yundt.cube.center.func.api.dto.conf;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 业务配置可选项
 */
@ApiModel(value = "BizConfOption", description = "业务配置可选项")
public class BizConfOption implements Serializable {
    /**
     * 可选项的值
     */
    @ApiModelProperty(value = "配置项的可选值, 最终逻辑运行时读取到的内容")
    String value;
    /**
     * 可选项的描述
     */
    @ApiModelProperty(value = "可选值的简单说明, 用于方便运营人员查看业务含义")
    String label;
    /**
     * 可选值的说明
     */
    @ApiModelProperty(value = "可选值的详细说明")
    String desc;

    /**
     * 生成option
     *
     * @param value 最终的值
     * @param label 显示的中文信息
     * @param desc  desc
     * @return option
     */
    public static BizConfOption build(String value, String label, String desc) {
        BizConfOption option = new BizConfOption();
        option.desc = desc;
        option.label = label;
        option.value = value;
        return option;
    }

    public String getValue() {
        return value;
    }

    public BizConfOption setValue(String value) {
        this.value = value;
        return this;
    }

    public String getLabel() {
        return label;
    }

    public BizConfOption setLabel(String label) {
        this.label = label;
        return this;
    }

    public String getDesc() {
        return desc;
    }

    public BizConfOption setDesc(String desc) {
        this.desc = desc;
        return this;
    }
}
