package com.dtyunxi.yundt.cube.center.func.api.dto.conf;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 业务配置项查询响应
 */
@ApiModel(value = "BizConfQueryResp", description = "业务配置项查询响应")
public class BizConfQueryResp implements Serializable {
    /**
     * 配置项代码
     */
    @ApiModelProperty(value = "配置项的代码")
    String confCode;
    /**
     * 配置项的可选项
     */
    @ApiModelProperty(value = "配置项的可选项, 如果配置项不存在或者可选项为空,都返回空列表")
    List<BizConfOption> options;

    public static BizConfQueryResp empty(String code) {
        BizConfQueryResp resp = new BizConfQueryResp();
        resp.confCode = code;
        resp.options = new ArrayList<>();
        return resp;
    }

    public String getConfCode() {
        return confCode;
    }

    public BizConfQueryResp setConfCode(String confCode) {
        this.confCode = confCode;
        return this;
    }

    public List<BizConfOption> getOptions() {
        return options;
    }

    public BizConfQueryResp setOptions(List<BizConfOption> options) {
        this.options = options;
        return this;
    }
}
