package com.dtyunxi.yundt.cube.center.func.api.dto.conf;

import com.dtyunxi.cube.starter.extension.BizIdContext;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.LinkedHashSet;
import java.util.Set;

/**
 * 配置项批量查询请求
 */
@ApiModel(value = "BizConfigBatchQueryReq", description = "配置项批量查询请求")
public class BizConfigBatchQueryReq {
    /**
     * 配置项的代码
     */
    @ApiModelProperty(value = "配置项的编码,不区分业务参数/扩展点")
    private LinkedHashSet<String> codes;

    private String bizObjs;
    /**
     * 业务参数识别标记
     */
    @ApiModelProperty(value = "业务身份识别信息,可为null")
    private BizIdContext bizIdContext;

    public Set<String> getCodes() {
        return codes;
    }

    public BizConfigBatchQueryReq setCodes(LinkedHashSet<String> codes) {
        this.codes = codes;
        return this;
    }

    public String getBizObjs() {
        return bizObjs;
    }

    public BizConfigBatchQueryReq setBizObjs(String bizObjs) {
        this.bizObjs = bizObjs;
        return this;
    }

    public BizIdContext getBizIdContext() {
        return bizIdContext;
    }

    public BizConfigBatchQueryReq setBizIdContext(BizIdContext bizIdContext) {
        this.bizIdContext = bizIdContext;
        return this;
    }
}
