/**
 * @(#)AbilityQueryReqDto 1.0 2019/11/25
 * <p>
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

/**
 * @author shuangqing  2019/11/25
 */
@ApiModel(value = "AbilityConfigReqDto", description = "能力关联的配置项信息查询对象")
public class AbilityConfigReqDto extends BaseReqDto {

    /**
     * 编码
     */
    @Pattern(regexp = "^\\w{1,200}$", message = "能力编码只能为字母，下划线，数字组合且长度不能超过200个字符")
    @NotNull
    @ApiModelProperty(value = "能力编码")
    private String code;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}
