package com.dtyunxi.yundt.cube.center.func.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * 修改能力分类信息，包含领域信息、场景信息Eo对象
 *
 * @author shuangqing
 */
@ApiModel(value = "AbilityGroupModifyReqDto", description = "修改能力分类信息，包含领域信息、场景信息Eo对象")
public class AbilityGroupModifyReqDto extends BaseReqDto {

    /**
     * 编码
     */
    @NotNull
    @ApiModelProperty(value = "编码", required = true)
    private String code;

    /**
     * 1 领域 2 场景
     */
    @NotNull(message = "type不能为null")
    @ApiModelProperty(value = "1 领域 2 场景", required = true)
    private Integer type;

    /**
     * 名称
     */
    @ApiModelProperty(value = "名称")
    private String name;

    /**
     * 0 禁用  1启用
     */
    @ApiModelProperty(value = "0 禁用  1启用  默认启用")
    private Integer status;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;


    /**
     * 排序
     */
    @ApiModelProperty(value = "排序")
    private Integer sort;


    public void setCode(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getType() {
        return this.type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getRemark() {
        return this.remark;
    }

    public Integer getSort() {
        return sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }
}