package com.dtyunxi.yundt.cube.center.func.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * 查询能力分类信息，包含领域信息、场景信息Eo对象
 *
 * @author shuangqing
 */
@ApiModel(value = "AbilityGroupQueryReqDto", description = "查询请求dto能力分类信息，包含领域信息、场景信息Eo对象")
public class AbilityGroupQueryReqDto extends BaseReqDto {

    /**
     * 编码
     */
    @NotNull
    @ApiModelProperty(value = "编码", required = true)
    private String code;


    /**
     * 1 领域 2 场景
     */
    @NotNull
    @ApiModelProperty(value = "1 领域 2 场景", required = true)
    private Integer type;


    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }
}