package com.dtyunxi.yundt.cube.center.func.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * 删除能力分类信息，包含领域信息、场景信息Eo对象
 *
 * @author shuangqing
 */
@ApiModel(value = "AbilityGroupRemoveReqDto", description = "删除能力分类信息，包含领域信息、场景信息Eo对象")
public class AbilityGroupRemoveReqDto extends BaseReqDto {

    /**
     * 编码
     */
    @NotNull
    @ApiModelProperty(value = "编码", required = true)
    private String code;

    /**
     * 1 领域 2 场景
     */
    @NotNull(message = "type不能为null")
    @ApiModelProperty(value = "1 领域 2 场景", required = true)
    private Integer type;

    public void setCode(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getType() {
        return this.type;
    }


}