/**
 * @(#)AbilityGroupUpDto 1.0 2019/12/4
 * <p>
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.dto.request;


import com.dtyunxi.yundt.cube.center.func.api.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * @author shuangqing  2019/12/4
 */
@ApiModel(value = "AbilityGroupSortDto", description = "上移、下移、置顶、置底能力分类请求dto")
public class AbilityGroupSortDto extends BaseDto {

    @ApiModelProperty(value = "能力分类code", required = true)
    @NotNull
    private String abilityGroupCode;

    @ApiModelProperty(value = "类型：1 领域  2 场景", required = true)
    @NotNull
    private Integer type;

    @ApiModelProperty(value = "移动类型： BOTTOM：置底，INCR：升序，DECR：降序，TOP：置顶", required = true)
    @NotNull
    private String sortType;

    public String getAbilityGroupCode() {
        return abilityGroupCode;
    }

    public void setAbilityGroupCode(String abilityGroupCode) {
        this.abilityGroupCode = abilityGroupCode;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getSortType() {
        return sortType;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }
}
