package com.dtyunxi.yundt.cube.center.func.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.util.List;

/**
 * 能力信息修改对象
 *
 * @author 代码生成器
 */
@ApiModel(value = "AbilityModifyReqDto", description = "能力信息修改对象")
public class AbilityModifyReqDto extends BaseReqDto {

    /**
     * 编码
     */
    @NotNull(message = "编码不能为null")
    @Pattern(regexp = "^\\w{1,200}$", message = "能力编码只能为字母，下划线，数字组合且长度不能超过200个字符")
    @ApiModelProperty(value = "编码", required = true)
    private String code;

    /**
     * 0 禁用  1启用
     */
    @ApiModelProperty(value = "0 禁用  1启用")
    private Integer status;

    /**
     * 名称
     */
    @ApiModelProperty(value = "名称")
    private String name;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;


    @ApiModelProperty(value = "关联列表，已废弃，不再处理")
    private List<String> sceneCodes;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getRemark() {
        return this.remark;
    }

    public List<String> getSceneCodes() {
        return sceneCodes;
    }

    public void setSceneCodes(List<String> sceneCodes) {
        this.sceneCodes = sceneCodes;
    }
}