/**
 * @(#)AbilityQueryReqDto 1.0 2019/11/25
 * <p>
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.Pattern;

/**
 * @author shuangqing  2019/11/25
 */
@ApiModel(value = "AbilityQueryReqDto", description = "能力信息查询对象")
public class AbilityQueryReqDto extends BaseReqDto {

    /**
     * 编码
     */
    @Pattern(regexp = "^\\w{1,200}$", message = "能力编码只能为字母，下划线，数字组合且长度不能超过200个字符")
    @ApiModelProperty(value = "编码")
    private String code;

    /**
     * 名称
     */
    @Pattern(regexp = "^[\\u4E00-\\u9FA5\\w]{1,50}$", message = "能力编码只能为字母，下划线，数字，中文组合且长度不能超过50个字符")
    @ApiModelProperty(value = "名称")
    private String name;

    /**
     * 0 禁用  1启用
     */
    @ApiModelProperty(value = "0 禁用  1启用")
    private Integer status;

    @Deprecated
    @ApiModelProperty(value = "关联列表，已废弃，不做处理")
    private String sceneCodes;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getSceneCodes() {
        return sceneCodes;
    }

    public void setSceneCodes(String sceneCodes) {
        this.sceneCodes = sceneCodes;
    }
}
