/**
 * @(#) AppInstanceDtoQueryReqDto.java 1.0 2020-05-07
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.func.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * 应用授权DTO清单查询dto
 *
 * @author 仪琳
 * @since 1.0.0
 */
@ApiModel(value = "AppInstanceDtoQueryReqDto", description = "应用授权DTO清单查询dto")
public class AppInstanceDtoQueryReqDto {
    /**
     * 应用id
     */
    @NotNull
    @ApiModelProperty(value = "应用id")
    private Long appInstanceId;

    /**
     * API id
     */
    @NotNull
    @ApiModelProperty(value = "API id")
    private Long apiId;

    public Long getAppInstanceId() {
        return appInstanceId;
    }

    public void setAppInstanceId(Long appInstanceId) {
        this.appInstanceId = appInstanceId;
    }

    public Long getApiId() {
        return apiId;
    }

    public void setApiId(Long apiId) {
        this.apiId = apiId;
    }
}
