package com.dtyunxi.yundt.cube.center.func.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 业务扩展点信息新增请求dto
 *
 * @author shuangqing
 */
@ApiModel(value = "BizExtensionCreateReqDto", description = "业务扩展点信息新增请求dto")
public class BizExtensionCreateReqDto extends BaseReqDto {

    /**
     * 扩展点代码
     */
//    @NotNull(message = "编码不能为空")
//    @Size(min = 1, max = 200, message = "编码长度不能超过200个字符")
//    @Pattern(regexp = "([a-zA-Z][a-zA-Z\\d_]*\\.)*[a-zA-Z_][a-zA-Z\\d_]*", message = "编码只能字母开头，只支持字母，数字，下划线，点号组合字符")
    @ApiModelProperty(value = "扩展点代码")
    private String bextCode;

    /**
     * 扩展点简称
     */
//    @NotNull
    @ApiModelProperty(value = "扩展点简称")
    private String bextName;

    /**
     * 扩展点简介
     */
    @ApiModelProperty(value = "扩展点简介")
    private String bextDesc;

    /**
     * 扩展点类型 1: 单实现生效  2:并行实现生效
     */
    @ApiModelProperty(value = "扩展点类型 0: 单实现生效 1：链式实现生效 2:并行实现生效")
    private Integer bextType;

    /**
     * 级别(0:全局 1:租户 2:应用)
     */
    @ApiModelProperty(value = "级别(0:全局 1:租户 2:应用)")
    private Integer grade;

    /**
     * 依赖来源
     */
    @ApiModelProperty(value = "依赖来源")
    private String source;

    /**
     * 优先级
     */
    @ApiModelProperty(value = "优先级")
    private Integer priority;

    /**
     * 影响的应用系统
     * 扩展点可能影响的系统,多个有英文半角逗号分隔
     */
    @ApiModelProperty(value = "影响的应用系统扩展点可能影响的系统,多个有英文半角逗号分隔")
    private String effectApps;

    /**
     * 当前版本
     */
    @ApiModelProperty(value = "当前版本")
    private String curVer;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;

    /**
     * 配置项选项请求dto列表
     */
    @ApiModelProperty(value = "配置项选项请求dto列表")
    List<BizExtensionImplReqDto> bizExtensionImplReqDtos;

    /**
     * 能力编码
     */
    @ApiModelProperty(value = "能力编码")
    private String capabilityCode;

    /**
     * 能力编码
     */
    @ApiModelProperty(value = "能力编码,不要用这个，已废弃")
    private List<String> abilityCodes;

    public String getCapabilityCode() {
        return capabilityCode;
    }

    public void setCapabilityCode(String capabilityCode) {
        this.capabilityCode = capabilityCode;
    }

    public List<String> getAbilityCodes() {
        return abilityCodes;
    }

    public void setAbilityCodes(List<String> abilityCodes) {
        this.abilityCodes = abilityCodes;
    }

    public Integer getGrade() {
        return grade;
    }

    public void setGrade(Integer grade) {
        this.grade = grade;
    }

    public void setBextCode(String bextCode) {
        this.bextCode = bextCode;
    }

    public String getBextCode() {
        return this.bextCode;
    }

    public void setBextName(String bextName) {
        this.bextName = bextName;
    }

    public String getBextName() {
        return this.bextName;
    }

    public void setBextDesc(String bextDesc) {
        this.bextDesc = bextDesc;
    }

    public String getBextDesc() {
        return this.bextDesc;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public void setBextType(Integer bextType) {
        this.bextType = bextType;
    }

    public Integer getBextType() {
        return this.bextType;
    }

    public void setEffectApps(String effectApps) {
        this.effectApps = effectApps;
    }

    public String getEffectApps() {
        return this.effectApps;
    }

    public void setCurVer(String curVer) {
        this.curVer = curVer;
    }

    public String getCurVer() {
        return this.curVer;
    }

    public List<BizExtensionImplReqDto> getBizExtensionImplReqDtos() {
        return bizExtensionImplReqDtos;
    }

    public void setBizExtensionImplReqDtos(List<BizExtensionImplReqDto> bizExtensionImplReqDtos) {
        this.bizExtensionImplReqDtos = bizExtensionImplReqDtos;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public Integer getPriority() {
        return priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }
}