/**
 * @(#)BizExtensionImplReqDto 1.0 2019/11/9
 * <p>
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

/**
 * @author shuangqing  2019/11/9
 */
@ApiModel(value = "BizExtensionImplModifyDto", description = "扩展点实现修改dto")
public class BizExtensionImplModifyDto extends BaseReqDto {


    /**
     * 扩展点实现code
     */
    @NotNull(message = "编码不能为空")
    @Size(min = 1, max = 200, message = "编码长度不能超过200个字符")
    @Pattern(regexp = "([a-zA-Z][a-zA-Z\\d_]*\\.)*[a-zA-Z_][a-zA-Z\\d_]*", message = "编码只能字母开头，只支持字母，数字，下划线，点号组合字符")
    @ApiModelProperty(value = "扩展点实现code")
    private String bextImplCode;

    /**
     * 扩展点实现简称
     */
    @ApiModelProperty(value = "扩展点实现简称")
    private String bextImplName;

    /**
     * 扩展点实现描述
     */
    @ApiModelProperty(value = "扩展点实现描述")
    private String bextImplDesc;


    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;


    public String getBextImplCode() {
        return bextImplCode;
    }

    public void setBextImplCode(String bextImplCode) {
        this.bextImplCode = bextImplCode;
    }

    public String getBextImplName() {
        return bextImplName;
    }

    public void setBextImplName(String bextImplName) {
        this.bextImplName = bextImplName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getBextImplDesc() {
        return bextImplDesc;
    }

    public void setBextImplDesc(String bextImplDesc) {
        this.bextImplDesc = bextImplDesc;
    }
}
