/**
 * @(#)BizExtensionImplReqDto 1.0 2019/11/9
 * <p>
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author shuangqing  2019/11/9
 */
@ApiModel(value = "BizExtensionImplReqDto", description = "扩展点实现请求dto")
public class BizExtensionImplReqDto extends BaseReqDto {
    /**
     * 扩展点实现代码
     */
//    @NotNull(message = "编码不能为空")
//    @Size(min = 1, max = 200, message = "编码长度不能超过200个字符")
//    @Pattern(regexp = "([a-zA-Z][a-zA-Z\\d_]*\\.)*[a-zA-Z_][a-zA-Z\\d_]*", message = "编码只能字母开头，只支持字母，数字，下划线，点号组合字符")
    @ApiModelProperty(value = "扩展点实现代码")
    private String bextImplCode;

    /**
     * 扩展点实现简称
     */
    @ApiModelProperty(value = "扩展点实现简称")
    private String bextImplName;

    /**
     * 扩展点实现描述
     */
    @ApiModelProperty(value = "扩展点实现描述")
    private String bextImplDesc;

    /**
     * 影响的应用系统
     * 扩展点可能影响的系统,多个有英文半角逗号分隔
     */
    @ApiModelProperty(value = "影响的应用系统: 扩展点可能影响的系统,多个有英文半角逗号分隔")
    private String effectApps;

    /**
     * 当前版本
     */
    @ApiModelProperty(value = "当前版本")
    private String curVer;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getBextImplCode() {
        return bextImplCode;
    }

    public void setBextImplCode(String bextImplCode) {
        this.bextImplCode = bextImplCode;
    }

    public String getBextImplName() {
        return bextImplName;
    }

    public void setBextImplName(String bextImplName) {
        this.bextImplName = bextImplName;
    }

    public String getBextImplDesc() {
        return bextImplDesc;
    }

    public void setBextImplDesc(String bextImplDesc) {
        this.bextImplDesc = bextImplDesc;
    }

    public String getEffectApps() {
        return effectApps;
    }

    public void setEffectApps(String effectApps) {
        this.effectApps = effectApps;
    }

    public String getCurVer() {
        return curVer;
    }

    public void setCurVer(String curVer) {
        this.curVer = curVer;
    }
}
