/**
 * @(#)BizExtensionImplScanReqDto 1.0 2019/11/8
 * <p>
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * @author shuangqing  2019/11/8
 */
@ApiModel(value = "BizExtensionImplScanReqDto", description = "扩展点实现类扫描json文件请求dto")
public class BizExtensionImplScanReqDto extends BaseReqDto {

    /**
     * 扩展点代码
     */
    @ApiModelProperty(value = "扩展点代码")
    private String bextCode;

    /**
     * 扩展点实现代码
     */
    @ApiModelProperty(value = "扩展点实现代码")
    private String bextImplCode;

    /**
     * 扩展点实现描述
     */
    @ApiModelProperty(value = "扩展点实现描述")
    private String bextImplDesc;

    /**
     * 影响的应用系统
     * 扩展点可能影响的系统,多个有英文半角逗号分隔
     */
    @ApiModelProperty(value = "影响的应用系统: 扩展点可能影响的系统,多个有英文半角逗号分隔")
    private String effectApps;

    /**
     * 当前版本
     */
    @ApiModelProperty(value = "当前版本")
    private String curVer;

    /**
     * '当前版本注册时间
     */
    @ApiModelProperty(value = "当前版本注册时间")
    private Date curVerReleaseTime;

    public String getBextCode() {
        return bextCode;
    }

    public void setBextCode(String bextCode) {
        this.bextCode = bextCode;
    }

    public String getBextImplCode() {
        return bextImplCode;
    }

    public void setBextImplCode(String bextImplCode) {
        this.bextImplCode = bextImplCode;
    }

    public String getBextImplDesc() {
        return bextImplDesc;
    }

    public void setBextImplDesc(String bextImplDesc) {
        this.bextImplDesc = bextImplDesc;
    }

    public String getEffectApps() {
        return effectApps;
    }

    public void setEffectApps(String effectApps) {
        this.effectApps = effectApps;
    }

    public String getCurVer() {
        return curVer;
    }

    public void setCurVer(String curVer) {
        this.curVer = curVer;
    }

    public Date getCurVerReleaseTime() {
        return curVerReleaseTime;
    }

    public void setCurVerReleaseTime(Date curVerReleaseTime) {
        this.curVerReleaseTime = curVerReleaseTime;
    }
}
