/**
 * @(#)BizExtensionScanReqDto 1.0 2019/11/7
 * <p>
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;
import java.util.List;

/**
 * @author shuangqing  2019/11/7
 */
@ApiModel(value = "BizExtensionScanReqDto", description = "扩展点扫描json文件请求dto")
public class BizExtensionScanReqDto extends BaseReqDto {

    /**
     * 扩展点代码
     */
    @ApiModelProperty(value = "扩展点代码")
    private String bextCode;

    /**
     * 扩展点简称
     */
    @ApiModelProperty(value = "扩展点简称")
    private String bextName;

    /**
     * 扩展点简介
     */
    @ApiModelProperty(value = "扩展点简介")
    private String bextDesc;

    /**
     * 扩展点类型
     * 1: 单实现生效  2:并行实现生效
     */
    @ApiModelProperty(value = "扩展点类型 1: 单实现生效  2:并行实现生效")
    private Integer bextType;

    /**
     * 优先级
     */
    @ApiModelProperty(value = "优先级")
    private Integer priority;

    /**
     * 依赖来源
     */
    @ApiModelProperty(value = "依赖来源")
    private String source;

    /**
     * 影响的应用系统
     * 扩展点可能影响的系统,多个有英文半角逗号分隔
     */
    @ApiModelProperty(value = "影响的应用系统: 扩展点可能影响的系统,多个有英文半角逗号分隔")
    private String effectApps;

    /**
     * 当前版本
     */
    @ApiModelProperty(value = "当前版本")
    private String curVer;

    /**
     * '当前版本注册时间
     */
    @ApiModelProperty(value = "当前版本注册时间")
    private Date curVerReleaseTime;

    @ApiModelProperty(value = "扩展点实现类扫描json文件请求dto列表")
    private List<BizExtensionImplScanReqDto> bizExtensionImplScanReqDtos;

    public String getBextCode() {
        return bextCode;
    }

    public void setBextCode(String bextCode) {
        this.bextCode = bextCode;
    }

    public String getBextName() {
        return bextName;
    }

    public void setBextName(String bextName) {
        this.bextName = bextName;
    }

    public String getBextDesc() {
        return bextDesc;
    }

    public void setBextDesc(String bextDesc) {
        this.bextDesc = bextDesc;
    }

    public Integer getBextType() {
        return bextType;
    }

    public void setBextType(Integer bextType) {
        this.bextType = bextType;
    }

    public Integer getPriority() {
        return priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getEffectApps() {
        return effectApps;
    }

    public void setEffectApps(String effectApps) {
        this.effectApps = effectApps;
    }

    public String getCurVer() {
        return curVer;
    }

    public void setCurVer(String curVer) {
        this.curVer = curVer;
    }

    public Date getCurVerReleaseTime() {
        return curVerReleaseTime;
    }

    public void setCurVerReleaseTime(Date curVerReleaseTime) {
        this.curVerReleaseTime = curVerReleaseTime;
    }

    public List<BizExtensionImplScanReqDto> getBizExtensionImplScanReqDtos() {
        return bizExtensionImplScanReqDtos;
    }

    public void setBizExtensionImplScanReqDtos(List<BizExtensionImplScanReqDto> bizExtensionImplScanReqDtos) {
        this.bizExtensionImplScanReqDtos = bizExtensionImplScanReqDtos;
    }
}
