/**
 * @(#)BizSpaceCreateReqDto 1.0 2019/11/21
 * <p>
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * @author : 萧玄
 * @Date: 15:26 2019/12/4
 */
@ApiModel(value = "BizRuleReqDto", description = "新增业务规则参数对象")
public class BizRuleReqDto extends BizRuleBasicReqDto {

    /**
     * 业务身份编码
     */
    @NotNull(message = "业务身份编码不能为空")
    @ApiModelProperty(value = "业务身份编码", required = true)
    private String bizIdentityCode;

    /**
     * 业务空间编码
     */
    @NotNull(message = "业务空间编码不能为空")
    @ApiModelProperty(value = "业务空间编码", required = true)
    private String bizSpaceCode;

    public String getBizIdentityCode() {
        return bizIdentityCode;
    }

    public void setBizIdentityCode(String bizIdentityCode) {
        this.bizIdentityCode = bizIdentityCode;
    }

    public String getBizSpaceCode() {
        return bizSpaceCode;
    }

    public void setBizSpaceCode(String bizSpaceCode) {
        this.bizSpaceCode = bizSpaceCode;
    }
}