/**
 * @(#) BizSpaceAbilityGroupReqDto.java 1.0 2019-12-05
 * <p>
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.func.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * 业务空间场景请求Dto
 *
 * @author 仪琳
 * @since 1.0.0
 */
@ApiModel(value = "BizSpaceAbilityGroupReqDto", description = "业务空间场景请求Dto")
public class BizSpaceAbilityGroupReqDto extends RequestDto {
    /**
     * 业务空间编码
     */
    @NotNull
    @ApiModelProperty(value = "业务空间编码", required = true)
    private String code;

    /**
     * 1 领域 2 场景，默认查询场景
     */
    @ApiModelProperty(value = "1 领域 2 场景，默认查询场景")
    private Integer type;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }
}
