/**
 * @(#) BizSpaceConfigValueReqDto.java 1.0 2019-12-05
 * <p>
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.func.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * 设置业务空间关联的配置项的值请求Dto
 *
 * @author 仪琳
 * @since 1.0.0
 */
@ApiModel(value = "BizSpaceConfigValueReqDto", description = "设置业务空间关联的配置项的值请求Dto")
public class BizSpaceConfigValueReqDto extends BaseReqDto {

    @ApiModelProperty(value = "编码，必填,如果是扩展点(type=2),就填扩展点实现的编码")
    @NotNull
    private String code;

    @ApiModelProperty(value = "父编码，必填, 如果是扩展点(type=2),就填扩展点编码")
    @NotNull
    private String parentCode;

    @ApiModelProperty(value = "类型，1 参数，2扩展点，必填")
    @NotNull
    private Integer type;

    @ApiModelProperty(value = "参数值，当参数type=1且选择类型selectType=0输入时必填,如果是扩展点(type=2),此参数无效")
    private String value;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getParentCode() {
        return parentCode;
    }

    public void setParentCode(String parentCode) {
        this.parentCode = parentCode;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}
