/**
 * @(#) BundleApiQueryReqDto.java 1.0 2020-04-17
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.func.api.dto.request;

import com.dtyunxi.yundt.cube.center.func.api.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotEmpty;

/**
 * 功能包API清单查询dto
 *
 * @author 仪琳
 * @since 1.0.0
 */
@ApiModel(value = "BundleApiQueryReqDto", description = "功能包API清单查询dto")
public class BundleApiQueryReqDto extends BaseDto {

    @NotEmpty(message = "功能包编码不能为空")
    @ApiModelProperty(value = "功能包编码")
    private String bundleCode;

    @ApiModelProperty(value = "功能包版本")
    private String bundleVersion;

    /**
     * api名称
     */
    @ApiModelProperty(value = "API名称")
    private String apiName;

    /**
     * API路径
     */
    @ApiModelProperty(value = "URL")
    private String path;

    /**
     * 请求方式
     */
    @ApiModelProperty(value = "请求方式： POST 、PUT、DELETE、GET ")
    private String method;

    /**
     * 中心编码
     */
    @ApiModelProperty(value = "所属领域编码，多个用英文逗号分隔")
    private String moduleCode;

    @ApiModelProperty(value = "所属一级能力编码，多个用英文逗号分隔")
    private String firstCapabilityCode;

    public String getBundleCode() {
        return bundleCode;
    }

    public void setBundleCode(String bundleCode) {
        this.bundleCode = bundleCode;
    }

    public String getBundleVersion() {
        return bundleVersion;
    }

    public void setBundleVersion(String bundleVersion) {
        this.bundleVersion = bundleVersion;
    }

    public String getApiName() {
        return apiName;
    }

    public void setApiName(String apiName) {
        this.apiName = apiName;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getMethod() {
        return method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getModuleCode() {
        return moduleCode;
    }

    public void setModuleCode(String moduleCode) {
        this.moduleCode = moduleCode;
    }

    public String getFirstCapabilityCode() {
        return firstCapabilityCode;
    }

    public void setFirstCapabilityCode(String firstCapabilityCode) {
        this.firstCapabilityCode = firstCapabilityCode;
    }
}
