/**
 * @(#)CapabilityQueryReqDto 1.0 2020/2/28
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 根据条件查询能力下配置项的请求参数
 *
 * @author shuangqing  2020/2/28
 */
@ApiModel(value = "CapabilitySettingQueryReqDto", description = "根据条件查询能力下配置项的请求参数")
public class CapabilitySettingQueryReqDto extends BaseVo {

    /**
     * 能力编码
     */
    @ApiModelProperty(value = "能力编码")
    private String capabilityCode;

    /**
     * 配置项编码
     */
    @ApiModelProperty(value = "配置项编码")
    private String code;

    /**
     * 配置项名称
     */
    @ApiModelProperty(value = "配置项名称")
    private String name;

    /**
     * 配置项的值编辑方式
     */
    @ApiModelProperty(value = "配置项的值编辑方式")
    private Integer editType;

    /**
     * 配置项的值类型
     */
    @ApiModelProperty(value = "配置项的值类型")
    private Integer valueType;

    /**
     * 配置项的来源功能包编码
     */
    @ApiModelProperty(value = "配置项的来源功能包编码")
    private String bundle;

    public String getCapabilityCode() {
        return capabilityCode;
    }

    public void setCapabilityCode(String capabilityCode) {
        this.capabilityCode = capabilityCode;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getEditType() {
        return editType;
    }

    public void setEditType(Integer editType) {
        this.editType = editType;
    }

    public Integer getValueType() {
        return valueType;
    }

    public void setValueType(Integer valueType) {
        this.valueType = valueType;
    }

    public String getBundle() {
        return bundle;
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }
}
