/**
 * @(#)CapabilityTreeQueryReqDto 1.0 2020/2/28
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 获取能力树的查询请求参数
 *
 * @author shuangqing  2020/2/28
 */
@ApiModel(value = "CapabilityTreeQueryReqDto", description = "获取能力树的查询请求参数")
public class CapabilityTreeQueryReqDto extends BaseVo {

    /**
     * 领域编码
     */
    @ApiModelProperty(value = "领域编码")
    private String domainCode;
    /**
     * 领域名称
     */
    @ApiModelProperty(value = "领域名称")
    private String domainName;

    /**
     * 能力编码
     */
    @ApiModelProperty(value = "能力编码")
    private String capabilityCode;

    /**
     * 能力名称
     */
    @ApiModelProperty(value = "能力名称")
    private String capabilityName;

    /**
     * 是否只展示一级能力，true:是
     */
    @ApiModelProperty(value = "是否只展示一级能力，true:是")
    private boolean firstCapabilityOnly;

    public String getDomainCode() {
        return domainCode;
    }

    public void setDomainCode(String domainCode) {
        this.domainCode = domainCode;
    }

    public String getCapabilityCode() {
        return capabilityCode;
    }

    public void setCapabilityCode(String capabilityCode) {
        this.capabilityCode = capabilityCode;
    }

    public String getDomainName() {
        return domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getCapabilityName() {
        return capabilityName;
    }

    public void setCapabilityName(String capabilityName) {
        this.capabilityName = capabilityName;
    }

    public boolean isFirstCapabilityOnly() {
        return firstCapabilityOnly;
    }

    public void setFirstCapabilityOnly(boolean firstCapabilityOnly) {
        this.firstCapabilityOnly = firstCapabilityOnly;
    }
}
