package com.dtyunxi.yundt.cube.center.func.api.dto.request;

import java.util.List;

/**
 * 树中的某个节点
 */
public interface ITreeNode<T> extends Comparable<ITreeNode> {

    /**
     * 获取节点的唯一标记
     *
     * @return 节点标记
     */
    String getKey();

    /**
     * 获取节点的上级节点的唯一标记
     *
     * @return 上级节点标记
     */
    String getParentKey();

    /**
     * 判断是否为根节点，根节点的标识可能是getParentKey为null，""，-1，或者其他内容
     * 支持自定义根节点的标识
     *
     * @return true表示根节点
     */
    Boolean isRootNode();

    /**
     * 增加一个子节点
     *
     * @param child 待增加的子节点
     */
    void addChild(T child);

    /**
     * 获取所有子节点
     *
     * @return 所有子节点, 叶子节点此方法返回空列表
     */
    List<T> getChildren();

    /**
     * 如果List<ITreeNode>为null，则构造empty列表，用于构建树时插入子节点
     */
    void setChildren(List<T> children);

    /**
     * 默认按照节点标识进行升序排序
     *
     * @param node 节点
     * @return 参考String.compareTo()返回值说明
     */
    @Override
    default int compareTo(ITreeNode node) {
        return this.getKey().compareTo(node.getKey());
    }
}