/**
 * @(#)SettingCreateReqDto 1.0 2020/3/2
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.dto.request;

import com.dtyunxi.yundt.cube.center.data.dto.TabularDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.base.SettingBaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * @author shuangqing  2020/3/2
 */
@ApiModel(value = "SettingModifyReqDto", description = "修改配置项请求dto")
public class SettingModifyReqDto extends SettingBaseDto {

    /**
     * 配置项选项列表，只有值编辑类型editType = 2 （选择），该options才有值
     */
    @ApiModelProperty(value = "配置项选项列表，只有值编辑类型editType = 2 （选择），该options才有值")
    private List<SettingOptionReqDto> options;


    @ApiModelProperty(value = "表格类型的配置项的值")
    private TabularDto tabularViewDto;

    public List<SettingOptionReqDto> getOptions() {
        return options;
    }

    public void setOptions(List<SettingOptionReqDto> options) {
        this.options = options;
    }

    public TabularDto getTabularViewDto() {
        return tabularViewDto;
    }

    public void setTabularViewDto(TabularDto tabularViewDto) {
        this.tabularViewDto = tabularViewDto;
    }
}
