/**
 * @(#)SettingOptionReqDto 1.0 2020/3/2
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.dto.request;

import com.dtyunxi.yundt.cube.center.func.api.dto.base.SettingOptionBaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 新增配置项选项请求参数
 *
 * @author shuangqing  2020/3/2
 */
@ApiModel(value = "SettingOptionImportDto", description = "新增配置项选项请求参数")
public class SettingOptionImportDto extends SettingOptionBaseDto {

    /**
     * 配置项编码
     */
    @ApiModelProperty(value = "配置项编码")
    private String settingCode;

    /**
     * 记录当前配置项来源的项目分组
     */
    @ApiModelProperty(value = "记录当前配置项来源的项目分组")
    private String groupId;

    /**
     * 记录当前配置项来源的项目名称
     */
    @ApiModelProperty(value = "记录当前配置项来源的项目名称")
    private String artifactId;

    public String getGroupId() {
        return groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getSettingCode() {
        return settingCode;
    }

    public void setSettingCode(String settingCode) {
        this.settingCode = settingCode;
    }
}
