/**
 * @(#)ViewSettingReqDto 1.0 2020/3/21
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.dto.request;

import com.dtyunxi.yundt.cube.center.func.api.dto.base.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 查询视图可设定配置项的请求对象
 *
 * @author shuangqing  2020/3/21
 */
@ApiModel(value = "ViewSettingQueryReqDto", description = "配置视图请求对象")
public class SettingValueQueryReqDto extends BaseReqDto {

    /**
     * 视图id
     */
    @ApiModelProperty(value = "视图id")
    private Long viewId;

    /**
     * 业务空间编码
     */
    @ApiModelProperty(value = "业务空间编码")
    private String bizSpaceCode;

    /**
     * 业务身份编码
     */
    @ApiModelProperty(value = "业务身份编码")
    private String bizIdCode;

    /**
     * 一级能力编码
     */
    @ApiModelProperty(value = "一级能力编码")
    private String firstCapabilityCode;

    public String getFirstCapabilityCode() {
        return firstCapabilityCode;
    }

    public void setFirstCapabilityCode(String firstCapabilityCode) {
        this.firstCapabilityCode = firstCapabilityCode;
    }

    public Long getViewId() {
        return viewId;
    }

    public void setViewId(Long viewId) {
        this.viewId = viewId;
    }

    public String getBizSpaceCode() {
        return bizSpaceCode;
    }

    public void setBizSpaceCode(String bizSpaceCode) {
        this.bizSpaceCode = bizSpaceCode;
    }

    public String getBizIdCode() {
        return bizIdCode;
    }

    public void setBizIdCode(String bizIdCode) {
        this.bizIdCode = bizIdCode;
    }

}
